/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileModuleType;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributesConfiguration {
    public static final ImmutableSet<ProfileModuleType> REQUIRED_MODULES = ImmutableSet.of((Object)((Object)ProfileModuleType.PERSONAL_DATA), (Object)((Object)ProfileModuleType.ROLES));
    public static final ImmutableSet<ProfileModuleType> DEFAULT_PROFILE_MODULES = ImmutableSet.copyOf((Collection)Sets.union((Set)ImmutableSet.of((Object)((Object)ProfileModuleType.SECTIONS)), REQUIRED_MODULES));
    private final ImmutableSet<ProfileModuleType> _modules;
    private final ImmutableList<ProfileSectionConfiguration> _sections;
    private final ImmutableMap<String, String> _attributesToSectionsConfigMap;
    private final ImmutableMap<String, ProfileAttributeConfiguration> _attributeNameToAttributeConfigMap;
    private final ImmutableMap<String, ProfileSectionConfiguration> _sectionNameToSectionConfigMap;

    public ProfileAttributesConfiguration(@Nullable @JsonProperty(value="modules", required=false) ImmutableSet<ProfileModuleType> modules, @JsonProperty(value="sections", required=true) ImmutableList<ProfileSectionConfiguration> sections) {
        this._sections = sections;
        this._modules = modules;
        ImmutableMap.Builder attributeToSectionConfigBuilder = ImmutableMap.builder();
        ImmutableMap.Builder attributeNameToAttributeConfigBuilder = ImmutableMap.builder();
        ImmutableMap.Builder sectionNameToSectionConfigBuilder = ImmutableMap.builder();
        for (ProfileSectionConfiguration section : this._sections) {
            sectionNameToSectionConfigBuilder.put((Object)section.getName(), (Object)section);
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                attributeToSectionConfigBuilder.put((Object)attribute.getName(), (Object)section.getName());
                attributeNameToAttributeConfigBuilder.put((Object)attribute.getName(), (Object)attribute);
            }
        }
        this._attributesToSectionsConfigMap = attributeToSectionConfigBuilder.build();
        this._attributeNameToAttributeConfigMap = attributeNameToAttributeConfigBuilder.build();
        this._sectionNameToSectionConfigMap = sectionNameToSectionConfigBuilder.build();
    }

    @Nonnull
    public ProfileAttributesConfiguration withRequiredData() {
        return new ProfileAttributesConfiguration(ProfileAttributesConfiguration.ensureRequiredModules(this._modules), ProfileAttributesConfiguration.ensureRequiredSectionAttributes(this._sections));
    }

    @Nonnull
    private static ImmutableList<ProfileSectionConfiguration> ensureRequiredSectionAttributes(ImmutableList<ProfileSectionConfiguration> sections) {
        HashSet<String> allDefinedNames = ProfileAttributesConfiguration.getAllDefinedNames(sections);
        ImmutableList.Builder result = ImmutableList.builder();
        for (ProfileSectionConfiguration section : sections) {
            result.add((Object)ProfileAttributesConfiguration.ensureChronologySectionHasPeriodAttribute(section, allDefinedNames));
        }
        return result.build();
    }

    @Nonnull
    private static HashSet<String> getAllDefinedNames(ImmutableList<ProfileSectionConfiguration> sections) {
        HashSet<String> result = new HashSet<String>();
        for (ProfileSectionConfiguration section : sections) {
            result.add(section.getName());
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                result.add(attribute.getName());
                ImmutableList<String> values = attribute.getValues();
                if (values == null) continue;
                result.addAll((Collection<String>)values);
            }
        }
        return result;
    }

    @Nonnull
    private static ProfileSectionConfiguration ensureChronologySectionHasPeriodAttribute(ProfileSectionConfiguration section, HashSet<String> allDefinedNames) {
        if (section.getType() != ProfileSectionType.CHRONOLOGY) {
            return section;
        }
        boolean hasPeriodAttribute = FluentIterable.from(section.getAttributes()).transform(ProfileAttributeConfiguration::getType).anyMatch(Predicates.equalTo((Object)((Object)ProfileAttributeType.MONTH_YEAR_PERIOD)));
        if (hasPeriodAttribute) {
            return section;
        }
        return new ProfileSectionConfiguration(section.getType(), section.getName(), (ImmutableList<ProfileAttributeConfiguration>)FluentIterable.from(section.getAttributes()).append((Object[])new ProfileAttributeConfiguration[]{ProfileAttributesConfiguration.createPeriodAttribute(section.getName(), allDefinedNames)}).toList(), section.getVisibleFor(), section.getVisibleFor(), section.isMultiple());
    }

    private static ProfileAttributeConfiguration createPeriodAttribute(String name, HashSet<String> allDefinedNames) {
        return new ProfileAttributeConfiguration(ProfileAttributeType.MONTH_YEAR_PERIOD, ProfileAttributesConfiguration.createUniqueNameFrom(name + "_period", allDefinedNames), null, Boolean.TRUE, null, null, null, null, null, null, null, null, null);
    }

    @Nonnull
    private static String createUniqueNameFrom(String suggestedName, HashSet<String> allDefinedNames) {
        if (!allDefinedNames.contains(suggestedName)) {
            allDefinedNames.add(suggestedName);
            return suggestedName;
        }
        int i = 0;
        while (allDefinedNames.contains(suggestedName + "_" + i)) {
            ++i;
        }
        String uniqueName = suggestedName + "_" + i;
        allDefinedNames.add(uniqueName);
        return uniqueName;
    }

    @Nonnull
    private static ImmutableSet<ProfileModuleType> ensureRequiredModules(@Nullable ImmutableSet<ProfileModuleType> modules) {
        if (modules == null || modules.isEmpty()) {
            return DEFAULT_PROFILE_MODULES;
        }
        if (modules.containsAll(REQUIRED_MODULES)) {
            return modules;
        }
        return ImmutableSet.builder().addAll(modules).addAll(REQUIRED_MODULES).build();
    }

    @Nonnull
    public ImmutableList<ProfileSectionConfiguration> getSections() {
        return this._sections;
    }

    @Nonnull
    public ImmutableSet<ProfileModuleType> getModules() {
        return this._modules;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sections", this._sections).add("modules", this._modules).toString();
    }

    @JsonIgnore
    @Nonnull
    public ImmutableMap<String, String> getAttributesToSectionsConfigMap() {
        return this._attributesToSectionsConfigMap;
    }

    @JsonIgnore
    @CheckForNull
    public ProfileAttributeConfiguration getAttributeByName(String name) {
        return (ProfileAttributeConfiguration)this._attributeNameToAttributeConfigMap.get((Object)name);
    }

    @JsonIgnore
    @Nonnull
    public ImmutableCollection<ProfileAttributeConfiguration> getAllAttributeConfigurations() {
        return this._attributeNameToAttributeConfigMap.values();
    }

    @JsonIgnore
    @Nonnull
    public ImmutableSet<String> getAllAttributeNames() {
        return this._attributeNameToAttributeConfigMap.keySet();
    }

    @JsonIgnore
    @CheckForNull
    public ProfileSectionConfiguration getSectionByName(String name) {
        return (ProfileSectionConfiguration)this._sectionNameToSectionConfigMap.get((Object)name);
    }
}

