/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileValidationErrorCode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class ProfileAttributeTreeValues {
    public static final ProfileAttributeTreeValues EMPTY = new ProfileAttributeTreeValues((ImmutableMap<String, ProfileAttributeTreeValue>)ImmutableMap.of());
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileAttributeTreeValues.class);
    private static final Pattern NODE_PATTERN = Pattern.compile("(\\**)[ ]*(\\w+)$");
    private final ImmutableMap<String, ProfileAttributeTreeValue> _nodes;

    private ProfileAttributeTreeValues(ImmutableMap<String, ProfileAttributeTreeValue> nodes) {
        this._nodes = nodes;
    }

    @Nonnull
    public ImmutableSet<String> getNames() {
        return this._nodes.keySet();
    }

    @CheckForNull
    public ProfileAttributeTreeValue getByName(String name) {
        return (ProfileAttributeTreeValue)this._nodes.get((Object)name);
    }

    @CheckForNull
    public ProfileAttributeTreeValue getByPath(String path) {
        return this.getByName(ProfileAttributeTreeValue.getNodeNameOfPath(path));
    }

    @CheckForNull
    public String getPath(String name) {
        ProfileAttributeTreeValue value = this.getByName(name);
        return value != null ? value.getPath() : null;
    }

    @Nonnull
    public static ProfileAttributeTreeValues getTreeValues(ProfileAttributeConfiguration config) {
        if (!ProfileAttributeType.TREE_SELECT.equals((Object)config.getType())) {
            return EMPTY;
        }
        ImmutableList<String> values = config.getValues();
        if (CollectionUtil.isEmpty(values)) {
            LOGGER.error("tree value attribute " + config.getName() + " has not even one tree value: ");
            return EMPTY;
        }
        try {
            return ProfileAttributeTreeValues.parse(values);
        }
        catch (ProfileAttributeTreeValueParseException e) {
            LOGGER.error("tree values of attribute " + config.getName() + " couldn't be parsed: ", (Throwable)e);
            return EMPTY;
        }
    }

    @Nonnull
    public static ProfileAttributeTreeValues parse(Iterable<String> values) {
        HashMap result = Maps.newHashMap();
        int currentLevel = 0;
        ProfileAttributeTreeValue currentParent = null;
        for (String value : values) {
            Matcher matcher = NODE_PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new ProfileAttributeTreeValueParseException(ProfileValidationErrorCode.INVALID_TREE_NODE, "Invalid tree value: " + value);
            }
            int targetLevel = matcher.group(1).length();
            String name = matcher.group(2);
            int steps = targetLevel - currentLevel;
            if (steps > 1 || steps == 1 && currentParent == null) {
                throw new ProfileAttributeTreeValueParseException(ProfileValidationErrorCode.INVALID_TREE_PARENT, "Invalid tree parent for value: " + value);
            }
            while (currentLevel >= targetLevel) {
                if (currentParent == null && currentLevel > 0) {
                    throw new ProfileAttributeTreeValueParseException(ProfileValidationErrorCode.INVALID_TREE_PARENT, "no tree parent for value: " + value);
                }
                currentParent = currentParent != null ? currentParent.getParent() : null;
                --currentLevel;
            }
            currentLevel = targetLevel;
            currentParent = ProfileAttributeTreeValues.createNode(name, currentParent, result);
        }
        return new ProfileAttributeTreeValues((ImmutableMap<String, ProfileAttributeTreeValue>)ImmutableMap.copyOf((Map)result));
    }

    @Nonnull
    private static ProfileAttributeTreeValue createNode(String name, @Nullable ProfileAttributeTreeValue parent, Map<String, ProfileAttributeTreeValue> result) {
        ProfileAttributeTreeValue treeValue = new ProfileAttributeTreeValue(name, parent);
        ProfileAttributeTreeValue existing = result.put(name, treeValue);
        if (existing != null) {
            throw new ProfileAttributeTreeValueParseException(ProfileValidationErrorCode.DUPLICATED_DEFINITON_OF_VALUES, "Duplicate tree value: " + name);
        }
        return treeValue;
    }

    @ParametersAreNonnullByDefault
    public static class ProfileAttributeTreeValue {
        public static final char PATH_DELIMITER = ',';
        private static final Joiner PATH_JOINER = Joiner.on((char)',').skipNulls();
        private static final Splitter PATH_SPLITTER = Splitter.on((char)',');
        private final String _name;
        private final ProfileAttributeTreeValue _parent;

        public ProfileAttributeTreeValue(String name, @Nullable ProfileAttributeTreeValue parent) {
            this._name = name;
            this._parent = parent;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        @CheckForNull
        public ProfileAttributeTreeValue getParent() {
            return this._parent;
        }

        @Nonnull
        public Iterable<String> getPathValues() {
            return this.getPathValues(Lists.newLinkedList());
        }

        @Nonnull
        private Iterable<String> getPathValues(LinkedList<String> list) {
            list.addFirst(this.getName());
            return this._parent != null ? this._parent.getPathValues(list) : list;
        }

        @Nonnull
        public String getPath() {
            return PATH_JOINER.join(this.getPathValues());
        }

        @Nonnull
        public static String getNodeNameOfPath(String path) {
            return (String)FluentIterable.from((Iterable)PATH_SPLITTER.split((CharSequence)path)).last().or((Object)path);
        }

        public int hashCode() {
            return Objects.hashCode(this.getPath());
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass() == obj.getClass() && Objects.equals(this.getPath(), ((ProfileAttributeTreeValue)ProfileAttributeTreeValue.class.cast(obj)).getPath());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.getName()).add("path", (Object)this.getPath()).toString();
        }
    }

    @ParametersAreNonnullByDefault
    public static final class ProfileAttributeTreeValueParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ProfileValidationErrorCode _errorCode;

        public ProfileAttributeTreeValueParseException(ProfileValidationErrorCode errorCode, String message) {
            super(message);
            this._errorCode = errorCode;
        }

        @Nonnull
        public ProfileValidationErrorCode getErrorCode() {
            return this._errorCode;
        }
    }
}

