/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@ParametersAreNonnullByDefault
public class ProfileAttributePeriod
implements Comparable<ProfileAttributePeriod> {
    public static final Function<String, ProfileAttributePeriod> FROM_MONTH_YEAR_PERIOD_STRING = new NullPermeableFunction<String, ProfileAttributePeriod>(){

        @Override
        protected ProfileAttributePeriod applySafe(String input) {
            try {
                return ProfileAttributePeriod.fromMonthYearPeriodString(input);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    };
    private static final Pattern MONTH_YEAR_PATTERN = Pattern.compile("(\\d{2})/(\\d{4})");
    private final DateTime _from;
    private final DateTime _to;

    public ProfileAttributePeriod(DateTime from, @Nullable DateTime to) {
        this._from = from;
        this._to = to;
    }

    @Nonnull
    public DateTime getFrom() {
        return this._from;
    }

    @CheckForNull
    public DateTime getTo() {
        return this._to;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._from, this._to});
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ProfileAttributePeriod && this.compareTo((ProfileAttributePeriod)obj) == 0;
    }

    @Override
    public int compareTo(ProfileAttributePeriod other) {
        int compareResult = this._from.compareTo((ReadableInstant)other._from);
        if (compareResult != 0) {
            return compareResult;
        }
        if (this._to == null || other._to == null) {
            return this._to == null ? (other._to == null ? 0 : 1) : -1;
        }
        return this._to.compareTo((ReadableInstant)other._to);
    }

    @Nonnull
    public String toMonthYearPeriodString() {
        StringBuilder result = new StringBuilder();
        if (this._from.getMonthOfYear() < 10) {
            result.append("0");
        }
        result.append(this._from.getMonthOfYear()).append("/").append(this._from.getYear()).append("-");
        if (this._to == null) {
            result.append("today");
        } else {
            if (this._to.getMonthOfYear() < 10) {
                result.append("0");
            }
            result.append(this._to.getMonthOfYear()).append("/").append(this._to.getYear());
        }
        return result.toString();
    }

    @Nonnull
    public static ProfileAttributePeriod fromMonthYearPeriodString(String monthYearPeriodString) throws IllegalArgumentException {
        String[] dates = monthYearPeriodString.split("-");
        if (dates.length != 2) {
            throw new IllegalArgumentException("From- and to-date of a MONTH_YEAR_PERIOD have to be separated by '-'.");
        }
        DateTime from = ProfileAttributePeriod.parseMonthYear(dates[0]);
        DateTime to = null;
        String toDateString = dates[1];
        if (toDateString != null && !toDateString.trim().toLowerCase().equals("today")) {
            to = ProfileAttributePeriod.parseMonthYear(toDateString);
        }
        return new ProfileAttributePeriod(from, to);
    }

    @Nonnull
    private static DateTime parseMonthYear(String monthYearString) throws IllegalArgumentException {
        Matcher matcher = MONTH_YEAR_PATTERN.matcher(monthYearString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Failed to parse '" + monthYearString + "'. Expected following pattern: MM/yyyy");
        }
        return new DateTime(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(1)), 1, 0, 0);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("from", (Object)this._from).add("to", (Object)this._to).toString();
    }
}

