/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.integration.persistence.ibatis;

import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.profile.integration.persistence.ProfileConfigurationDAO;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeConfigIbatisModel;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
@ParametersAreNonnullByDefault
public class IbatisProfileConfigurationDAO
implements ProfileConfigurationDAO {
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    public IbatisProfileConfigurationDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._transactionHelper = transactionHelper;
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("ProfileConfiguration");
    }

    @Override
    public void setProfileAttributeConfig(final ProfileAttributeConfigIbatisModel config) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisProfileConfigurationDAO.this._ibatisStatementBuilder.delete("deleteProfileAttributeConfig").noParam();
                IbatisProfileConfigurationDAO.this._ibatisStatementBuilder.insert("insertProfileAttributeConfig").param("config", config);
            }
        });
    }

    @Override
    public ProfileAttributeConfigIbatisModel getProfileAttributeConfig() {
        return (ProfileAttributeConfigIbatisModel)((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getProfileAttributeConfig").noParam()).asObject();
    }
}

