/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.profile.integration.persistence.ProfileAttributeDAO;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeIbatisModel;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
@ParametersAreNonnullByDefault
public class IbatisProfileAttributeDAO
implements ProfileAttributeDAO {
    private final IbatisStatementBuilder _ibatisStatementBuilder;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public IbatisProfileAttributeDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("ProfileAttribute");
        this._transactionHelper = transactionHelper;
    }

    @Override
    public void insertProfileAttributes(ImmutableList<ProfileAttributeIbatisModel> attributes) {
        this._ibatisStatementBuilder.insert("insertProfileAttributes").partition(ImmutableSet.copyOf(attributes));
    }

    @Override
    public int deleteProfileAttributesByIds(ImmutableSet<ProfileAttributeId> ids) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteProfileAttributeByIds").partition(ids);
    }

    @Override
    public int deleteProfileAttributesByPersonIds(ImmutableSet<PersonId> personIds) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteProfileAttributeByPersonIds").partition(personIds);
    }

    @Override
    public int deleteAllProfileAttributesForMigration() {
        return (Integer)this._ibatisStatementBuilder.delete("deleteAllProfileAttributes").noParam();
    }

    @Override
    public ImmutableListMultimap<PersonId, ProfileAttributeIbatisModel> getProfileAttributesByPersonIds(ImmutableSet<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getProfileAttributeByPersonIds").partition(personIds)).asListMultimap("personId", null);
    }

    @Override
    public void updateProfileAttributes(ImmutableList<ProfileAttributeIbatisModel> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        final ImmutableSet attributesSet = ImmutableSet.copyOf(attributes);
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisProfileAttributeDAO.this._ibatisStatementBuilder.delete("deleteProfileAttributes").partition(attributesSet);
                IbatisProfileAttributeDAO.this._ibatisStatementBuilder.insert("insertProfileAttributes").partition(attributesSet);
            }
        });
    }

    @Override
    public void deleteProfileAttributesByName(ProfileId profileId, Integer blockIndex, ImmutableList<String> attributeNames) {
        if (attributeNames.isEmpty()) {
            return;
        }
        this._ibatisStatementBuilder.delete("deleteProfileAttributesByNames").param("personId", profileId.asPersonId(), "blockIndex", blockIndex, "attributeNames", attributeNames);
    }
}

