/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonFullBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonFullDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonFullTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonPlaceholderBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonPlaceholderDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonPlaceholderTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonPopupModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.util.shared.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileTeaserServiceImpl
implements ProfileTeaserService {
    private static final ImmutableSet<? extends Action> PROFILE_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.PERSON_ADD_CONTACT, (Object)StaticAction.PERSON_REMOVE_CONTACT, (Object)StaticAction.PERSON_REMOVE_INVITATION, (Object)StaticAction.PERSON_EDIT, (Object)StaticAction.PERSON_DELETE, (Object)StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD, (Object[])new StaticAction[]{StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS, StaticAction.PERSON_BLOCK, StaticAction.PERSON_ACTIVATE});
    private final PersonService _personService;
    private final I18nService _i18nService;
    @Autowired
    private ProfileService _profileService;
    @Autowired
    private AuthorizationContextProvider _authContextProvider;
    @Autowired
    private FriendsService _friendsService;

    @Autowired
    public ProfileTeaserServiceImpl(PersonService personService, I18nService i18nService) {
        this._personService = personService;
        this._i18nService = i18nService;
    }

    @Override
    public PersonTeaserModel getPersonTeaserById(PersonId personId, AuthorizationCheckContextWithLocale authCtx) {
        DBPerson person = this._personService.getPersonById(personId);
        return person == null ? null : this.getPersonTeaserModelByDBPerson(person, authCtx);
    }

    @Override
    public PersonTeaserModel getPersonTeaserByIdNonnull(PersonId personId, AuthorizationCheckContextWithLocale authCtx) {
        return this.getPersonTeaserModelByDBPerson(this._personService.getPersonByIdNotNull(personId), authCtx);
    }

    @Override
    public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeasersByIds(Set<PersonId> personIds, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.getPersonTeaserForUser(this._personService.getProfileItemsByPersonIds(personIds), false, authorizationContext, new PersonTeaserModelFactory());
    }

    @Override
    public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserForUserWithFullNames(Set<PersonId> personIds, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.getPersonTeaserForUser(this._personService.getProfileItemsByPersonIds(personIds), true, authorizationContext, new PersonTeaserModelFactory());
    }

    @Override
    public ImmutableMap<PersonId, PersonTeaserModel> getPersonTeaserModelsByDBPersons(ImmutableMap<PersonId, ProfileItem> persons, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.getPersonTeaserForUser(persons, false, authorizationContext, new PersonTeaserModelFactory());
    }

    @Nonnull
    private <T extends PersonTeaserModel> ImmutableMap<PersonId, T> getPersonTeaserForUser(ImmutableMap<PersonId, ProfileItem> profiles, boolean containFullNameForNotVisibleProfiles, AuthorizationCheckContextWithLocale authorizationContext, AbstractPersonTeaserFactory<T, ?> resultFactory) {
        ImmutableSet<ProfileId> visibleProfileIds = authorizationContext.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)profiles.keySet().stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        Predicate visiblePredicate = Predicates.compose((Predicate)Predicates.in(visibleProfileIds), PersonId::asProfileId);
        Map<PersonId, ?> fullTeasers = resultFactory.createFull(Maps.filterKeys(profiles, (Predicate)visiblePredicate));
        resultBuilder.putAll(fullTeasers);
        Map invisible = Maps.filterKeys(profiles, (Predicate)Predicates.not((Predicate)visiblePredicate));
        BasicConstants constants = this._i18nService.createProxy(BasicConstants.class, authorizationContext.getLocale());
        resultBuilder.putAll(Maps.transformValues((Map)invisible, profileItem -> {
            if (profileItem == null) {
                return null;
            }
            DBPerson person = profileItem.getPerson();
            String teaserName = this.getNameForInvisiblePerson(person, constants, containFullNameForNotVisibleProfiles);
            return resultFactory.createPlaceholder(person.getId(), teaserName, person.isDeleted(), person.isActive(), person.isBlocked());
        }));
        return resultBuilder.build();
    }

    @Nonnull
    private String getNameForInvisiblePerson(DBPerson person, BasicConstants constants, boolean returnActualName) {
        if (person.isDeleted()) {
            return constants.deletedUser();
        }
        return returnActualName ? person.getFullName() : constants.secretItem();
    }

    @Override
    public PersonTeaserModel getPersonTeaserModelByDBPerson(DBPerson db, AuthorizationCheckContextWithLocale authorizationContext) {
        return (PersonTeaserModel)this.getPersonTeaserModelsByDBPersons(this._personService.getProfileItemsForPersons((Map<PersonId, DBPerson>)ImmutableMap.of((Object)db.getId(), (Object)db)), authorizationContext).get((Object)db.getId());
    }

    @Override
    public ImmutableMap<PersonId, PersonBadgeModel> getPersonBadgesByIds(Set<PersonId> personIds, AuthorizationCheckContextWithUserId authorizationContext) {
        return this.getPersonTeaserForUser(this._personService.getProfileItemsByPersonIds(personIds), false, authorizationContext, new PersonBadgeModelFactory(authorizationContext));
    }

    @Override
    public PersonDetailsModel getPersonDetailsModelById(PersonId personId, SearchAuthorizationCheckContext authorizationContext) throws InvalidIDException {
        ProfileItem profile = this._personService.getProfileItemByPersonId(personId);
        if (profile == null || profile.getPerson().isDeleted()) {
            throw new InvalidIDException(personId);
        }
        return InvalidIDException.check(personId, (PersonDetailsModel)this.getPersonTeaserForUser((ImmutableMap<PersonId, ProfileItem>)ImmutableMap.of((Object)personId, (Object)profile), false, authorizationContext, new PersonDetailsModelFactory(authorizationContext)).get((Object)personId));
    }

    @Override
    public ImmutableMap<PersonId, PersonPopupModel> getPersonPopupModelsByIds(ImmutableSet<PersonId> personIds, ImmutableSet<? extends Action> requiredActions, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet profileIds = FluentIterable.from(personIds).transform(PersonId.AS_PROFILE_ID).toSet();
        ImmutableSetMultimap maysById = authorizationContext.mayByIds(profileIds, requiredActions);
        ImmutableListMultimap<PersonId, BadgeField> visibleProfileBadgeFieldsById = this.getVisibleProfileBadgeFields((Set<PersonId>)personIds, authorizationContext);
        ImmutableMap<PersonId, ProfileItem> profileItems = this._personService.getProfileItemsByPersonIds((Set<PersonId>)personIds);
        ImmutableMap<PersonId, Boolean> mayChatWithPersons = this.getUserMayChatWithPersons(authorizationContext, (Map<PersonId, ProfileItem>)profileItems);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PersonId personId : personIds) {
            ImmutableSet mays = maysById.get((Object)Optional.of((Object)personId.asProfileId()));
            ImmutableList visibleDynamicAttributes = visibleProfileBadgeFieldsById.get((Object)personId);
            Boolean mayChatWith = (Boolean)mayChatWithPersons.get((Object)personId);
            builder.put((Object)personId, (Object)new PersonPopupModel((ImmutableSet<? extends Action>)mays, (ImmutableList<BadgeField>)visibleDynamicAttributes, mayChatWith != null && mayChatWith != false));
        }
        return builder.build();
    }

    @Override
    public ImmutableListMultimap<PersonId, BadgeField> getVisibleProfileBadgeFields(Set<PersonId> personIds, AuthorizationCheckContextWithUserId authCtx) {
        ImmutableSet<ProfileId> filteredIds = authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)personIds.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        ImmutableListMultimap<ProfileId, ProfileAttribute> profileAttributes = this._profileService.getVisibleAttributes((Set<ProfileId>)filteredIds, (Predicate<ProfileAttributeConfiguration>)((Predicate)ProfileAttributeConfiguration::isVisibleOnBadgeNullSafe), authCtx);
        HashMultimap presentBadgeFields = HashMultimap.create();
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry entry : profileAttributes.entries()) {
            ProfileId profileId = (ProfileId)entry.getKey();
            ProfileAttribute attribute = (ProfileAttribute)entry.getValue();
            if (attribute.getValues().isEmpty() || presentBadgeFields.get((Object)profileId).contains(attribute.getName())) continue;
            result.put((Object)profileId.asPersonId(), (Object)new BadgeField(attribute.getName(), this.getBadgeFieldType(attribute), attribute.getValues()));
            presentBadgeFields.put((Object)profileId, (Object)attribute.getName());
        }
        return result.build();
    }

    @Nonnull
    private BadgeFieldType getBadgeFieldType(ProfileAttribute attribute) {
        switch (attribute.getType()) {
            case CHECKRADIO: 
            case SELECT: {
                return BadgeFieldType.SELECT_VALUES;
            }
            case TREE_SELECT: {
                return BadgeFieldType.TREE_SELECT_VALUES;
            }
        }
        return BadgeFieldType.VALUES;
    }

    @Nonnull
    private ImmutableMap<PersonId, Boolean> getUserMayChatWithPersons(AuthorizationCheckContextWithUserId authContext, Map<PersonId, ProfileItem> profileItemMap) {
        ImmutableList profileItems = ImmutableList.copyOf(profileItemMap.values());
        Set authKeys = profileItems.stream().map(profileItem -> new AuthorizationKey<Object, StaticAction>(null, profileItem.getPerson(), StaticAction.CONNECT_USE)).collect(Collectors.toSet());
        ImmutableSet allowedToChatKeys = this._authContextProvider.getPersonIndependentAuthorizationContext().may(authKeys);
        Iterable profileItemsAllowedToChatWith = authContext.filterAllowedItems(profileItems, StaticAction.CONVERSATION_CREATE);
        ImmutableSet personIdsAllowedToChatWith = (ImmutableSet)Streams.stream(profileItemsAllowedToChatWith).map(profileItem -> profileItem.getId().asPersonId()).collect(ImmutableSet.toImmutableSet());
        boolean allowedToUseChat = authContext.may(StaticAction.CONNECT_USE);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<PersonId, ProfileItem> entry : profileItemMap.entrySet()) {
            PersonId personId = entry.getKey();
            ProfileItem profileItem2 = entry.getValue();
            if (profileItem2 == null) {
                result.put((Object)personId, (Object)Boolean.FALSE);
                continue;
            }
            AuthorizationKey<Object, StaticAction> authKey = new AuthorizationKey<Object, StaticAction>(null, profileItem2.getPerson(), StaticAction.CONNECT_USE);
            boolean mayChatWith = allowedToUseChat && personIdsAllowedToChatWith.contains((Object)personId) && allowedToChatKeys.contains(authKey);
            result.put((Object)personId, (Object)mayChatWith);
        }
        return result.build();
    }

    private class PersonBadgeModelFactory
    extends AbstractPersonTeaserFactory<PersonBadgeModel, PersonFullBadgeModel> {
        private final AuthorizationCheckContextWithUserId _authorizationContext;

        PersonBadgeModelFactory(AuthorizationCheckContextWithUserId authorizationContext) {
            this._authorizationContext = authorizationContext;
        }

        @Override
        Map<PersonId, PersonFullBadgeModel> createFull(Map<PersonId, ProfileItem> persons) {
            if (persons.isEmpty()) {
                return ImmutableMap.of();
            }
            Iterable profileIds = Iterables.transform(persons.keySet(), PersonId.AS_PROFILE_ID);
            ImmutableSet visibleDynamicAttributePersonIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)profileIds, ProfileId.TO_PERSON_ID));
            ImmutableListMultimap<PersonId, BadgeField> visibleProfileBadgeFields = ProfileTeaserServiceImpl.this.getVisibleProfileBadgeFields((Set<PersonId>)visibleDynamicAttributePersonIds, this._authorizationContext);
            return Maps.transformValues(persons, input -> {
                if (input == null) {
                    return null;
                }
                PersonFullBadgeModel result = new PersonFullBadgeModel();
                DBPerson person = input.getPerson();
                this.fillTeaserBase(person, result);
                result.setVisibleFields((List<BadgeField>)visibleProfileBadgeFields.get((Object)person.getId()));
                return result;
            });
        }

        @Override
        PersonBadgeModel createPlaceholder(PersonId id, String secretProfile, boolean deleted, boolean active, boolean blocked) {
            return new PersonPlaceholderBadgeModel(id, secretProfile, deleted, active, blocked);
        }
    }

    private class PersonDetailsModelFactory
    extends AbstractPersonTeaserFactory<PersonDetailsModel, PersonFullDetailsModel> {
        private final SearchAuthorizationCheckContext _authorizationContext;

        PersonDetailsModelFactory(SearchAuthorizationCheckContext authorizationContext) {
            this._authorizationContext = authorizationContext;
        }

        @Override
        public Map<PersonId, PersonFullDetailsModel> createFull(Map<PersonId, ProfileItem> profiles) {
            if (profiles.isEmpty()) {
                return ImmutableMap.of();
            }
            Iterable profileIds = Iterables.transform(profiles.keySet(), PersonId.AS_PROFILE_ID);
            ImmutableSetMultimap may = this._authorizationContext.mayByIds(profileIds, PROFILE_CHECK_ACTIONS);
            ImmutableTable<PersonId, ComponentType, ComponentModel> visibleComponents = ProfileTeaserServiceImpl.this._personService.getVisibleComponents(profiles, this._authorizationContext);
            ImmutableMap<PersonId, Boolean> mayChatWithPersons = ProfileTeaserServiceImpl.this.getUserMayChatWithPersons(this._authorizationContext, profiles);
            return Maps.transformValues(profiles, input -> {
                if (input == null) {
                    return null;
                }
                PersonFullDetailsModel result = new PersonFullDetailsModel();
                DBPerson person = input.getPerson();
                this.fillTeaserBase(person, result);
                PersonId personId = person.getId();
                ProfileId profileId = personId.asProfileId();
                result.setMay((ImmutableSet<Action>)may.get((Object)Optional.of((Object)profileId)));
                result.setInvitationPending(ProfileTeaserServiceImpl.this._friendsService.hasInvited(personId, this._authorizationContext.getUserId()));
                result.setComponents((ImmutableList<ComponentModel>)ImmutableList.copyOf((Collection)visibleComponents.row((Object)personId).values()));
                result.setOtherUserDoNotSeeAllComponents(false);
                result.setNotAllComponentIsVisibleForCurrentUser(!Iterables.all((Iterable)visibleComponents.values(), ComponentModel.IS_VISIBLE_PREDICATE));
                Boolean mayChatWith = (Boolean)mayChatWithPersons.get((Object)personId);
                result.setMayChatWith(mayChatWith != null && mayChatWith != false);
                return result;
            });
        }

        @Override
        PersonDetailsModel createPlaceholder(PersonId id, String secretProfile, boolean deleted, boolean active, boolean blocked) {
            return new PersonPlaceholderDetailsModel(id, secretProfile, deleted, active, blocked);
        }
    }

    private static class PersonTeaserModelFactory
    extends AbstractPersonTeaserFactory<PersonTeaserModel, PersonFullTeaserModel> {
        private PersonTeaserModelFactory() {
        }

        @Override
        PersonTeaserModel createPlaceholder(PersonId id, String secretProfile, boolean deleted, boolean active, boolean blocked) {
            return new PersonPlaceholderTeaserModel(id, secretProfile, deleted, active, blocked);
        }

        @Override
        Map<PersonId, PersonFullTeaserModel> createFull(Map<PersonId, ProfileItem> persons) {
            return Maps.transformValues(persons, (Function)new NullPermeableFunction<ProfileItem, PersonFullTeaserModel>(){

                @Override
                protected PersonFullTeaserModel applySafe(ProfileItem input) {
                    PersonFullTeaserModel result = new PersonFullTeaserModel();
                    this.fillTeaserBase(input.getPerson(), result);
                    return result;
                }
            });
        }
    }

    private static abstract class AbstractPersonTeaserFactory<T extends PersonTeaserModel, FT extends PersonFullTeaserModel> {
        private AbstractPersonTeaserFactory() {
        }

        protected final void fillTeaserBase(@Nonnull DBPerson dbPerson, @Nonnull FT teaser) {
            ((PersonFullTeaserModel)teaser).setShortName(dbPerson.getShortName());
            ((PersonFullTeaserModel)teaser).setFullName(dbPerson.getFullName());
            ((PersonFullTeaserModel)teaser).setId(dbPerson.getId());
            ((PersonFullTeaserModel)teaser).setLogo(dbPerson.getImage());
            ((PersonFullTeaserModel)teaser).setActive(dbPerson.isActive());
            ((PersonFullTeaserModel)teaser).setLanguageId(dbPerson.getLanguageId());
            ((PersonFullTeaserModel)teaser).setBlocked(dbPerson.isBlocked());
            ((PersonFullTeaserModel)teaser).setDeleted(dbPerson.isDeleted());
            ((PersonFullTeaserModel)teaser).setFirstname(dbPerson.getFirstName());
            ((PersonFullTeaserModel)teaser).setLastname(dbPerson.getLastName());
        }

        @Nonnull
        abstract T createPlaceholder(@Nonnull PersonId var1, @Nonnull String var2, boolean var3, boolean var4, boolean var5);

        @Nonnull
        abstract Map<PersonId, FT> createFull(@Nonnull Map<PersonId, ProfileItem> var1);
    }
}

