/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.freiheit.toro.account.shared.model.settings.Birthday;
import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.authorization.business.impl.AuthorizationCheckContextWithRole;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.server.util.StorageServerUtil;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.business.PersonUpdateCommand;
import de.justsoftware.onx.person.business.PersonValidator;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.person.shared.model.NameSettingsBean;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileReadWriteDataService;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.profile.business.events.ProfileAttributeConfigurationChangedEvent;
import de.justsoftware.onx.profile.business.events.ProfileAttributesChangedEvent;
import de.justsoftware.onx.profile.model.Profile;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributePeriod;
import de.justsoftware.onx.profile.model.ProfileAttributeSearchType;
import de.justsoftware.onx.profile.model.ProfileAttributeTreeValues;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfilePersonalData;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionType;
import de.justsoftware.onx.profile.model.ProfileValidationErrorCode;
import de.justsoftware.onx.profile.model.ProfileValidationErrorMessage;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import de.justsoftware.onx.util.shared.Lists;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@ParametersAreNonnullByDefault
public class ProfileServiceImpl
implements ProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileServiceImpl.class);
    private static final ImmutableSet<? extends Action> PROFILE_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.PERSON_EDIT, (Object)StaticAction.PERSON_EDIT_IMAGE);
    private static final ImmutableSet<Role> NO_ROLES = ImmutableSet.of();
    private static final ProfileAttributesConfiguration EMPTY_ATTRIBUTES_CONFIGURATION = new ProfileAttributesConfiguration(ProfileAttributesConfiguration.DEFAULT_PROFILE_MODULES, (ImmutableList<ProfileSectionConfiguration>)ImmutableList.of());
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    private final PersonService _personService;
    private final PersonValidator _personValidator;
    private final ProfileReadWriteDataService _profileReadWriteDataService;
    private final TransactionHelper _transactionHelper;
    private final PersonRoleService _personRoleService;
    private final ItemService _itemService;
    private final StorageServerHelper _storageServerHelper;
    private final ImmutableSet<String> _acceptableImageUploadTypes;
    private final Settings _settings;
    private final JCEventBus _eventBus;
    private final ConfigFileService _configFileService;
    private final PersonSettingService _personSettingService;
    private final ProfileTeaserService _profileTeaserService;
    private final PersonReadWriteDataService _personReadWriteDataService;
    private final Clock _clock;

    @Autowired
    public ProfileServiceImpl(PersonService personService, PersonValidator personValidator, ProfileReadWriteDataService profileReadWriteDataService, PersonRoleService personRoleService, ItemService itemService, TransactionHelper transactionHelper, StorageServerHelper storageServerHelper, Settings settings, JCEventBus eventBus, ConfigFileService configFileService, PersonSettingService personSettingService, ProfileTeaserService profileTeaserService, PersonReadWriteDataService personReadWriteDataService, Clock clock) {
        this._personService = personService;
        this._personValidator = personValidator;
        this._profileReadWriteDataService = profileReadWriteDataService;
        this._personRoleService = personRoleService;
        this._itemService = itemService;
        this._transactionHelper = transactionHelper;
        this._storageServerHelper = storageServerHelper;
        this._settings = settings;
        this._acceptableImageUploadTypes = ImmutableSet.of((Object)"jpg", (Object)"jpe", (Object)"jpeg", (Object)"jfif", (Object)"jfif-tbnl", (Object)"gif", (Object[])new String[]{"png"});
        this._eventBus = eventBus;
        this._configFileService = configFileService;
        this._personSettingService = personSettingService;
        this._profileTeaserService = profileTeaserService;
        this._personReadWriteDataService = personReadWriteDataService;
        this._clock = clock;
    }

    @Override
    public Profile getProfileById(ProfileId profileId, AuthorizationCheckContextWithUserId authContext) {
        DBPerson person = this._personService.getPersonById(profileId.asPersonId());
        if (person == null) {
            return null;
        }
        PersonTeaserModel teaser = this._profileTeaserService.getPersonTeaserModelByDBPerson(person, authContext);
        boolean visible = authContext.may(ProfileReadRole.of(profileId));
        if (person.isDeleted()) {
            return new Profile(profileId, null, "Deleted", "Profile", null, "Deleted Profile", ImageUrlUtil.getFullOriginalUserImageUrl(null), (ImmutableSet<PersonRole>)ImmutableSet.of(), false, false, true, false, (ImmutableSet<Action>)ImmutableSet.of(), false, null, true, null, BirthdayVisibility.NONE, null, false);
        }
        ProfileAttributes profileAttributes = visible ? this.getVisibleAttributesById(profileId, authContext) : null;
        ImmutableSet<Action> allowedActions = this.getAllowedRoleActionsForProfile(profileId, authContext);
        ImmutableSet<PersonRole> visibleRoles = this.getVisibleRoles((Iterable<PersonRole>)this._personRoleService.getPersonRoles(profileId.asPersonId()), allowedActions);
        ImmutableSet<PersonRole> editableRoles = this.getEditableRoles(allowedActions);
        boolean hasAcceptedProfileImageLegalTerms = this._personSettingService.getSettings(person.getId()).isAcceptedProfileImageLegalTerms();
        ImmutableSet<String> hiddenFields = this._settings.getHiddenPersonFields();
        String title = visible && !hiddenFields.contains((Object)"person.title") ? person.getTitle() : null;
        String additionalTitle = visible && !hiddenFields.contains((Object)"person.additionalTitle") ? person.getAdditionalTitle() : null;
        TimeZone timeZone = visible && !hiddenFields.contains((Object)"person.timezone") ? (TimeZone)((Object)MoreObjects.firstNonNull((Object)((Object)person.getTimeZone()), (Object)((Object)this._settings.getDefaultTimeZone()))) : null;
        Birthday birthday = null;
        BirthdayVisibility birthdayVisibility = null;
        if (visible && !hiddenFields.contains((Object)"person.birthday")) {
            birthdayVisibility = person.getBirthdayVisibility();
            birthday = Birthday.create(person.getBirthday(), birthdayVisibility);
        }
        return new Profile(profileId, title, teaser.getFirstname(), teaser.getLastname(), additionalTitle, teaser.getFullName(), ImageUrlUtil.getFullOriginalUserImageUrl(teaser.getLogo()), visibleRoles, person.isActive(), person.isBlocked(), person.isDeleted(), visible, authContext.may((ItemId)profileId, PROFILE_CHECK_ACTIONS), !editableRoles.isEmpty(), profileAttributes, teaser.getLogo() == null, birthday, birthdayVisibility, timeZone, hasAcceptedProfileImageLegalTerms);
    }

    @Nonnull
    private ImmutableSet<Action> getAllowedRoleActionsForProfile(ProfileId profileId, AuthorizationCheckContext authContext) {
        ImmutableSet actions = FluentIterable.from(this._configFileService.getConfigFile().getAllPersonRoles()).transform(Role.TO_NAME).transform(DynamicActionCreator.PROFILE_MODIFY_ROLES.createFunction()).filter(Action.class).append((Object[])new Action[]{StaticAction.SEE_HIDDEN_ROLES}).toSet();
        return authContext.may((ItemId)profileId, (ImmutableSet<? extends Action>)actions);
    }

    @Nonnull
    private ImmutableSet<PersonRole> getVisibleRoles(Iterable<PersonRole> roles, ImmutableSet<Action> allowedActions) {
        if (allowedActions.contains((Object)StaticAction.SEE_HIDDEN_ROLES)) {
            return ImmutableSet.copyOf(roles);
        }
        ImmutableSet<PersonRole> hiddenRoles = this._configFileService.getConfigFile().getHiddenPersonRoles();
        return FluentIterable.from(roles).filter(Predicates.not((Predicate)Predicates.in(hiddenRoles))).toSet();
    }

    @Override
    public ImmutableSet<PersonRole> getEditableRolesForProfile(ProfileId profileId, SearchAuthorizationCheckContext authContext) {
        ImmutableSet<Action> allowedActions = this.getAllowedRoleActionsForProfile(profileId, authContext);
        return this.getEditableRoles(allowedActions);
    }

    @Nonnull
    private ImmutableSet<PersonRole> getEditableRoles(ImmutableSet<Action> allowedActions) {
        FluentIterable editableRoles = FluentIterable.from(this._configFileService.getConfigFile().getAllPersonRoles()).filter(Predicates.compose((Predicate)Predicates.in(allowedActions), (Function)Functions.compose(DynamicActionCreator.PROFILE_MODIFY_ROLES.createFunction(), Role.TO_NAME)));
        return this.getVisibleRoles((Iterable<PersonRole>)editableRoles, allowedActions);
    }

    @Override
    public ProfileAttributesConfiguration getAttributesConfigurationForEditing(AuthorizationCheckContext authContext) throws PermissionDeniedException {
        authContext.check(StaticAction.PROFILE_EDIT_ATTRIBUTES_CONFIG);
        return this._profileReadWriteDataService.getAttributesConfiguration();
    }

    @Override
    public ProfileAttributesConfiguration getAttributesConfigurationForRegistration(AuthorizationCheckContext nullableAuthCtx) throws PermissionDeniedException {
        AuthorizationCheckContext authCtx = nullableAuthCtx != null ? nullableAuthCtx : this._authorizationContextProvider.getAuthorizationContextForNotLoggedInUser();
        ProfileAttributesConfiguration profileAttributesCfg = this.getVisibleAttributesConfiguration(null, authCtx);
        ImmutableSet registrationFields = ImmutableSet.copyOf(this._personValidator.getRegistrationFields());
        ImmutableList.Builder sections = ImmutableList.builder();
        for (ProfileSectionConfiguration sectionCfg : profileAttributesCfg.getSections()) {
            ImmutableList.Builder attributesBuilder = ImmutableList.builder();
            for (ProfileAttributeConfiguration attributeCfg : sectionCfg.getAttributes()) {
                if (!registrationFields.contains((Object)("person.dynamic." + attributeCfg.getName()))) continue;
                attributesBuilder.add((Object)attributeCfg);
            }
            ImmutableList attributes = attributesBuilder.build();
            if (attributes.isEmpty()) continue;
            sections.add((Object)new ProfileSectionConfiguration(sectionCfg.getType(), sectionCfg.getName(), (ImmutableList<ProfileAttributeConfiguration>)attributes, sectionCfg.getVisibleFor(), sectionCfg.getAvailableFor(), sectionCfg.isMultiple()));
        }
        return new ProfileAttributesConfiguration(profileAttributesCfg.getModules(), (ImmutableList<ProfileSectionConfiguration>)sections.build());
    }

    @Override
    public void setAttributesConfiguration(ProfileAttributesConfiguration profileAttributesConfiguration, AuthorizationCheckContext authContext) throws PermissionDeniedException {
        authContext.check(StaticAction.PROFILE_EDIT_ATTRIBUTES_CONFIG);
        this.validateAttributesConfiguration(profileAttributesConfiguration);
        this._profileReadWriteDataService.setConfiguration(profileAttributesConfiguration);
        this._eventBus.post(new ProfileAttributeConfigurationChangedEvent());
    }

    private void validateProfileAttributeIdentifier(@Nullable String identifier, String errorKey, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            validationErrors.put((Object)errorKey, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.NAME_REQUIRED, "Name is required!"));
        } else if (!PROFILE_ATTRIBUTE_IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            validationErrors.put((Object)errorKey, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.NAME_INVALID, "Name '" + identifier + "' contains invalid characters! Only number, letters and underscore are allowed!"));
        }
    }

    private void validateRoles(String name, @Nullable ImmutableSet<String> availableRoles, ImmutableSet<String> allowedRoles, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        if (CollectionUtil.isEmpty(availableRoles)) {
            return;
        }
        for (String role : availableRoles) {
            if (allowedRoles.contains((Object)role)) continue;
            validationErrors.put((Object)name, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.ROLE_INVALID, "Invalid role: " + role, (ImmutableMap<String, String>)ImmutableMap.of((Object)"role", (Object)role)));
        }
    }

    private void validateTextAttributeConfiguration(ProfileAttributeConfiguration attribute, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        Integer maxLength;
        if (!CollectionUtil.isEmpty(attribute.getValues())) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUES_CONFIG_NOT_ALLOWED, "Values are not allowed to be defined for attribute of type '" + attribute.getType() + "'."));
        }
        if ((maxLength = attribute.getMaxLength()) != null && maxLength <= 0) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.MAX_LENGTH_CONFIG_INVALID, "MaxLength must be greater than 0."));
        }
    }

    private void validateSelectAttributeConfiguration(ProfileAttributeConfiguration attribute, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        this.validateAttributeHasValidUniqueValues(attribute, validationErrors);
        Integer maxLength = attribute.getMaxLength();
        if (maxLength != null) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.MAX_LENGTH_CONFIG_NOT_ALLOWED, "MaxLength is not allowed to be defined for attribute of type '" + attribute.getType() + "'."));
        }
    }

    private void validateAttributeHasValidUniqueValues(ProfileAttributeConfiguration attribute, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        ImmutableList<String> values = attribute.getValues();
        if (CollectionUtil.isEmpty(values)) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUES_CONFIG_REQUIRED, "Values have to be defined for attribute of type '" + attribute.getType() + "'."));
        } else {
            HashSet<String> existsValues = new HashSet<String>();
            for (String value : values) {
                if (!existsValues.add(value.toLowerCase())) {
                    validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.DUPLICATED_DEFINITON_OF_VALUES, "Duplicate definition of value '" + value + "' are not allowed."));
                    continue;
                }
                this.validateProfileAttributeIdentifier(value, attribute.getName(), validationErrors);
            }
        }
    }

    private void validateTreeSelectAttributeConfiguration(ProfileAttributeConfiguration attribute, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        ImmutableList<String> values = attribute.getValues();
        if (CollectionUtil.isEmpty(values)) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUES_CONFIG_REQUIRED, "Values have to be defined for attribute of type '" + attribute.getType() + "'."));
        } else {
            try {
                ProfileAttributeTreeValues.parse(values);
            }
            catch (ProfileAttributeTreeValues.ProfileAttributeTreeValueParseException e) {
                validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(e.getErrorCode(), e.getMessage()));
            }
        }
        Integer maxLength = attribute.getMaxLength();
        if (maxLength != null) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.MAX_LENGTH_CONFIG_NOT_ALLOWED, "MaxLength is not allowed to be defined for attribute of type '" + attribute.getType() + "'."));
        }
    }

    private void valideAttributeConfiguration(ProfileSectionType sectionType, ProfileAttributeConfiguration attribute, ImmutableSet<String> allRoles, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        if (BooleanUtils.isTrue((Boolean)attribute.isRequired()) && BooleanUtils.isTrue((Boolean)attribute.isReadOnly())) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.READONLY_REQUIRED_ATTRIBUTE_NOT_ALLOWED, "Readonly required attributes are not allowed."));
        }
        this.validateProfileAttributeIdentifier(attribute.getName(), attribute.getName(), validationErrors);
        this.validateRoles(attribute.getName(), attribute.getVisibleFor(), allRoles, validationErrors);
        switch (attribute.getType()) {
            case TEXTAREA: 
            case TEXT: 
            case TEXT_PHONE: {
                this.validateTextAttributeConfiguration(attribute, validationErrors);
                break;
            }
            case CHECKRADIO: 
            case SELECT: {
                this.validateSelectAttributeConfiguration(attribute, validationErrors);
                break;
            }
            case TREE_SELECT: {
                this.validateTreeSelectAttributeConfiguration(attribute, validationErrors);
                break;
            }
            case MONTH_YEAR_PERIOD: {
                this.validateMonthYearPeriodAttributeConfiguration(attribute, sectionType, validationErrors);
                break;
            }
            case DESCRIPTION: {
                this.validateDescriptionAttributeConfiguration(attribute, validationErrors);
            }
        }
    }

    private void validateAttributesConfiguration(ProfileAttributesConfiguration profileAttributesConfiguration) throws ProfileValidationException {
        HashSet names = Sets.newHashSet();
        ArrayListMultimap validationErrors = ArrayListMultimap.create();
        ImmutableSet allRoles = this._personRoleService.getAllPersonAndStaticRoles().keySet();
        for (ProfileSectionConfiguration section : profileAttributesConfiguration.getSections()) {
            if (!names.add(section.getName().toLowerCase())) {
                validationErrors.put((Object)section.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.SECTION_NAME_IN_USE, "Section name is already being used for another section or attribute."));
            }
            this.validateProfileAttributeIdentifier(section.getName(), section.getName(), (ArrayListMultimap<String, ProfileValidationErrorMessage>)validationErrors);
            this.validateRoles(section.getName(), section.getVisibleFor(), (ImmutableSet<String>)allRoles, (ArrayListMultimap<String, ProfileValidationErrorMessage>)validationErrors);
            ImmutableList<ProfileAttributeConfiguration> attributes = section.getAttributes();
            if (attributes.size() > 0) {
                int periodFieldCount = 0;
                for (ProfileAttributeConfiguration attribute : attributes) {
                    if (!names.add(attribute.getName().toLowerCase())) {
                        validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.ATTRIBUTE_NAME_IN_USE, "Attribute name is already being used for another section or attribute."));
                    }
                    this.valideAttributeConfiguration(section.getType(), attribute, (ImmutableSet<String>)allRoles, (ArrayListMultimap<String, ProfileValidationErrorMessage>)validationErrors);
                    if (attribute.getType() != ProfileAttributeType.MONTH_YEAR_PERIOD) continue;
                    ++periodFieldCount;
                }
                if (periodFieldCount <= true || section.getType() != ProfileSectionType.CHRONOLOGY) continue;
                validationErrors.put((Object)section.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.DUPLICATED_DEFINITON_OF_PERIOD_ATTRIBUTE, "Section of type CHRONOLOGY must only have on attribute of type MONTH_YEAR_PERIOD."));
                continue;
            }
            validationErrors.put((Object)section.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.SECTION_NEEDS_ATTRIBUTES, "Section is empty. A section must have at least one attribute."));
        }
        if (!validationErrors.isEmpty()) {
            throw new ProfileValidationException((ImmutableListMultimap<String, ProfileValidationErrorMessage>)ImmutableListMultimap.copyOf((Multimap)validationErrors));
        }
    }

    private void validateDescriptionAttributeConfiguration(ProfileAttributeConfiguration attribute, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        this.validateAttributeHasValidUniqueValues(attribute, validationErrors);
        if (BooleanUtils.isNotTrue((Boolean)attribute.isReadOnly())) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.ATTRIBUTE_MUST_BE_READONLY, "The attribute of type '" + attribute.getType() + "' must be read only."));
        }
        if (ProfileAttributeSearchType.isSearchable(attribute)) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.ATTRIBUTE_MUST_NOT_BE_SEARCHABLE, "The attribute of type '" + attribute.getType() + "' must not be searchable."));
        }
    }

    private void validateMonthYearPeriodAttributeConfiguration(ProfileAttributeConfiguration attribute, ProfileSectionType sectionType, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        Integer maxLength;
        if (!CollectionUtil.isEmpty(attribute.getValues())) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUES_CONFIG_NOT_ALLOWED, "Values are not allowed to be defined for attribute of type '" + attribute.getType() + "'."));
        }
        if ((maxLength = attribute.getMaxLength()) != null) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.MAX_LENGTH_CONFIG_NOT_ALLOWED, "MaxLength is not allowed to be defined for attribute of type '" + attribute.getType() + "'."));
        }
        if (ProfileSectionType.CHRONOLOGY.equals((Object)sectionType) && BooleanUtils.isNotTrue((Boolean)attribute.isRequired())) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.CHRONOLOGY_PERIOD_NEEDS_TO_BE_REQUIRED, "Chronology section period attribute needs to be required."));
        }
    }

    private void validateProfileAttributeMultiplicity(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        if (BooleanUtils.isNotTrue((Boolean)attributeCfg.isMultiple()) && attribute.getValues().size() > 1) {
            validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.MULTI_VALUES_NOT_ALLOWED, "Only one value allowed."));
        }
    }

    private void validateRequiredProfileAttribute(@Nullable ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        if (BooleanUtils.isTrue((Boolean)attributeCfg.isRequired()) && (attribute == null || attribute.getValues().isEmpty())) {
            validationErrors.put((Object)attributeCfg.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUE_REQUIRED, "Value is required."));
        }
    }

    private void validateAttributeBlock(String sectionName, ProfileAttributeBlock block, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors, ProfileAttributesConfiguration profileAttributesConfiguration) {
        ImmutableMap<String, String> attributesToSectionsMap = profileAttributesConfiguration.getAttributesToSectionsConfigMap();
        if (block.getAttributes().isEmpty()) {
            validationErrors.put((Object)sectionName, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.EMPTY_BLOCK_NOT_ALLOWED, "Saving a empty block is not allowed."));
        }
        for (ProfileAttribute attribute : block.getAttributes()) {
            String sectionNameFromConfig = (String)attributesToSectionsMap.get((Object)attribute.getName());
            ProfileAttributeConfiguration attributeCfg = profileAttributesConfiguration.getAttributeByName(attribute.getName());
            if (!sectionName.equals(sectionNameFromConfig) || attributeCfg == null) {
                validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.ATTRIBUTE_NOT_EXISTS, "Attribute '" + attribute.getName() + "' does not exist"));
                continue;
            }
            this.validateProfileAttributeMultiplicity(attribute, attributeCfg, validationErrors);
            this.validateRequiredProfileAttribute(attribute, attributeCfg, validationErrors);
            this.validateAttributeValues(attribute, attributeCfg, validationErrors);
        }
        ProfileSectionConfiguration sectionByName = profileAttributesConfiguration.getSectionByName(sectionName);
        if (sectionByName != null) {
            ImmutableSet alreadyValidatedAttributesNames = FluentIterable.from(block.getAttributes()).transform(ProfileAttribute.TO_NAME).toSet();
            this.validateRequiredBlockAttributes(sectionByName, (ImmutableSet<String>)alreadyValidatedAttributesNames, validationErrors);
        }
    }

    private void validateAttributeValues(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        switch (attributeCfg.getType()) {
            case CHECKRADIO: 
            case SELECT: {
                this.validateSelectAttribute(attribute, attributeCfg, validationErrors);
                break;
            }
            case TREE_SELECT: {
                this.validateTreeSelectAttribute(attribute, attributeCfg, validationErrors);
                break;
            }
            case TEXTAREA: 
            case TEXT: 
            case TEXT_PHONE: {
                this.validateTextAttribute(attribute, attributeCfg, validationErrors);
                break;
            }
            case MONTH_YEAR_PERIOD: {
                this.validateMonthYearPeriodAttribute(attribute, attributeCfg, validationErrors);
                break;
            }
        }
    }

    private void validateRequiredBlockAttributes(ProfileSectionConfiguration sectionConfig, ImmutableSet<String> attributeNamesToIgnore, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        ImmutableList<ProfileAttributeConfiguration> sectionAttributes = sectionConfig.getAttributes();
        for (ProfileAttributeConfiguration attrCfg : sectionAttributes) {
            if (attributeNamesToIgnore.contains((Object)attrCfg.getName())) continue;
            this.validateRequiredProfileAttribute(null, attrCfg, validationErrors);
        }
    }

    private void validateMonthYearPeriodAttribute(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        for (String value : attribute.getValues()) {
            this.validateMonthYear(attributeCfg.getName(), value, validationErrors);
        }
    }

    private void validateMonthYear(String name, String periodString, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        try {
            ProfileAttributePeriod period = ProfileAttributePeriod.fromMonthYearPeriodString(periodString);
            DateTime to = period.getTo();
            if (to != null && period.getFrom().isAfter((ReadableInstant)to)) {
                validationErrors.put((Object)name, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.FROM_DATE_AFTER_TO_DATE, "From-date have not to be after to-date.", (ImmutableMap<String, String>)ImmutableMap.of((Object)"value", (Object)periodString)));
            }
        }
        catch (IllegalArgumentException e) {
            validationErrors.put((Object)name, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUE_INVALID, "Period '" + periodString + "' is invalid. Expected following pattern: mm/YYYY-{mm/YYYY|today}. E.g.: \n12/2014-today\n02/2011-07/2015", (ImmutableMap<String, String>)ImmutableMap.of((Object)"value", (Object)periodString)));
        }
    }

    private void validateSelectAttribute(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        ImmutableList<String> allowedValues = attributeCfg.getValues();
        if (!CollectionUtil.isEmpty(allowedValues)) {
            for (String value : attribute.getValues()) {
                if (allowedValues.contains((Object)value)) continue;
                validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUE_INVALID, "Value '" + value + "' is not valid.", (ImmutableMap<String, String>)ImmutableMap.of((Object)"value", (Object)value)));
            }
        }
    }

    private void validateTreeSelectAttribute(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        ImmutableSet<String> allowedValues = attributeCfg.getTreeValues().getNames();
        if (!CollectionUtil.isEmpty(allowedValues)) {
            for (String path : attribute.getValues()) {
                String value = ProfileAttributeTreeValues.ProfileAttributeTreeValue.getNodeNameOfPath(path);
                if (allowedValues.contains((Object)value)) continue;
                validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUE_INVALID, "Value '" + value + "' is not valid.", (ImmutableMap<String, String>)ImmutableMap.of((Object)"value", (Object)value)));
            }
        }
    }

    private void validateTextAttribute(ProfileAttribute attribute, ProfileAttributeConfiguration attributeCfg, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors) {
        Integer maxLength = attributeCfg.getMaxLength();
        if (maxLength != null) {
            int l = maxLength;
            for (String value : attribute.getValues()) {
                if (value.length() <= l) continue;
                validationErrors.put((Object)attribute.getName(), (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.VALUE_TOO_LONG, "Value '" + value + "' is too long (max length: " + l + ").", (ImmutableMap<String, String>)ImmutableMap.of((Object)"maxLength", (Object)maxLength.toString(), (Object)"value", (Object)value)));
            }
        }
    }

    @Nonnull
    private ProfileAttributeBlock validateAndFixBlockMultiplicity(ProfileId profileId, String sectionName, ProfileAttributeBlock block, ArrayListMultimap<String, ProfileValidationErrorMessage> validationErrors, ProfileAttributesConfiguration visibleAttributesConfiguration) {
        ImmutableList<ProfileAttributeBlock> currentBlocks;
        ProfileSectionConfiguration sectionConfiguration = visibleAttributesConfiguration.getSectionByName(sectionName);
        if (sectionConfiguration == null) {
            validationErrors.put((Object)sectionName, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.SECTION_NOT_EXISTS, "Section '" + sectionName + "' not exists."));
            return block;
        }
        if (BooleanUtils.isTrue((Boolean)sectionConfiguration.isMultiple())) {
            return block;
        }
        ProfileSection currentSection = (ProfileSection)this._profileReadWriteDataService.getProfileSection(profileId, (ImmutableSet<String>)ImmutableSet.of((Object)sectionName), this._profileReadWriteDataService.getAttributesConfiguration()).get((Object)sectionName);
        ImmutableList<ProfileAttributeBlock> immutableList = currentBlocks = currentSection != null ? currentSection.getAttributeBlocks() : ImmutableList.of();
        if (currentBlocks.isEmpty() || currentBlocks.size() == 1 && com.google.common.base.Objects.equal((Object)((ProfileAttributeBlock)currentBlocks.get(0)).getOrderIndex(), (Object)block.getOrderIndex())) {
            return block;
        }
        ProfileAttributeBlock currentBlock = (ProfileAttributeBlock)currentBlocks.get(0);
        if (currentBlocks.size() == 1 && this.onlyContainsInvisibleAttributes(currentBlock, visibleAttributesConfiguration)) {
            return new ProfileAttributeBlock(currentBlock.getOrderIndex(), block.getAttributes());
        }
        validationErrors.put((Object)sectionName, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.TOO_MANY_SECTION_BLOCKS, "Only one section block is allowed."));
        return block;
    }

    private boolean onlyContainsInvisibleAttributes(ProfileAttributeBlock block, ProfileAttributesConfiguration visibleAttributesConfiguration) {
        if (block.getAttributes().isEmpty()) {
            return false;
        }
        ImmutableSet<String> visibleAttributeNames = visibleAttributesConfiguration.getAllAttributeNames();
        for (ProfileAttribute attribute : block.getAttributes()) {
            if (!visibleAttributeNames.contains((Object)attribute.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ProfileAttributeBlock saveProfileAttributeBlock(ProfileId profileId, String sectionName, ProfileAttributeBlock block, AuthorizationCheckContext authContext) throws PermissionDeniedException, ProfileValidationException {
        ProfileAttributesConfiguration visibleAttributesConfiguration = this.getVisibleAttributesConfiguration(profileId, authContext);
        ImmutableMap<String, Integer> newOrderIndexes = this.internalSaveProfileAttributeBlocks(profileId, (ImmutableMap<String, ProfileAttributeBlock>)ImmutableMap.of((Object)sectionName, (Object)block), visibleAttributesConfiguration, authContext);
        Integer newOrderIndex = (Integer)newOrderIndexes.get((Object)sectionName);
        if (newOrderIndex == null) {
            throw new IllegalStateException("Could not save the profile attributes");
        }
        ProfileSection profileSection = (ProfileSection)this._profileReadWriteDataService.getProfileSection(profileId, (ImmutableSet<String>)ImmutableSet.of((Object)sectionName), visibleAttributesConfiguration).get((Object)sectionName);
        if (profileSection == null) {
            throw new IllegalStateException("Can't load section of newly created profile attribute block");
        }
        for (ProfileAttributeBlock loadedBlock : profileSection.getAttributeBlocks()) {
            if (!com.google.common.base.Objects.equal((Object)loadedBlock.getOrderIndex(), (Object)newOrderIndex)) continue;
            return loadedBlock;
        }
        throw new IllegalStateException("Can't load newly created profile attribute block");
    }

    @Override
    public void updateProfileAttributeSection(ProfileId profileId, String sectionName, ImmutableList<ProfileAttributeBlock> updatedBlocks, AuthorizationCheckContextWithUserId authContext) {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        this.validateNoReadOnlyAttributesAreUpdated(profileId, sectionName, authContext, updatedBlocks);
        ProfileSection existingSection = this.getProfileSection(profileId, sectionName, authContext);
        ImmutableList<ProfileAttributeBlock> mergedBlocks = existingSection == null ? updatedBlocks : this.mergeBlocks(existingSection.getAttributeBlocks(), updatedBlocks);
        this.checkProfileSectionValid(profileId, sectionName, mergedBlocks, authContext);
        this._profileReadWriteDataService.saveProfileSection(profileId, sectionName, mergedBlocks);
    }

    private void validateNoReadOnlyAttributesAreUpdated(ProfileId profileId, String sectionName, AuthorizationCheckContextWithUserId authContext, ImmutableList<ProfileAttributeBlock> updatedBlocks) {
        ProfileAttributesConfiguration config = this.getVisibleAttributesConfiguration(profileId, authContext);
        ProfileSectionConfiguration sectionConfig = config.getSectionByName(sectionName);
        if (sectionConfig == null) {
            throw new IllegalStateException("Trying to update a section that does not exist.");
        }
        ImmutableSet readOnlyAttributes = (ImmutableSet)sectionConfig.getAttributes().stream().filter(attributeConfig -> Boolean.TRUE.equals(attributeConfig.isReadOnly())).map(ProfileAttributeConfiguration::getName).collect(ImmutableSet.toImmutableSet());
        boolean updatedBlocksContainReadOnlyAttributes = updatedBlocks.stream().flatMap(block -> block.getAttributes().stream().map(ProfileAttribute::getName)).anyMatch(arg_0 -> ((ImmutableSet)readOnlyAttributes).contains(arg_0));
        if (updatedBlocksContainReadOnlyAttributes) {
            throw new IllegalStateException("Trying to update readOnly attribute.");
        }
    }

    @Nonnull
    private ImmutableList<ProfileAttributeBlock> mergeBlocks(ImmutableList<ProfileAttributeBlock> existingBlocks, ImmutableList<ProfileAttributeBlock> updatedBlocks) {
        Map<Integer, ProfileAttributeBlock> updatedBlocksByIndex = Lists.toMap(updatedBlocks, ProfileAttributeBlock::getOrderIndex);
        Map<Integer, ProfileAttributeBlock> existingBlocksByIndex = Lists.toMap(existingBlocks, ProfileAttributeBlock::getOrderIndex);
        Sets.SetView allBlockIndices = Sets.union(existingBlocksByIndex.keySet(), updatedBlocksByIndex.keySet());
        return (ImmutableList)allBlockIndices.stream().map(index -> this.mergeBlock((ProfileAttributeBlock)existingBlocksByIndex.get(index), (ProfileAttributeBlock)updatedBlocksByIndex.get(index))).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @CheckForNull
    private ProfileAttributeBlock mergeBlock(@Nullable ProfileAttributeBlock existingBlock, @Nullable ProfileAttributeBlock updatedBlock) {
        Integer updatedIndex;
        if (existingBlock == null) {
            return updatedBlock;
        }
        if (updatedBlock == null) {
            return existingBlock;
        }
        Integer existingIndex = existingBlock.getOrderIndex();
        if (!com.google.common.base.Objects.equal((Object)existingIndex, (Object)(updatedIndex = updatedBlock.getOrderIndex()))) {
            throw new IllegalStateException("Trying to merge two blocks with different indices!");
        }
        ImmutableList<ProfileAttribute> existingAttributes = existingBlock.getAttributes();
        ImmutableList<ProfileAttribute> updatedAttributes = updatedBlock.getAttributes();
        Map<String, ProfileAttribute> existingAttributesByName = Lists.toMap(existingAttributes, ProfileAttribute::getName);
        Map<String, ProfileAttribute> updatedAttributesByName = Lists.toMap(updatedAttributes, ProfileAttribute::getName);
        Sets.SetView allAttributeNames = Sets.union(existingAttributesByName.keySet(), updatedAttributesByName.keySet());
        ImmutableList mergedAttributes = (ImmutableList)allAttributeNames.stream().map(name -> (ProfileAttribute)MoreObjects.firstNonNull((Object)((ProfileAttribute)updatedAttributesByName.get(name)), (Object)((ProfileAttribute)existingAttributesByName.get(name)))).filter(this::hasValues).collect(ImmutableList.toImmutableList());
        return mergedAttributes.size() == 0 ? null : new ProfileAttributeBlock(existingIndex, (ImmutableList<ProfileAttribute>)mergedAttributes);
    }

    private boolean hasValues(ProfileAttribute attribute) {
        return attribute.getValues().stream().anyMatch(value -> !value.isEmpty());
    }

    private void checkProfileSectionValid(ProfileId profileId, String sectionName, ImmutableList<ProfileAttributeBlock> blocks, AuthorizationCheckContext authContext) throws ProfileValidationException, IllegalArgumentException {
        ProfileAttributesConfiguration config = this.getVisibleAttributesConfiguration(profileId, authContext);
        ProfileSectionConfiguration sectionConfig = config.getSectionByName(sectionName);
        if (sectionConfig == null) {
            throw new IllegalArgumentException("Section " + sectionName + " does not exist.");
        }
        if (Boolean.FALSE.equals(sectionConfig.isMultiple()) && blocks.size() > 1) {
            throw new IllegalArgumentException("Section " + sectionName + " can't have multiple blocks!");
        }
        ArrayListMultimap errors = ArrayListMultimap.create();
        blocks.forEach(block -> this.validateAttributeBlock(sectionName, (ProfileAttributeBlock)block, (ArrayListMultimap<String, ProfileValidationErrorMessage>)errors, config));
        if (!errors.isEmpty()) {
            throw new ProfileValidationException((ImmutableListMultimap<String, ProfileValidationErrorMessage>)ImmutableListMultimap.copyOf((Multimap)errors));
        }
    }

    @Override
    public void saveProfileAttributeBlocksFromRegistration(ProfileId profileId, ImmutableMap<String, ProfileAttributeBlock> blocks, AuthorizationCheckContext authContext) throws PermissionDeniedException, ProfileValidationException {
        ProfileAttributesConfiguration registrationAttributesConfiguration = this.getAttributesConfigurationForRegistration(authContext);
        this.internalSaveProfileAttributeBlocks(profileId, blocks, registrationAttributesConfiguration, authContext);
    }

    @Nonnull
    private ImmutableMap<String, Integer> internalSaveProfileAttributeBlocks(ProfileId profileId, ImmutableMap<String, ProfileAttributeBlock> blocks, ProfileAttributesConfiguration visibleAttributesConfiguration, AuthorizationCheckContext authContext) throws PermissionDeniedException, ProfileValidationException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        ImmutableMap<String, ProfileAttributeBlock> blocksFixed = this.validateAttributeBlocks(profileId, blocks, visibleAttributesConfiguration);
        HashMap blocksFiltered = Maps.newHashMap();
        for (Map.Entry sectionBlock : blocksFixed.entrySet()) {
            ProfileAttributeBlock blockFiltered = this.filterReadOnlyAttributes((ProfileAttributeBlock)sectionBlock.getValue(), visibleAttributesConfiguration);
            if (blockFiltered.getAttributes().isEmpty()) {
                throw new IllegalArgumentException("You cannot save a block that only contains read-only attributes");
            }
            blocksFiltered.put((String)sectionBlock.getKey(), blockFiltered);
        }
        ImmutableMap newOrderIndexes = (ImmutableMap)this._transactionHelper.doInTransaction(status -> {
            ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
            for (Map.Entry sectionBlock : blocksFiltered.entrySet()) {
                String sectionName = (String)sectionBlock.getKey();
                ProfileAttributeBlock block = (ProfileAttributeBlock)sectionBlock.getValue();
                Integer orderIndex = block.getOrderIndex();
                if (orderIndex != null) {
                    this._profileReadWriteDataService.deleteVisibleAndWritableProfileBlockAttributes(profileId, sectionName, visibleAttributesConfiguration, orderIndex);
                }
                int dbOrderIndex = this._profileReadWriteDataService.insertProfileAttributeBlock(profileId, sectionName, block);
                resultBuilder.put((Object)sectionName, (Object)dbOrderIndex);
            }
            this._personReadWriteDataService.updatePersonModifyDate(profileId.asPersonId(), this._clock.nowDate());
            return resultBuilder.build();
        });
        this._eventBus.post(new ProfileAttributesChangedEvent(profileId.asPersonId()));
        return newOrderIndexes;
    }

    @Nonnull
    private ImmutableMap<String, ProfileAttributeBlock> validateAttributeBlocks(ProfileId profileId, ImmutableMap<String, ProfileAttributeBlock> blocks, ProfileAttributesConfiguration visibleAttributesConfiguration) throws ProfileValidationException {
        ArrayListMultimap validationErrors = ArrayListMultimap.create();
        ImmutableMap.Builder fixedAttributeBlocks = ImmutableMap.builder();
        for (Map.Entry sectionBlock : blocks.entrySet()) {
            String sectionName = (String)sectionBlock.getKey();
            ProfileAttributeBlock fixedBlock = this.validateAndFixBlockMultiplicity(profileId, sectionName, (ProfileAttributeBlock)sectionBlock.getValue(), (ArrayListMultimap<String, ProfileValidationErrorMessage>)validationErrors, visibleAttributesConfiguration);
            this.validateAttributeBlock(sectionName, fixedBlock, (ArrayListMultimap<String, ProfileValidationErrorMessage>)validationErrors, visibleAttributesConfiguration);
            fixedAttributeBlocks.put((Object)sectionName, (Object)fixedBlock);
        }
        if (!validationErrors.isEmpty()) {
            throw new ProfileValidationException((ImmutableListMultimap<String, ProfileValidationErrorMessage>)ImmutableListMultimap.copyOf((Multimap)validationErrors));
        }
        return fixedAttributeBlocks.build();
    }

    @Override
    public ImmutableListMultimap<String, ProfileValidationErrorMessage> validateRegistrationProfileAttributes(ImmutableMap<String, ProfileAttributeBlock> blocks) {
        ProfileAttributesConfiguration attributesConfiguration = this.getAttributesConfigurationForRegistration(null);
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Map.Entry sectionBlock : blocks.entrySet()) {
            this.validateAttributeBlock((String)sectionBlock.getKey(), (ProfileAttributeBlock)sectionBlock.getValue(), (ArrayListMultimap<String, ProfileValidationErrorMessage>)result, attributesConfiguration);
        }
        for (ProfileSectionConfiguration sectionConfig : attributesConfiguration.getSections()) {
            if (blocks.containsKey((Object)sectionConfig.getName())) continue;
            this.validateRequiredBlockAttributes(sectionConfig, (ImmutableSet<String>)ImmutableSet.of(), (ArrayListMultimap<String, ProfileValidationErrorMessage>)result);
        }
        return ImmutableListMultimap.copyOf((Multimap)result);
    }

    @Nonnull
    private ProfileAttributeBlock filterReadOnlyAttributes(ProfileAttributeBlock block, final ProfileAttributesConfiguration visibleAttributesConfiguration) {
        ImmutableList attributesFiltered = FluentIterable.from(block.getAttributes()).filter((Predicate)new NullIsFalsePredicate<ProfileAttribute>(){

            @Override
            protected boolean applySafe(ProfileAttribute attribute) {
                ProfileAttributeConfiguration attributeCfg = visibleAttributesConfiguration.getAttributeByName(attribute.getName());
                return attributeCfg != null && BooleanUtils.isNotTrue((Boolean)attributeCfg.isReadOnly());
            }
        }).toList();
        return new ProfileAttributeBlock(block.getOrderIndex(), (ImmutableList<ProfileAttribute>)attributesFiltered);
    }

    @Override
    public ImmutableMap<String, Object> getProfileAttributesDefaultTranslations() {
        HashMap result = Maps.newHashMap();
        ProfileAttributesConfiguration config = this._profileReadWriteDataService.getAttributesConfiguration();
        for (ProfileSectionConfiguration section : config.getSections()) {
            result.put(section.getName(), section.getName());
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                ImmutableList values;
                if (attribute.getType() == ProfileAttributeType.MONTH_YEAR_PERIOD) {
                    result.put(attribute.getName(), "Period");
                } else {
                    result.put(attribute.getName(), attribute.getName());
                }
                if (CollectionUtil.isEmpty(values = ProfileAttributeType.TREE_SELECT.equals((Object)attribute.getType()) ? attribute.getTreeValues().getNames().asList() : attribute.getValues())) continue;
                for (String value : values) {
                    result.put(value, value);
                }
            }
        }
        return ImmutableMap.of((Object)"profileAttribute", (Object)result);
    }

    @Nonnull
    private ImmutableSet<Role> toRoleSet(@Nullable ImmutableSet<String> roles, ImmutableMap<String, ? extends Role> allPersonAndStaticRoles) {
        if (CollectionUtil.isEmpty(roles)) {
            return ImmutableSet.of();
        }
        return FluentIterable.from(roles).transform(Functions.forMap(allPersonAndStaticRoles, null)).filter(Predicates.notNull()).toSet();
    }

    @Nonnull
    private ImmutableSetMultimap<RoleConfigType, Role> getConfiguredRolesFromConfig(ProfileAttributesConfiguration configuration) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        ImmutableMap<String, ? extends Role> allPersonAndStaticRoles = this._personRoleService.getAllPersonAndStaticRoles();
        for (ProfileSectionConfiguration section : configuration.getSections()) {
            builder.putAll((Object)RoleConfigType.VISIBLE_FOR, this.toRoleSet(section.getVisibleFor(), allPersonAndStaticRoles));
            builder.putAll((Object)RoleConfigType.AVAILABLE_FOR, this.toRoleSet(section.getAvailableFor(), allPersonAndStaticRoles));
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                builder.putAll((Object)RoleConfigType.VISIBLE_FOR, this.toRoleSet(attribute.getVisibleFor(), allPersonAndStaticRoles));
                builder.putAll((Object)RoleConfigType.AVAILABLE_FOR, this.toRoleSet(attribute.getAvailableFor(), allPersonAndStaticRoles));
            }
        }
        return builder.build();
    }

    private boolean isNeededRolesFulfilled(@Nullable ImmutableSet<String> neededRoles, ImmutableSet<String> roles) {
        if (CollectionUtil.isEmpty(neededRoles)) {
            return true;
        }
        return !Sets.intersection(neededRoles, roles).isEmpty();
    }

    @Nonnull
    private ProfileAttributesConfiguration filterRolesSectionAndAttributes(ImmutableSet<Role> profileRoles, ImmutableSet<Role> viewerRoles, ProfileAttributesConfiguration config) {
        ImmutableList.Builder sectionBuilder = ImmutableList.builder();
        ImmutableSet viewerRolenames = FluentIterable.from(viewerRoles).transform(Role.TO_NAME).toSet();
        ImmutableSet profileRolenames = FluentIterable.from(profileRoles).transform(Role.TO_NAME).toSet();
        for (ProfileSectionConfiguration section : config.getSections()) {
            if (!this.isNeededRolesFulfilled(section.getVisibleFor(), (ImmutableSet<String>)viewerRolenames) || !this.isNeededRolesFulfilled(section.getAvailableFor(), (ImmutableSet<String>)profileRolenames)) continue;
            ImmutableList.Builder attributeBuilder = ImmutableList.builder();
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                if (!this.isNeededRolesFulfilled(attribute.getVisibleFor(), (ImmutableSet<String>)viewerRolenames) || !this.isNeededRolesFulfilled(attribute.getAvailableFor(), (ImmutableSet<String>)profileRolenames)) continue;
                attributeBuilder.add((Object)attribute);
            }
            ImmutableList visibleAttributes = attributeBuilder.build();
            if (visibleAttributes.isEmpty()) continue;
            sectionBuilder.add((Object)new ProfileSectionConfiguration(section.getType(), section.getName(), (ImmutableList<ProfileAttributeConfiguration>)visibleAttributes, section.getVisibleFor(), section.getAvailableFor(), section.isMultiple()));
        }
        return new ProfileAttributesConfiguration(config.getModules(), (ImmutableList<ProfileSectionConfiguration>)sectionBuilder.build());
    }

    @Override
    public ProfileAttributesConfiguration getVisibleAttributesConfiguration(ProfileId id, AuthorizationCheckContext authContext) {
        if (id != null) {
            return (ProfileAttributesConfiguration)this.getVisibleAttributesConfigurations((Set<ProfileId>)ImmutableSet.of((Object)id), authContext).get((Object)id);
        }
        ProfileAttributesConfiguration allConfiguration = this._profileReadWriteDataService.getAttributesConfiguration();
        ImmutableSetMultimap<RoleConfigType, Role> configuredRoles = this.getConfiguredRolesFromConfig(allConfiguration);
        ImmutableSet visibleForRoles = configuredRoles.get((Object)RoleConfigType.VISIBLE_FOR);
        ImmutableSet availableForRoles = configuredRoles.get((Object)RoleConfigType.AVAILABLE_FOR);
        return this.filterRolesSectionAndAttributes(authContext.hasAuthorities((Item<?>)null, availableForRoles), authContext.hasAuthorities((Item<?>)null, visibleForRoles), allConfiguration);
    }

    @Override
    public ImmutableMap<ProfileId, ProfileAttributesConfiguration> getVisibleAttributesConfigurations(Set<ProfileId> ids, final AuthorizationCheckContext authContext) {
        final ImmutableMap profiles = FluentIterable.from((Iterable)this._itemService.getByIds(ids).values()).filter(ProfileItem.class).uniqueIndex(ProfileItem.TO_ID);
        final ProfileAttributesConfiguration allConfiguration = this._profileReadWriteDataService.getAttributesConfiguration();
        ImmutableSetMultimap<RoleConfigType, Role> configuredRoles = this.getConfiguredRolesFromConfig(allConfiguration);
        final ImmutableSet visibleForRoles = configuredRoles.get((Object)RoleConfigType.VISIBLE_FOR);
        final ImmutableSet availableForRoles = configuredRoles.get((Object)RoleConfigType.AVAILABLE_FOR);
        final PersonIndependentAuthorizationContext commonContext = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        return FluentIterable.from(ids).toMap((Function)new NullPermeableFunction<ProfileId, ProfileAttributesConfiguration>(){

            @Override
            protected ProfileAttributesConfiguration applySafe(ProfileId id) {
                ProfileItem profile = (ProfileItem)profiles.get((Object)id);
                return profile != null ? ProfileServiceImpl.this.filterRolesSectionAndAttributes(commonContext.hasAuthorities(profile, profile.getPerson(), (ImmutableSet<? extends Role>)NO_ROLES, availableForRoles), authContext.hasAuthorities(profile, visibleForRoles), allConfiguration) : EMPTY_ATTRIBUTES_CONFIGURATION;
            }
        });
    }

    @Override
    public ProfileAttributes getVisibleAttributesById(ProfileId profileId, AuthorizationCheckContext authContext) {
        if (!authContext.may(ProfileReadRole.of(profileId))) {
            return null;
        }
        return this._profileReadWriteDataService.getProfileAttributesByProfileId(profileId, this.getVisibleAttributesConfiguration(profileId, authContext));
    }

    @Override
    public void saveProfileImage(ProfileId profileId, MultipartFile image, AuthorizationCheckContext authContext) throws PermissionDeniedException, InvalidIdServiceException, IOException {
        PersonId personId = profileId.asPersonId();
        ProfileItem profileItem = InvalidIdServiceException.check(this._personService.getProfileItemByPersonId(personId));
        authContext.check(profileItem, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.PERSON_EDIT, (Object)StaticAction.PERSON_EDIT_IMAGE));
        this.validateProfileImage(image);
        DBPerson person = profileItem.getPerson();
        String oldImage = person.getImage();
        String ext = this._storageServerHelper.getExtension(image.getOriginalFilename());
        String filename = StorageServerUtil.createRandomFilenameOfProfileImage(personId, ext);
        String contentType = image.getContentType();
        String contentFormatType = contentType != null ? StorageServerUtil.getFormatNameFromContentType(contentType) : null;
        String formatTypeInput = contentFormatType != null ? contentFormatType : this._storageServerHelper.getFormatNameFromFilename(image.getOriginalFilename());
        SaveImageResult saveResult = this._storageServerHelper.saveFileOnStorageServer(image.getInputStream(), formatTypeInput, ImageType.USER_IMAGE.getPath(), filename, (Collection<ImageSize>)StorageServerHelper.DEFAULT_IMAGE_SIZES, true);
        if (!saveResult.isOk()) {
            throw new ServiceException("Failed to save profile image for " + profileId + ". Failure message from storageserver is: " + saveResult.getMessage());
        }
        try {
            this._personService.updateImage(personId, filename);
            this._personSettingService.setAcceptedProfileImageLegalTerms(personId, true);
        }
        catch (ServiceException e) {
            this._storageServerHelper.deleteFileOnStorageServer(ImageType.USER_IMAGE.getPath(), filename);
            throw e;
        }
        if (oldImage != null) {
            this._storageServerHelper.deleteFileOnStorageServer(ImageType.USER_IMAGE.getPath(), oldImage);
        }
    }

    @Override
    public void deleteProfileImage(ProfileId profileId, AuthorizationCheckContext authContext) throws IOException, ServiceException, ValidatableException {
        PersonId personId = profileId.asPersonId();
        ProfileItem profileItem = InvalidIdServiceException.check(this._personService.getProfileItemByPersonId(personId));
        authContext.check(profileItem, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.PERSON_EDIT, (Object)StaticAction.PERSON_EDIT_IMAGE));
        this._personService.removeImage(personId);
        this._personSettingService.setAcceptedProfileImageLegalTerms(personId, false);
    }

    private void validateProfileImage(MultipartFile file) throws ProfileValidationException, IOException {
        ArrayListMultimap validationErrors = ArrayListMultimap.create();
        String filename = file.getOriginalFilename();
        if (!this.isContentTypeAcceptable(filename)) {
            validationErrors.put((Object)filename, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.IMAGE_TYPE_INVALID, "File is not a JPG, PNG or GIF file."));
        }
        if (!this.isFileSizeAcceptable(file.getSize())) {
            validationErrors.put((Object)filename, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.IMAGE_SIZE_TOO_LARGE, "File size too large."));
        }
        if (!this.isValidDimension(file.getInputStream())) {
            validationErrors.put((Object)filename, (Object)new ProfileValidationErrorMessage(ProfileValidationErrorCode.IMAGE_DIMESIONS_TOO_LARGE, "File dimensions too large."));
        }
        if (!validationErrors.isEmpty()) {
            throw new ProfileValidationException((ImmutableListMultimap<String, ProfileValidationErrorMessage>)ImmutableListMultimap.copyOf((Multimap)validationErrors));
        }
    }

    private boolean isFileSizeAcceptable(long fileSize) {
        return fileSize <= this._settings.getImageMaxFileSize();
    }

    protected boolean isContentTypeAcceptable(String filename) {
        String type = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
        return this._acceptableImageUploadTypes.contains((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidDimension(InputStream inputStream) {
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
            ImageReader reader = null;
            try {
                reader = (ImageReader)Iterators.getNext(ImageIO.getImageReaders(iis), null);
                if (reader != null) {
                    reader.setInput(iis);
                    if (reader.getWidth(0) * reader.getHeight(0) > 16000000) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (iis != null) {
                    iis.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("image meta data could not be read." + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ProfileSection getProfileSection(ProfileId profileId, String sectionName, AuthorizationCheckContextWithUserId authContext) {
        authContext.check(ProfileReadRole.of(profileId));
        ProfileAttributesConfiguration visibleAttrConfig = this.getVisibleAttributesConfiguration(profileId, authContext);
        return (ProfileSection)this._profileReadWriteDataService.getProfileSection(profileId, (ImmutableSet<String>)ImmutableSet.of((Object)sectionName), visibleAttrConfig).get((Object)sectionName);
    }

    @Override
    public int deleteVisibleAndWritableProfileBlockAttributes(ProfileId profileId, String sectionName, int orderIndex, AuthorizationContext authCtx) {
        ProfileAttributesConfiguration visibleAttributesConfiguration = this.getVisibleAttributesConfiguration(profileId, authCtx);
        int deletedEntries = this._profileReadWriteDataService.deleteVisibleAndWritableProfileBlockAttributes(profileId, sectionName, visibleAttributesConfiguration, orderIndex);
        if (deletedEntries > 0) {
            this._eventBus.post(new ProfileAttributesChangedEvent(profileId.asPersonId()));
        }
        return deletedEntries;
    }

    @Override
    public ImmutableListMultimap<ProfileId, ProfileSection> getVisibleSections(Set<ProfileId> ids, AuthorizationCheckContext authCtx) {
        authCtx.check((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)ids.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        ImmutableMap<ProfileId, ProfileAttributesConfiguration> attributesConfigurations = this.getVisibleAttributesConfigurations(ids, authCtx);
        ImmutableMap<ProfileId, ProfileAttributes> profileAttributesByProfileId = this._profileReadWriteDataService.getProfileAttributesByProfileId((Map<ProfileId, ProfileAttributesConfiguration>)attributesConfigurations);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : profileAttributesByProfileId.entrySet()) {
            builder.putAll((Object)((ProfileId)entry.getKey()), ((ProfileAttributes)entry.getValue()).getSections());
        }
        return builder.build();
    }

    @Override
    public ImmutableListMultimap<ProfileId, ProfileAttribute> getVisibleAttributesForInternalUseOnly(Set<ProfileId> ids, Predicate<ProfileAttributeConfiguration> filterPredicate) {
        AuthorizationCheckContextWithRole loggedInAuthContext = this._authorizationContextProvider.getAuthorizationCheckContextForRoles((ImmutableSet<? extends Role>)ImmutableSet.of((Object)StaticPredefinedRole.LOGGED_IN));
        ImmutableMap<ProfileId, ProfileAttributesConfiguration> attributesConfigurations = this.getVisibleAttributesConfigurations(ids, loggedInAuthContext);
        return this.getVisibleAttributesWithoutProfileReadRoleCheck(filterPredicate, attributesConfigurations);
    }

    @Override
    public ImmutableListMultimap<ProfileId, ProfileAttribute> getVisibleAttributes(Set<ProfileId> ids, Predicate<ProfileAttributeConfiguration> filterPredicate, AuthorizationCheckContext authCtx) {
        authCtx.check((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)ids.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        ImmutableMap<ProfileId, ProfileAttributesConfiguration> attributesConfigurations = this.getVisibleAttributesConfigurations(ids, authCtx);
        return this.getVisibleAttributesWithoutProfileReadRoleCheck(filterPredicate, attributesConfigurations);
    }

    private ImmutableListMultimap<ProfileId, ProfileAttribute> getVisibleAttributesWithoutProfileReadRoleCheck(Predicate<ProfileAttributeConfiguration> filterPredicate, ImmutableMap<ProfileId, ProfileAttributesConfiguration> visibleAttributesConfigurations) {
        ImmutableMap<ProfileId, ProfileAttributes> profileAttributesByProfileId = this._profileReadWriteDataService.getProfileAttributesByProfileId((Map<ProfileId, ProfileAttributesConfiguration>)visibleAttributesConfigurations);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : profileAttributesByProfileId.entrySet()) {
            ProfileAttributesConfiguration config = (ProfileAttributesConfiguration)MoreObjects.firstNonNull((Object)((ProfileAttributesConfiguration)visibleAttributesConfigurations.get(entry.getKey())), (Object)EMPTY_ATTRIBUTES_CONFIGURATION);
            for (ProfileSection section : ((ProfileAttributes)entry.getValue()).getSections()) {
                for (ProfileAttributeBlock attributeBlock : section.getAttributeBlocks()) {
                    for (ProfileAttribute attribute : attributeBlock.getAttributes()) {
                        if (!filterPredicate.apply((Object)config.getAttributeByName(attribute.getName()))) continue;
                        builder.put((Object)((ProfileId)entry.getKey()), (Object)attribute);
                    }
                }
            }
        }
        return builder.build();
    }

    @Override
    public void savePersonRoles(ProfileId profileId, Set<PersonRole> newRoles, AuthorizationCheckContext authCtx) {
        this._personRoleService.savePersonRoles(profileId.asPersonId(), newRoles, authCtx);
    }

    @Override
    public Profile updateProfileNameSettings(ProfileId profileId, NameSettings profileData, SearchAuthorizationCheckContext authContext) throws ValidatableException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        PersonId personId = profileId.asPersonId();
        this._personService.updateNameSettings(personId, new NameSettingsBean(personId, profileData), authContext.getUserId().equals(personId));
        Profile profile = this.getProfileById(profileId, authContext);
        if (profile != null) {
            return profile;
        }
        throw new ServiceException();
    }

    @Override
    public ProfilePersonalData getProfilePersonalData(ProfileId profileId, AuthorizationContext authContext) throws PermissionDeniedException, InvalidIdServiceException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        DBPerson person = this._personService.getPersonByIdNotNull(profileId.asPersonId());
        return new ProfilePersonalData(person.getBirthday(), person.getBirthdayVisibility(), (TimeZone)((Object)MoreObjects.firstNonNull((Object)((Object)person.getTimeZone()), (Object)((Object)this._settings.getDefaultTimeZone()))));
    }

    @Override
    public ProfilePersonalData saveProfilePersonalData(ProfileId profileId, final ProfilePersonalData profilePersonal, AuthorizationContext authContext) throws PermissionDeniedException, InvalidIdServiceException, ValidatableException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        this._personService.savePerson(profileId.asPersonId(), new PersonUpdateCommand(){

            @Override
            public DBPerson execute(DBPerson p) {
                Date birthday = profilePersonal.getBirthday();
                p.setBirthday(birthday != null ? new DateWithoutTimezone(birthday) : null);
                p.setTimeZone(profilePersonal.getTimezone());
                p.setBirthdayVisibility(profilePersonal.getBirthdayVisibility());
                return p;
            }
        }, PersonService.FeedMessageControl.GENERATE_FEED_MESSAGE);
        return this.getProfilePersonalData(profileId, authContext);
    }

    private static enum RoleConfigType {
        VISIBLE_FOR,
        AVAILABLE_FOR;

    }
}

