/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.profile.business.ProfileReadWriteDataService;
import de.justsoftware.onx.profile.integration.persistence.ProfileAttributeDAO;
import de.justsoftware.onx.profile.integration.persistence.ProfileConfigurationDAO;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeConfigIbatisModel;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeIbatisModel;
import de.justsoftware.onx.profile.integration.persistence.ibatis.ProfileAttributeId;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributeTreeValues;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileReadWriteDataServiceImpl
implements ProfileReadWriteDataService {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileReadWriteDataServiceImpl.class);
    private static final String GLOBAL_CONFIGURATION_ID = "global";
    private static final Comparator<ProfileAttributeIbatisModel> ATTRIBUTE_ORDER_COMPARATOR = new Comparator<ProfileAttributeIbatisModel>(){

        @Override
        public int compare(ProfileAttributeIbatisModel o1, ProfileAttributeIbatisModel o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.getBlockOrder() == o2.getBlockOrder()) {
                return o1.getValueOrder() - o2.getValueOrder();
            }
            return o1.getBlockOrder() - o2.getBlockOrder();
        }
    };
    private final ProfileConfigurationDAO _profileConfigurationDAO;
    private final ConfigurationCacheAccessor _configurationCacheAccessor;
    private final AttributesCacheAccessor _attributesCacheAccessor;
    private final ProfileAttributeDAO _profileAttributeDAO;
    private final JucoObjectMapper _jucoObjectMapper;
    private final Clock _clock;

    @Autowired
    public ProfileReadWriteDataServiceImpl(ProfileConfigurationDAO profileConfigurationDAO, EhcacheClient ehcacheClient, ProfileAttributeDAO profileAttributeDAO, JucoObjectMapper jucoObjectMapper, Clock clock) {
        this._profileConfigurationDAO = profileConfigurationDAO;
        this._configurationCacheAccessor = new ConfigurationCacheAccessor(ehcacheClient, profileConfigurationDAO, jucoObjectMapper);
        this._attributesCacheAccessor = new AttributesCacheAccessor(ehcacheClient, profileAttributeDAO);
        this._profileAttributeDAO = profileAttributeDAO;
        this._jucoObjectMapper = jucoObjectMapper;
        this._clock = clock;
    }

    @Override
    public ProfileAttributesConfiguration getAttributesConfiguration() {
        ProfileAttributesConfiguration result = (ProfileAttributesConfiguration)this._configurationCacheAccessor.getSingle(GLOBAL_CONFIGURATION_ID);
        if (result != null) {
            return result;
        }
        return new ProfileAttributesConfiguration(null, (ImmutableList<ProfileSectionConfiguration>)ImmutableList.of());
    }

    @Override
    public void setConfiguration(ProfileAttributesConfiguration profileAttributesConfiguration) {
        String configJsonString;
        try {
            ProfileAttributesConfiguration profileAttributesConfigurationWithRequiredData = profileAttributesConfiguration.withRequiredData();
            configJsonString = this._jucoObjectMapper.writeValueAsString(profileAttributesConfigurationWithRequiredData);
        }
        catch (JsonProcessingException e) {
            throw new ServiceException(e.getMessage(), e);
        }
        this._profileConfigurationDAO.setProfileAttributeConfig(new ProfileAttributeConfigIbatisModel(configJsonString, DateTime.now()));
        this._configurationCacheAccessor.invalidateKey(GLOBAL_CONFIGURATION_ID);
    }

    @Override
    public int deleteProfileAttributesByProfileIds(ImmutableSet<ProfileId> profileIds) {
        int updatedRows = this._profileAttributeDAO.deleteProfileAttributesByPersonIds((ImmutableSet<PersonId>)FluentIterable.from(profileIds).transform(ProfileId.TO_PERSON_ID).toSet());
        this._attributesCacheAccessor.invalidateKeys(profileIds);
        return updatedRows;
    }

    @Override
    public int deleteAllProfileAttributesForMigration() {
        int updatedRows = this._profileAttributeDAO.deleteAllProfileAttributesForMigration();
        this._attributesCacheAccessor.invalidateAll();
        return updatedRows;
    }

    @Nonnull
    private ProfileAttributes createProfileAttributes(ProfileAttributesConfiguration attrConfig, Collection<ProfileAttributeIbatisModel> attributeValues) {
        ImmutableListMultimap<String, ProfileAttributeIbatisModel> attributeValuesByName = Multimaps2.indexWithOrderedValues(attributeValues, ProfileAttributeIbatisModel.TO_NAME, ATTRIBUTE_ORDER_COMPARATOR);
        ImmutableList.Builder sections = ImmutableList.builder();
        for (ProfileSectionConfiguration section : attrConfig.getSections()) {
            ProfileSection.Builder sectionBuilder = ProfileSection.builder(section.getName(), section.getType());
            for (ProfileAttributeConfiguration attribute : section.getAttributes()) {
                ImmutableList values;
                ImmutableList<String> nonNullValues = CollectionUtil.nonNullImmutableList(attribute.getValues());
                if (attribute.getType() == ProfileAttributeType.DESCRIPTION && !nonNullValues.isEmpty()) {
                    sectionBuilder.addAttributeValues(0, attribute, nonNullValues);
                    continue;
                }
                if (attribute.getType() == ProfileAttributeType.DESCRIPTION || CollectionUtil.isEmpty(values = attributeValuesByName.get((Object)attribute.getName()))) continue;
                ImmutableMap valuesByBlocks = Multimaps.index((Iterable)values, ProfileAttributeIbatisModel.TO_BLOCK_ORDER).asMap();
                ImmutableSet<String> allowedValues = this.getAllowedValues(attribute);
                for (Map.Entry entry : valuesByBlocks.entrySet()) {
                    sectionBuilder.addAttributeValues((Integer)entry.getKey(), attribute, this.getValidValues(attribute, (Iterable)entry.getValue(), allowedValues));
                }
            }
            sections.add((Object)sectionBuilder.build());
        }
        return new ProfileAttributes(attrConfig.getModules(), (ImmutableList<ProfileSection>)sections.build());
    }

    @Nonnull
    private ImmutableList<String> getValidValues(ProfileAttributeConfiguration config, Iterable<ProfileAttributeIbatisModel> blockIndexValues, ImmutableSet<String> allowedValues) {
        Predicate typeFilter = Predicates.alwaysTrue();
        Function typeTransformer = Functions.identity();
        switch (config.getType()) {
            case SELECT: 
            case CHECKRADIO: {
                typeFilter = Predicates.in(allowedValues);
                break;
            }
            case TREE_SELECT: {
                typeFilter = Predicates.in(allowedValues);
                typeTransformer = NullPermeableFunction.wrap(name -> config.getTreeValues().getPath((String)name));
                break;
            }
        }
        return FluentIterable.from(blockIndexValues).transform(ProfileAttributeIbatisModel.TO_VALUE).filter(typeFilter).transform(typeTransformer).filter(Predicates.notNull()).toList();
    }

    @Nonnull
    private ImmutableSet<String> getAllowedValues(ProfileAttributeConfiguration attribute) {
        return ProfileAttributeType.TREE_SELECT.equals((Object)attribute.getType()) ? attribute.getTreeValues().getNames() : CollectionUtil.nonNullImmutableSet(attribute.getValues());
    }

    @Override
    public ProfileAttributes getProfileAttributesByProfileId(ProfileId profileId, ProfileAttributesConfiguration visibleAttrConfig) {
        ImmutableList allProfileAttributes = (ImmutableList)this._attributesCacheAccessor.getSingle(profileId);
        return this.createProfileAttributes(visibleAttrConfig, (Collection<ProfileAttributeIbatisModel>)allProfileAttributes);
    }

    @Override
    public ImmutableMap<ProfileId, ProfileAttributes> getProfileAttributesByProfileId(Map<ProfileId, ProfileAttributesConfiguration> profilesWithConfiguration) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableListMultimap allAttributes = (ImmutableListMultimap)this._attributesCacheAccessor.getMultiMap(profilesWithConfiguration.keySet());
        for (Map.Entry<ProfileId, ProfileAttributesConfiguration> entry : profilesWithConfiguration.entrySet()) {
            ProfileId profileId = entry.getKey();
            ProfileAttributesConfiguration config = entry.getValue();
            ImmutableList attributes = allAttributes.get((Object)profileId);
            builder.put((Object)profileId, (Object)this.createProfileAttributes(config, (Collection<ProfileAttributeIbatisModel>)attributes));
        }
        return builder.build();
    }

    @Override
    public ImmutableMap<String, ProfileSection> getProfileSection(ProfileId profileId, ImmutableSet<String> sectionNames, ProfileAttributesConfiguration visibleAttrConfig) {
        if (sectionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        ProfileAttributes profileAttributes = this.getProfileAttributesByProfileId(profileId, visibleAttrConfig);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ProfileSection profileSection : profileAttributes.getSections()) {
            if (!sectionNames.contains((Object)profileSection.getName())) continue;
            builder.put((Object)profileSection.getName(), (Object)profileSection);
        }
        return builder.build();
    }

    @Nonnull
    private Integer getNextBlockOrderIndex(ProfileId profileId, String sectionName) {
        int maxOrderIndex = this.getMinOrMaxBlockOrderIndex(profileId, sectionName, false);
        return maxOrderIndex + 1;
    }

    @Nonnull
    private Integer getFirstBlockOrderIndex(ProfileId profileId, String sectionName) {
        int minOrderIndex = this.getMinOrMaxBlockOrderIndex(profileId, sectionName, true);
        int firstOrderIndex = minOrderIndex >= 0 ? minOrderIndex : 0;
        return firstOrderIndex;
    }

    private int getMinOrMaxBlockOrderIndex(ProfileId profileId, String sectionName, boolean min) {
        ProfileSection profileSection = (ProfileSection)this.getProfileSection(profileId, (ImmutableSet<String>)ImmutableSet.of((Object)sectionName), this.getAttributesConfiguration()).get((Object)sectionName);
        if (profileSection == null || profileSection.getAttributeBlocks().isEmpty()) {
            return 0;
        }
        IntStream intStream = profileSection.getAttributeBlocks().stream().map(ProfileAttributeBlock::getOrderIndex).filter(v -> v != null).mapToInt(Integer::intValue);
        OptionalInt optInt = min ? intStream.min() : intStream.max();
        return optInt.orElse(-1);
    }

    @Override
    public int mergeProfileAttributeBlock(ProfileId profileId, String sectionName, ProfileAttributeBlock block) {
        Integer orderIndex = (Integer)MoreObjects.firstNonNull((Object)block.getOrderIndex(), (Object)this.getFirstBlockOrderIndex(profileId, sectionName));
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder toDeleteNames = ImmutableList.builder();
        PersonId personId = profileId.asPersonId();
        for (ProfileAttribute attribute : block.getAttributes()) {
            ImmutableList<String> values = attribute.getValues();
            if (values.isEmpty()) {
                toDeleteNames.add((Object)attribute.getName());
            }
            for (int valueOrder = 0; valueOrder < values.size(); ++valueOrder) {
                String value;
                String string = value = ProfileAttributeType.TREE_SELECT.equals((Object)attribute.getType()) ? ProfileAttributeTreeValues.ProfileAttributeTreeValue.getNodeNameOfPath((String)values.get(valueOrder)) : (String)values.get(valueOrder);
                if (StringUtil.isEmpty(value)) continue;
                builder.add((Object)new ProfileAttributeIbatisModel(null, personId, attribute.getName(), value, valueOrder, orderIndex, this._clock.now()));
            }
        }
        this._profileAttributeDAO.deleteProfileAttributesByName(profileId, orderIndex, (ImmutableList<String>)toDeleteNames.build());
        this._profileAttributeDAO.updateProfileAttributes((ImmutableList<ProfileAttributeIbatisModel>)builder.build());
        this._attributesCacheAccessor.invalidateKey(profileId);
        return orderIndex;
    }

    @Override
    public int insertProfileAttributeBlock(ProfileId profileId, String sectionName, ProfileAttributeBlock block) {
        Integer blockOrderIndex = block.getOrderIndex();
        Integer orderIndex = blockOrderIndex != null ? blockOrderIndex : this.getNextBlockOrderIndex(profileId, sectionName);
        ImmutableList.Builder builder = ImmutableList.builder();
        PersonId personId = profileId.asPersonId();
        for (ProfileAttribute attribute : block.getAttributes()) {
            ImmutableList<String> values = attribute.getValues();
            for (int valueOrder = 0; valueOrder < values.size(); ++valueOrder) {
                String value = ProfileAttributeType.TREE_SELECT.equals((Object)attribute.getType()) ? ProfileAttributeTreeValues.ProfileAttributeTreeValue.getNodeNameOfPath((String)values.get(valueOrder)) : (String)values.get(valueOrder);
                builder.add((Object)new ProfileAttributeIbatisModel(null, personId, attribute.getName(), value, valueOrder, orderIndex, DateTime.now()));
            }
        }
        this._profileAttributeDAO.insertProfileAttributes((ImmutableList<ProfileAttributeIbatisModel>)builder.build());
        this._attributesCacheAccessor.invalidateKey(profileId);
        return orderIndex;
    }

    @Override
    public void saveProfileSection(ProfileId profileId, String sectionName, ImmutableList<ProfileAttributeBlock> blocks) {
        this.deleteProfileAttributeBlocks(profileId, sectionName);
        blocks.forEach(block -> this.insertProfileAttributeBlock(profileId, sectionName, (ProfileAttributeBlock)block));
    }

    @Override
    public int deleteVisibleAndWritableProfileBlockAttributes(ProfileId profileId, final String sectionName, final ProfileAttributesConfiguration visibleAttributesConfiguration, final int orderIndex) {
        ImmutableList attributes = ((ImmutableListMultimap)this._attributesCacheAccessor.getMultiMap(ImmutableSet.of((Object)profileId))).get((Object)profileId);
        final ImmutableMap<String, String> attributesToSectionsMap = visibleAttributesConfiguration.getAttributesToSectionsConfigMap();
        ImmutableSet attributeIds = FluentIterable.from((Iterable)attributes).filter((Predicate)new NullIsFalsePredicate<ProfileAttributeIbatisModel>(){

            @Override
            public boolean applySafe(ProfileAttributeIbatisModel input) {
                ProfileAttributeConfiguration attributeCfg = visibleAttributesConfiguration.getAttributeByName(input.getName());
                return input.getBlockOrder() == orderIndex && sectionName.equals(attributesToSectionsMap.get((Object)input.getName())) && attributeCfg != null && BooleanUtils.isNotTrue((Boolean)attributeCfg.isReadOnly());
            }
        }).transform(ProfileAttributeIbatisModel.TO_ID).toSet();
        int result = this._profileAttributeDAO.deleteProfileAttributesByIds((ImmutableSet<ProfileAttributeId>)attributeIds);
        this._attributesCacheAccessor.invalidateKey(profileId);
        return result;
    }

    @Override
    public int deleteProfileAttributeBlock(ProfileId profileId, final String sectionName, final int orderIndex) {
        ImmutableList attributes = ((ImmutableListMultimap)this._attributesCacheAccessor.getMultiMap(ImmutableSet.of((Object)profileId))).get((Object)profileId);
        final ProfileAttributesConfiguration config = this.getAttributesConfiguration();
        final ImmutableMap<String, String> attributesToSectionsMap = config.getAttributesToSectionsConfigMap();
        ImmutableSet attributeIds = FluentIterable.from((Iterable)attributes).filter((Predicate)new NullIsFalsePredicate<ProfileAttributeIbatisModel>(){

            @Override
            public boolean applySafe(ProfileAttributeIbatisModel input) {
                ProfileAttributeConfiguration attributeCfg = config.getAttributeByName(input.getName());
                return input.getBlockOrder() == orderIndex && sectionName.equals(attributesToSectionsMap.get((Object)input.getName())) && attributeCfg != null;
            }
        }).transform(ProfileAttributeIbatisModel.TO_ID).toSet();
        int result = this._profileAttributeDAO.deleteProfileAttributesByIds((ImmutableSet<ProfileAttributeId>)attributeIds);
        this._attributesCacheAccessor.invalidateKey(profileId);
        return result;
    }

    private void deleteProfileAttributeBlocks(ProfileId profileId, String sectionName) {
        int maxIndex = this.getMinOrMaxBlockOrderIndex(profileId, sectionName, false);
        if (maxIndex >= 0) {
            for (int i = 0; i <= maxIndex; ++i) {
                this.deleteProfileAttributeBlock(profileId, sectionName, i);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static final class ConfigurationCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<ProfileServiceEhCacheName, String, ProfileAttributesConfiguration> {
        private final ProfileConfigurationDAO _dao;
        private final JucoObjectMapper _mapper;

        ConfigurationCacheAccessor(EhcacheClient cache, ProfileConfigurationDAO dao, JucoObjectMapper mapper) {
            super(cache, ProfileServiceEhCacheName.CONFIGURATION);
            this._dao = dao;
            this._mapper = mapper;
        }

        @Override
        protected ProfileAttributesConfiguration getFromDatabaseSingle(String id) {
            if (ProfileReadWriteDataServiceImpl.GLOBAL_CONFIGURATION_ID.equals(id)) {
                ProfileAttributeConfigIbatisModel profileAttributeConfig = this._dao.getProfileAttributeConfig();
                if (profileAttributeConfig == null) {
                    return null;
                }
                try {
                    ProfileAttributesConfiguration fromDB = (ProfileAttributesConfiguration)this._mapper.readValue(profileAttributeConfig.getConfigJsonString(), ProfileAttributesConfiguration.class);
                    return fromDB.withRequiredData();
                }
                catch (IOException e) {
                    LOG.error("Failed to parse attribte configuration:\n" + profileAttributeConfig.getConfigJsonString(), (Throwable)e);
                }
            }
            return null;
        }

        @Override
        protected String keyToString(String key) {
            return key;
        }
    }

    @ParametersAreNonnullByDefault
    private static final class AttributesCacheAccessor
    extends AbstractListMultiMapCacheAccessor<ProfileServiceEhCacheName, ProfileId, ProfileAttributeIbatisModel> {
        private final ProfileAttributeDAO _dao;

        AttributesCacheAccessor(EhcacheClient cache, ProfileAttributeDAO dao) {
            super(cache, ProfileServiceEhCacheName.ATTRIBUTES);
            this._dao = dao;
        }

        @Override
        protected ProfileId objectToKey(ProfileAttributeIbatisModel dbResult) {
            return dbResult.getPersonId().asProfileId();
        }

        @Override
        protected Iterable<? extends ProfileAttributeIbatisModel> getListFromDatabase(Set<? extends ProfileId> inputs) {
            return this._dao.getProfileAttributesByPersonIds((ImmutableSet<PersonId>)FluentIterable.from(inputs).transform(ProfileId.TO_PERSON_ID).toSet()).values();
        }

        @Override
        protected String keyToString(ProfileId key) {
            return key.asString();
        }
    }

    @ParametersAreNonnullByDefault
    public static enum ProfileServiceEhCacheName implements EhCacheName
    {
        CONFIGURATION("profile.configuration"),
        ATTRIBUTES("profile.attributes");

        private final String _prefix;

        private ProfileServiceEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

