/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.profile.business;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.profile.model.Profile;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributeConfiguration;
import de.justsoftware.onx.profile.model.ProfileAttributes;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfilePersonalData;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.profile.model.ProfileValidationErrorMessage;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.multipart.MultipartFile;

@ParametersAreNonnullByDefault
public interface ProfileService {
    public static final String PROFILE_ATTRIBUTE_NAME_REGEX = "\\w+";
    public static final String PROFILE_ATTRIBUTE_NAME_INVERSE_REGEX = "\\W+";
    public static final Pattern PROFILE_ATTRIBUTE_IDENTIFIER_PATTERN = Pattern.compile("\\w+");

    @CheckForNull
    public Profile getProfileById(ProfileId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableSet<PersonRole> getEditableRolesForProfile(ProfileId var1, SearchAuthorizationCheckContext var2);

    @Nonnull
    public ProfileAttributesConfiguration getAttributesConfigurationForEditing(AuthorizationCheckContext var1) throws PermissionDeniedException;

    @Nonnull
    public ProfileAttributesConfiguration getAttributesConfigurationForRegistration(@Nullable AuthorizationCheckContext var1) throws PermissionDeniedException;

    @Nonnull
    public ProfileAttributesConfiguration getVisibleAttributesConfiguration(@Nullable ProfileId var1, AuthorizationCheckContext var2) throws PermissionDeniedException;

    public void setAttributesConfiguration(ProfileAttributesConfiguration var1, AuthorizationCheckContext var2) throws PermissionDeniedException, ProfileValidationException;

    @Nonnull
    public ProfileAttributeBlock saveProfileAttributeBlock(ProfileId var1, String var2, ProfileAttributeBlock var3, AuthorizationCheckContext var4) throws PermissionDeniedException, ProfileValidationException;

    public void updateProfileAttributeSection(ProfileId var1, String var2, ImmutableList<ProfileAttributeBlock> var3, AuthorizationCheckContextWithUserId var4) throws PermissionDeniedException, ProfileValidationException;

    public void saveProfileAttributeBlocksFromRegistration(ProfileId var1, ImmutableMap<String, ProfileAttributeBlock> var2, AuthorizationCheckContext var3) throws PermissionDeniedException, ProfileValidationException;

    @Nonnull
    public ImmutableListMultimap<String, ProfileValidationErrorMessage> validateRegistrationProfileAttributes(ImmutableMap<String, ProfileAttributeBlock> var1);

    @Nonnull
    public ImmutableMap<String, Object> getProfileAttributesDefaultTranslations();

    public void saveProfileImage(ProfileId var1, MultipartFile var2, AuthorizationCheckContext var3) throws PermissionDeniedException, InvalidIdServiceException, IOException;

    public void deleteProfileImage(ProfileId var1, AuthorizationCheckContext var2) throws IOException, ServiceException, ValidatableException;

    @Nonnull
    public ImmutableMap<ProfileId, ProfileAttributesConfiguration> getVisibleAttributesConfigurations(Set<ProfileId> var1, AuthorizationCheckContext var2);

    @CheckForNull
    public ProfileSection getProfileSection(ProfileId var1, String var2, AuthorizationCheckContextWithUserId var3);

    public int deleteVisibleAndWritableProfileBlockAttributes(ProfileId var1, String var2, int var3, AuthorizationContext var4);

    @Nonnull
    public ImmutableListMultimap<ProfileId, ProfileAttribute> getVisibleAttributes(Set<ProfileId> var1, Predicate<ProfileAttributeConfiguration> var2, AuthorizationCheckContext var3);

    @Nonnull
    public ImmutableListMultimap<ProfileId, ProfileAttribute> getVisibleAttributesForInternalUseOnly(Set<ProfileId> var1, Predicate<ProfileAttributeConfiguration> var2);

    @Nonnull
    public ImmutableListMultimap<ProfileId, ProfileSection> getVisibleSections(Set<ProfileId> var1, AuthorizationCheckContext var2);

    @CheckForNull
    public ProfileAttributes getVisibleAttributesById(ProfileId var1, AuthorizationCheckContext var2);

    public void savePersonRoles(ProfileId var1, Set<PersonRole> var2, AuthorizationCheckContext var3);

    @Nonnull
    public Profile updateProfileNameSettings(ProfileId var1, NameSettings var2, SearchAuthorizationCheckContext var3) throws ValidatableException;

    @Nonnull
    public ProfilePersonalData getProfilePersonalData(ProfileId var1, AuthorizationContext var2) throws PermissionDeniedException, InvalidIdServiceException;

    @Nonnull
    public ProfilePersonalData saveProfilePersonalData(ProfileId var1, ProfilePersonalData var2, AuthorizationContext var3) throws PermissionDeniedException, InvalidIdServiceException, ValidatableException;
}

