/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.process.business.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityStatusTemplate
extends AbstractImmutableEqualsObject {
    public static final Predicate<EntityStatusTemplate> IS_DEFAULT = new NullIsFalsePredicate<EntityStatusTemplate>(){

        @Override
        public boolean applySafe(EntityStatusTemplate input) {
            return input != null && input.isDefault();
        }
    };
    private final String _name;
    private final String _iconType;
    private final boolean _default;
    private final boolean _published;
    private final boolean _archived;
    private final int _order;

    public EntityStatusTemplate(String name, String iconType, boolean defaultStatus, boolean published, boolean archived, int order) {
        super(name);
        this._name = name;
        this._iconType = iconType;
        this._default = defaultStatus;
        this._published = published;
        this._archived = archived;
        this._order = order;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public String getIconType() {
        return this._iconType;
    }

    public boolean isDefault() {
        return this._default;
    }

    public boolean isPublished() {
        return this._published;
    }

    public boolean isArchived() {
        return this._archived;
    }

    public int getOrder() {
        return this._order;
    }

    @Nonnull
    public static Builder builder(String statusName) {
        return new Builder(statusName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this._name).add("iconType", (Object)this._iconType).add("default", this._default).add("published", this._published).add("archived", this._archived).toString();
    }

    @ParametersAreNonnullByDefault
    public static final class Builder {
        private final String _statusName;
        private String _icon = "ok";
        private boolean _defaultStatus = false;
        private boolean _publishedStatus = true;
        private boolean _archivedStatus = false;
        private int _order = 0;

        protected Builder(String name) {
            this._statusName = name;
        }

        @Nonnull
        public Builder withIcon(String icon) {
            this._icon = icon;
            return this;
        }

        @Nonnull
        public Builder archived(boolean archived) {
            this._archivedStatus = archived;
            return this;
        }

        @Nonnull
        public Builder published(boolean published) {
            this._publishedStatus = published;
            return this;
        }

        @Nonnull
        public Builder defaultStatus(boolean defaultStatus) {
            this._defaultStatus = defaultStatus;
            return this;
        }

        @Nonnull
        public Builder order(int order) {
            this._order = order;
            return this;
        }

        @Nonnull
        public EntityStatusTemplate build() {
            return new EntityStatusTemplate(this._statusName, this._icon, this._defaultStatus, this._publishedStatus, this._archivedStatus, this._order);
        }
    }
}

