/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.process.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityStatusReadWriteDataService;
import de.justsoftware.onx.container.business.EntityVersionReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.model.DBEntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityStatusImpl;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.process.business.ProcessAdministrationService;
import de.justsoftware.onx.process.business.model.DefaultTemplate;
import de.justsoftware.onx.process.business.model.EntityProcessTemplate;
import de.justsoftware.onx.process.business.model.EntityStatusTemplate;
import de.justsoftware.onx.process.business.model.ProcessConfigurationChangedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class ProcessConfigurationServiceImpl
implements ProcessAdministrationService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessConfigurationServiceImpl.class);
    @Autowired
    private EntityStatusReadWriteDataService _entityStatusDataService;
    @Autowired
    private EntityVersionReadWriteDataService _entityVersionDataService;
    @Autowired
    private TransactionHelper _transactionhelper;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private EntityConfigService _entityConfigService;

    private void applyEntityProcessTemplate(final EntityType entityType, final EntityProcessTemplate template, AuthorizationCheckContext authCtx) {
        authCtx.check(StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        if (!this._entityConfigService.getOrderedEntityTypes().contains((Object)entityType) || !this._entityConfigService.entityTypeActivated(entityType)) {
            throw new IllegalArgumentException("no such entity type");
        }
        if (FluentIterable.from(template.getEntityStatus()).filter(EntityStatusTemplate.IS_DEFAULT).size() != 1) {
            throw new IllegalArgumentException("Given process template must define exactly one default status");
        }
        this._transactionhelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ImmutableSet<EntityStatus> existingStatus = ProcessConfigurationServiceImpl.this._entityStatusDataService.getStatusForEntityType(entityType);
                ImmutableMap oldStatusMap = Maps.uniqueIndex(existingStatus, EntityStatus.TO_NAME);
                ImmutableMap<EntityStatusTemplate, EntityStatus> statusMap = ProcessConfigurationServiceImpl.this.createConfiguredStatus(entityType, template, (Map<String, EntityStatus>)oldStatusMap);
                EntityStatus defaultStatus = (EntityStatus)FluentIterable.from(ProcessConfigurationServiceImpl.this._entityStatusDataService.getStatusForEntityType(entityType)).firstMatch(EntityStatus.IS_DEFAULT).get();
                ImmutableSet idsToDelete = FluentIterable.from((Iterable)oldStatusMap.values()).filter(Predicates.not((Predicate)Predicates.in((Collection)statusMap.values()))).filter(Predicates.notNull()).transform(Identifiables.toId()).toSet();
                ProcessConfigurationServiceImpl.this._entityVersionDataService.updateStatusOfVersionsWithStatus((Set<EntityStatusId>)idsToDelete, defaultStatus);
                ProcessConfigurationServiceImpl.this._entityStatusDataService.deleteStatus((Set<EntityStatusId>)idsToDelete);
            }
        });
        this._eventBus.post(ProcessConfigurationChangedEvent.INSTANCE);
    }

    @Nonnull
    private ImmutableMap<EntityStatusTemplate, EntityStatus> createConfiguredStatus(EntityType entityType, EntityProcessTemplate template, Map<String, EntityStatus> existingStatusMap) {
        ImmutableMap.Builder statusBuilder = ImmutableMap.builder();
        for (EntityStatusTemplate statusTemplate : template.getEntityStatus()) {
            EntityStatus existingStatus = existingStatusMap.get(statusTemplate.getName());
            if (existingStatus != null) {
                this._entityStatusDataService.updateStatus(existingStatus, statusTemplate);
                statusBuilder.put((Object)statusTemplate, (Object)existingStatus);
                continue;
            }
            DBEntityStatus dbStatus = new DBEntityStatus();
            dbStatus.setEntityType(entityType);
            dbStatus.setStatusName(statusTemplate.getName());
            dbStatus.setIconType(statusTemplate.getIconType());
            dbStatus.setDefaultStatus(statusTemplate.isDefault());
            dbStatus.setArchivedStatus(statusTemplate.isArchived());
            dbStatus.setPublishedStatus(statusTemplate.isPublished());
            dbStatus.setOrder(statusTemplate.getOrder());
            this._entityStatusDataService.insertStatus(dbStatus);
            statusBuilder.put((Object)statusTemplate, (Object)new EntityStatusImpl(dbStatus));
        }
        return statusBuilder.build();
    }

    @Override
    public void adjustEntityStatus(AuthorizationCheckContext authCtx) {
        ArrayList failedTypes = Lists.newArrayList();
        for (EntityType entityType : this._entityConfigService.getOrderedActivatedEntityTypes()) {
            try {
                if (this._entityConfigService.releaseProcessMandatory(entityType)) continue;
                this.applyEntityProcessTemplate(entityType, DefaultTemplate.INSTANCE, authCtx);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to adjust entity status for type " + entityType, (Throwable)e);
                failedTypes.add(entityType);
            }
        }
        if (!failedTypes.isEmpty()) {
            throw new ServiceException("Failed to adjust entity status for the following types: " + failedTypes + ". See log for more details.");
        }
    }
}

