/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public class ProfileItem
implements Item<ProfileId> {
    public static final Function<ProfileItem, DBPerson> GET_PERSON_FUNCTION = new Function<ProfileItem, DBPerson>(){

        public DBPerson apply(ProfileItem input) {
            return input != null ? input.getPerson() : null;
        }
    };
    public static final Function<ProfileItem, ProfileId> TO_ID = new NullPermeableFunction<ProfileItem, ProfileId>(){

        @Override
        protected ProfileId applySafe(ProfileItem item) {
            return item.getId();
        }
    };
    private final DBPerson _person;
    private final ImmutableSet<PersonRole> _roles;

    public ProfileItem(@Nonnull DBPerson person, @Nonnull ImmutableSet<PersonRole> roles) {
        this._person = person;
        this._roles = roles;
    }

    @Override
    public ProfileId getId() {
        return this._person.getId().asProfileId();
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public GlobalId getParentId() {
        return null;
    }

    @Nonnull
    public DBPerson getPerson() {
        return this._person;
    }

    @Nonnull
    public ImmutableSet<PersonRole> getRoles() {
        return this._roles;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("person", (Object)this._person).toString();
    }
}

