/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.integration.persistence.ibatis.PersonDataDeleteDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.DBProfileComponent;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@ParametersAreNonnullByDefault
@Repository
public class IbatisPersonDAO
implements PersonDAO,
PersonDataDeleteDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisPersonDAO.class);
    private static final String NAMESPACE = "Person.";
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisPersonDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("Person");
    }

    @Override
    public void updatePersonActivated(PersonId personId, boolean activated) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updatePersonActivated", ImmutableMap.of((Object)"id", (Object)personId, (Object)"activated", (Object)activated));
    }

    @Override
    public void updatePersonBlocked(PersonId personId, boolean blocked) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updatePersonBlocked", ImmutableMap.of((Object)"id", (Object)personId, (Object)"blocked", (Object)blocked));
    }

    @Override
    public PersonId insertPerson(DBPerson person, DateTime createDate) {
        person.setCreateDate(createDate.toDate());
        person.setModifyDate(createDate.toDate());
        person.setHashedId(SecureRandomUtil.randomHex());
        return (PersonId)this._ibatisStatementBuilder.insert("insertNewUser").param(person).get();
    }

    @Override
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<? extends PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getPersonsByIds").partition(personIds)).asMap(DBPerson::getId);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<? extends PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getPersonRoles").partition(personIds)).asSetMultimap("personId", "role");
    }

    @Override
    public void deletePerson(PersonId personId) throws ServiceException {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "Person.deletePerson", personId);
    }

    @Override
    public List<DBProfileComponent> getProfileComponents(Set<? extends PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Person.getProfileComponents", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void saveProfileComponent(DBProfileComponent component) throws ServiceException {
        int effectedRow = IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updateProfileComponent", component);
        if (effectedRow > 1) {
            throw new IllegalStateException("saveProfileComponent has update more than one row");
        }
        if (effectedRow == 0) {
            IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Person.insertProfileComponent", component);
        }
    }

    @Override
    public void updatePerson(DBPerson person, @Nullable DateTime newModifyDate) {
        if (newModifyDate != null) {
            person.setModifyDate(newModifyDate.toDate());
        }
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updatePerson", person);
    }

    @Override
    public void markAsDeleted(PersonId personId) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.markAsDeleted", personId);
    }

    @Override
    public PersonId getPersonIdByHash(String hash) {
        return (PersonId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Person.getPersonIdByHash", hash);
    }

    @Override
    public List<PersonId> getPersonIdsByRole(List<String> roleNames) {
        if (CollectionUtil.isEmpty(roleNames)) {
            return Lists.newArrayList();
        }
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "Person.getPersonIdsByRole", IbatisDAOUtil.toIbatisList(roleNames));
    }

    @Override
    public DBAccountSettings getAccountSettingsByPersonId(PersonId personId) {
        return (DBAccountSettings)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Person.getAccountSettingsByPersonId", personId);
    }

    @Override
    public void updateLastLoginDate(PersonId userId, Date date) throws ServiceException {
        HashMap params = Maps.newHashMap();
        params.put("time", date);
        params.put("uid", userId);
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updateLastLoginDate", params);
    }

    @Override
    public void updatePassword(PersonId uid, String hashedPassword) throws ServiceException {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updatePassword", ImmutableMap.of((Object)"uid", (Object)uid, (Object)"newpw", (Object)hashedPassword));
    }

    @Override
    public void updatePassword(PersonId id, String oldHashedPassword, String hashedPassword) {
        this._ibatisStatementBuilder.update("updatePasswordIfOldIsPresent").param("personId", id, "oldPassword", oldHashedPassword, "newPassword", hashedPassword);
    }

    @Override
    public PersonId getPersonIdByEmailOrNewmail(String email) {
        return (PersonId)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Person.getPersonIdByEmailOrNewmail", email);
    }

    @Override
    public void updateAccountSettings(DBAccountSettings settings) throws ServiceException {
        HashMap params = Maps.newHashMap();
        params.put("firstName", settings.getFirstName());
        params.put("lastName", settings.getLastName());
        params.put("newmail", settings.getNewmail());
        params.put("title", settings.getTitle());
        params.put("personId", settings.getPersonId());
        params.put("newPassword", settings.getNewPassword());
        params.put("additionalTitle", settings.getAdditionalTitle());
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updateAccountSettings", params);
    }

    @Override
    public void setPersonRoles(PersonId personId, Set<PersonRole> roles) {
        this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisStatementBuilder.batch(sqlMapClient -> {
            this._ibatisStatementBuilder.delete("deleteRoleNames").param(personId);
            this.insertRoles(personId, roles);
        }));
    }

    private void insertRoles(PersonId personId, Set<PersonRole> roles) {
        for (PersonRole role : roles) {
            this._ibatisStatementBuilder.insert("insertRoleName").param("personId", personId, "roleName", role);
        }
    }

    @Override
    public void addPersonRoles(PersonId personId, Set<PersonRole> roleNames) {
        if (!roleNames.isEmpty()) {
            this._transactionHelper.doInTransactionWithoutResult(status -> this._ibatisStatementBuilder.batch(sqlMapClient -> this.insertRoles(personId, roleNames)));
        }
    }

    @Override
    public List<PersonId> getAllPersonIds(boolean onlyActive, int offset, int limit) {
        return IbatisDAOUtil.wrappedQueryForList(this._sqlMapper, "Person.getAllPersonIds", ImmutableMap.of((Object)"offset", (Object)offset, (Object)"limit", (Object)limit, (Object)"onlyActive", (Object)onlyActive));
    }

    @Override
    public ImmutableMap<PersonId, DBEmailNotificationSettings> getEmailNotificationSettingsByPersonIds(Collection<PersonId> personIds) {
        ImmutableSet result = IbatisDAOUtil.wrappedPartitionQueryForImmutableSet(this._sqlMapper, "Person.getEmailNotificationSettingsByPersonIds", ImmutableSet.copyOf(personIds), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return Maps.uniqueIndex(result, DBEmailNotificationSettings.GET_PERSON_ID);
    }

    @Override
    public void saveEmailNotificationSettings(DBEmailNotificationSettings settings) {
        int updates = IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updateEmailNotificationSettings", settings);
        if (updates == 0) {
            IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Person.insertEmailNotificationSettings", settings);
        }
    }

    @Override
    public void updateImage(PersonId uid, String filename) {
        HashMap params = Maps.newHashMap();
        params.put("uid", uid);
        params.put("filename", filename);
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updateImage", params);
    }

    @Override
    public ImmutableList<PersonId> getUpcomingBirthdays(int interval, DateTime currentTime) {
        if (interval < 0) {
            return ImmutableList.of();
        }
        return IbatisDAOUtil.wrappedQueryForImmutableList(this._sqlMapper, "Person.getUpcomingBirthdays", ImmutableMap.of((Object)"interval", (Object)interval, (Object)"currenttime", (Object)currentTime.toDate()));
    }

    @Override
    public void deleteProfileComponents(PersonId personId) {
        IbatisDAOUtil.wrappedDelete(this._sqlMapper, "Person.deleteProfileComponent", personId);
    }

    @Override
    public void updatePersonModifyDate(PersonId id, Date newModifyDate) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Person.updatePersonModifyDate", ImmutableMap.of((Object)"id", (Object)id, (Object)"modifyDate", (Object)newModifyDate));
    }

    @Override
    public int getActiveUserCount() {
        Integer result = (Integer)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Person.getActiveUserCount");
        return Numbers.intValue(result);
    }

    @Override
    public int getTotalUserCount() {
        Integer result = (Integer)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapper, "Person.getTotalUserCount");
        return Numbers.intValue(result);
    }

    @Override
    public void synchronizePersonRoles(Set<PersonRole> allPersonRoles) {
        final ImmutableList ibatisRoles = ImmutableSet.copyOf(allPersonRoles).asList();
        if (ibatisRoles.isEmpty()) {
            throw new DAOException("No person roles defined!");
        }
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    IbatisPersonDAO.this._sqlMapper.startBatch();
                    IbatisPersonDAO.this._sqlMapper.delete("Person.synchronizePersonRolesDelete", (Object)ibatisRoles);
                    IbatisPersonDAO.this._sqlMapper.insert("Person.synchronizePersonRolesInsert", (Object)ibatisRoles);
                    IbatisPersonDAO.this._sqlMapper.executeBatch();
                }
                catch (SQLException e) {
                    LOG.error("Unable to sync configuration with database, you have to clean up database before changing the configuration!", (Throwable)e);
                    throw new DAOException("You can not delete a role which is still in use.");
                }
            }
        });
    }

    @Override
    public int forAllPersons(Consumer<DBPerson> rowHandler) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getAllPersons").noParam()).executeWithConsumer(rowHandler);
    }

    @Override
    public int forAllPersonsChunked(int chunkSize, Consumer<ImmutableList<DBPerson>> consumer) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getAllPersons").noParam()).consumeChunkedList(chunkSize, consumer);
    }

    @Override
    public int forAllPersonRoles(BiConsumer<PersonId, PersonRole> rowHandler) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getAllPersonRoles").noParam()).executeWithBiConsumer("personId", "role", rowHandler);
    }

    @Override
    public boolean getPersonWithMd5Password(BiConsumer<PersonId, String> personWithMd5PasswordConsumer) {
        int count = ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.selectDbSpecific("getPersonWithMd5Password").noParam()).executeWithBiConsumer("personId", "password", personWithMd5PasswordConsumer);
        switch (count) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalStateException("expected zero or one result, but got " + count);
    }

    @Override
    public ImmutableMap<String, PersonId> getPersonIdsByEmails(Set<String> emails) {
        ImmutableMap dbResult = ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getPersonIdsByEmails").partition(FluentIterable.from(emails).transform(String::toLowerCase).toSet())).asMap("email", "personId");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String email : emails) {
            PersonId personId = (PersonId)dbResult.get((Object)email.toLowerCase());
            if (personId == null) continue;
            builder.put((Object)email, (Object)personId);
        }
        return builder.build();
    }
}

