/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.integration.persistence.ibatis;

import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.integration.persistence.PasswordResetRequestDAO;
import de.justsoftware.onx.person.shared.model.PendingPasswordReset;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisPasswordResetRequestDAO
implements PasswordResetRequestDAO {
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    public IbatisPasswordResetRequestDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("PersonPendingPasswordReset");
    }

    @Override
    public PendingPasswordReset upsertRequestForPerson(PersonId personId, LocalDateTime expirationDate) {
        this._ibatisStatementBuilder.insertDbSpecific("upsertPendingReset").param("personId", personId, "expiryTime", expirationDate);
        return this.getPendingRequestForPerson(personId).orElseThrow(() -> new DAOException("Could not get previously stored PendingPasswordReset for user " + personId + ". This should never happen"));
    }

    @Override
    public Optional<PendingPasswordReset> getPendingRequestForPerson(PersonId personId) {
        Optional results = ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getPendingReset").param("personId", personId)).asOptional();
        return results.map(it -> new PendingPasswordReset(it.getPersonId(), it.getExpiryTime()));
    }

    @Override
    public void deletePendingRequestForPerson(PersonId personId) {
        this._ibatisStatementBuilder.delete("deletePendingReset").param("personId", personId);
    }
}

