/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.DBProfileComponent;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface PersonDAO {
    public void updatePersonActivated(PersonId var1, boolean var2);

    public void updatePersonBlocked(PersonId var1, boolean var2);

    @Nonnull
    public PersonId insertPerson(DBPerson var1, DateTime var2);

    @Nonnull
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<? extends PersonId> var1);

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<? extends PersonId> var1);

    public void deletePerson(PersonId var1);

    @Nonnull
    public List<DBProfileComponent> getProfileComponents(Set<? extends PersonId> var1);

    public void saveProfileComponent(DBProfileComponent var1);

    public void updatePerson(DBPerson var1, @Nullable DateTime var2);

    public void markAsDeleted(PersonId var1);

    @CheckForNull
    public PersonId getPersonIdByHash(String var1);

    @Nonnull
    public ImmutableMap<String, PersonId> getPersonIdsByEmails(Set<String> var1);

    @CheckForNull
    public PersonId getPersonIdByEmailOrNewmail(String var1);

    @CheckForNull
    public DBAccountSettings getAccountSettingsByPersonId(PersonId var1);

    @Nonnull
    public ImmutableMap<PersonId, DBEmailNotificationSettings> getEmailNotificationSettingsByPersonIds(Collection<PersonId> var1);

    public void saveEmailNotificationSettings(DBEmailNotificationSettings var1);

    public void updateAccountSettings(DBAccountSettings var1);

    public void updateLastLoginDate(PersonId var1, Date var2);

    public void updatePassword(PersonId var1, String var2);

    public void updatePassword(PersonId var1, String var2, String var3);

    public void setPersonRoles(PersonId var1, Set<PersonRole> var2);

    public void addPersonRoles(PersonId var1, Set<PersonRole> var2);

    @Nonnull
    public List<PersonId> getAllPersonIds(boolean var1, int var2, int var3);

    public void updateImage(PersonId var1, String var2);

    @Nonnull
    public ImmutableList<PersonId> getUpcomingBirthdays(int var1, DateTime var2);

    @Nonnull
    public List<PersonId> getPersonIdsByRole(List<String> var1);

    public void updatePersonModifyDate(PersonId var1, Date var2);

    public int getActiveUserCount();

    public int getTotalUserCount();

    public void synchronizePersonRoles(Set<PersonRole> var1);

    public int forAllPersons(Consumer<DBPerson> var1);

    public int forAllPersonsChunked(int var1, Consumer<ImmutableList<DBPerson>> var2);

    public int forAllPersonRoles(BiConsumer<PersonId, PersonRole> var1);

    public boolean getPersonWithMd5Password(BiConsumer<PersonId, String> var1);
}

