/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.settings;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.person.business.settings.BooleanSettingConverter;
import de.justsoftware.onx.person.business.settings.EnumSettingConverter;
import de.justsoftware.onx.person.business.settings.SearchTextBoxFilterIdSettingsConverter;
import de.justsoftware.onx.person.business.settings.SettingsConverter;
import de.justsoftware.onx.person.business.settings.StringSettingConverter;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class Setting<T> {
    public static final Setting<Boolean> ACCEPTED_IMAGE_LEGAL_TERMS = new Setting<Boolean>("ACCEPTED_IMAGE_LEGAL_TERMS", new BooleanSettingConverter());
    public static final Setting<String> ROLE_TO_VIEW_MULTI_WIKI = new Setting<String>("MULTI_WIKI_VIEW_ROLE", new StringSettingConverter());
    public static final Setting<SearchTextBoxFilterId> DEFAULT_SEARCH_FILTER = new Setting<SearchTextBoxFilterId>("DEFAULT_SEARCH_FILTER", new SearchTextBoxFilterIdSettingsConverter());
    public static final Setting<JabberPresence> PRESENCE_STATUS = new Setting<JabberPresence>("PRESENCE_STATUS", new EnumSettingConverter<JabberPresence>(JabberPresence.class));
    public static final Setting<String> LAST_USED_APP = new Setting<String>("LAST_USED_APP", new StringSettingConverter());
    public static final Setting<Boolean> POWER_BAR = new Setting<Boolean>("POWER_BAR", new BooleanSettingConverter());
    public static final Function<Setting<?>, String> TO_DB_KEY = new NullPermeableFunction<Setting<?>, String>(){

        @Override
        protected String applySafe(Setting<?> setting) {
            return setting.getDBKey();
        }
    };
    public static final ImmutableSet<Setting<? extends Serializable>> SETTINGS = ImmutableSet.builder().add(ACCEPTED_IMAGE_LEGAL_TERMS).add(ROLE_TO_VIEW_MULTI_WIKI).add(DEFAULT_SEARCH_FILTER).add(PRESENCE_STATUS).add(LAST_USED_APP).add(POWER_BAR).build();
    public static final ImmutableSet<String> KEYS = FluentIterable.from(SETTINGS).transform(TO_DB_KEY).filter(Predicates.notNull()).toSet();
    private final SettingsConverter<T> _converter;
    private final String _dbSettingType;

    private Setting(String dbSettingType, SettingsConverter<T> converter) {
        this._dbSettingType = dbSettingType;
        this._converter = converter;
    }

    public String getDBKey() {
        return this._dbSettingType;
    }

    public T convertFromDB(String s) {
        if (s == null) {
            return null;
        }
        return this._converter.convertFromString(s);
    }

    @CheckForNull
    public String convertToDB(@Nullable T t) {
        if (t == null) {
            return null;
        }
        return this._converter.convertToString(t);
    }
}

