/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.configfile.ProfileConfigService;
import de.justsoftware.onx.container.business.StartpageTeaserService;
import de.justsoftware.onx.container.business.StartpageTopNewsService;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.person.business.StartpageService;
import de.justsoftware.onx.person.shared.model.BirthdaysStartpageComponent;
import de.justsoftware.onx.person.shared.model.startpage.EntityTeaserStartpageComponentConf;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponent;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponentConf;
import de.justsoftware.onx.person.shared.model.startpage.StartpageModel;
import de.justsoftware.onx.person.shared.model.startpage.StaticStartpageComponentConf;
import de.justsoftware.onx.workstream.shared.model.WorkstreamStartpageComponent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class StartpageServiceImpl
implements StartpageService {
    private final ProfileConfigService _profileConfigService;
    private final StartpageTeaserService _startpageTeaserService;
    private final StartpageTopNewsService _startpageTopNewsService;

    @Autowired
    public StartpageServiceImpl(ProfileConfigService profileConfigService, StartpageTeaserService startpageTeaserService, StartpageTopNewsService startpageTopNewsService) {
        this._profileConfigService = profileConfigService;
        this._startpageTeaserService = startpageTeaserService;
        this._startpageTopNewsService = startpageTopNewsService;
    }

    @Override
    public StartpageModel startpageForPerson(AuthorizationCheckContextWithUserId authCtx) {
        ImmutableListMultimap<ComponentPosition, StartpageComponentConf> config = this._profileConfigService.getStartpageComponentConf();
        return new StartpageModel((ImmutableListMultimap<ComponentPosition, StartpageComponent>)ImmutableListMultimap.copyOf((Multimap)Multimaps.transformValues(config, (Function)new ComponentVistor(authCtx))));
    }

    @ParametersAreNonnullByDefault
    private class ComponentVistor
    implements StartpageComponentConf.Visitor<StartpageComponent>,
    Function<StartpageComponentConf, StartpageComponent> {
        private final AuthorizationCheckContextWithUserId _authCtx;

        public ComponentVistor(AuthorizationCheckContextWithUserId authCtx) {
            this._authCtx = authCtx;
        }

        @Override
        public StartpageComponent visitWorkstream(StaticStartpageComponentConf staticStartpageComponentConf) {
            return new WorkstreamStartpageComponent();
        }

        @Override
        public StartpageComponent visit(EntityTeaserStartpageComponentConf entityTeaserStartpageComponentConf) {
            return StartpageServiceImpl.this._startpageTeaserService.getTeaserForStartpage(entityTeaserStartpageComponentConf, this._authCtx);
        }

        @Override
        public StartpageComponent visitBirthdays(StaticStartpageComponentConf staticStartpageComponentConf) {
            return new BirthdaysStartpageComponent();
        }

        @Override
        public StartpageComponent visitTopNews(StaticStartpageComponentConf staticStartpageComponentConf) {
            return StartpageServiceImpl.this._startpageTopNewsService.getTopNewsForStartpage(this._authCtx);
        }

        public StartpageComponent apply(@Nullable StartpageComponentConf input) {
            return input != null ? input.accept(this) : null;
        }
    }
}

