/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.business.StartpageItemDeletionHandler;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartpageItemDeletionHandlerImpl
implements StartpageItemDeletionHandler {
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        this.handleProfileDelete(Iterables.filter(parentIds, ProfileId.class), deletionContext);
    }

    private void handleProfileDelete(@Nonnull Iterable<ProfileId> profileIds, final @Nonnull DeletionContext deletionContext) {
        ImmutableSet idsToDelete = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(profileIds, (Function)new Function<ProfileId, StartpageId>(){

            public StartpageId apply(@Nullable ProfileId input) {
                StartpageId startpageId;
                if (input != null && !deletionContext.isItemDeleted(startpageId = input.asPersonId().asStartpageId())) {
                    return startpageId;
                }
                return null;
            }
        }), (Predicate)Predicates.notNull()));
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)idsToDelete, deletionContext);
    }
}

