/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.business.ProfileComponentsDeletionHandler;
import de.justsoftware.onx.person.integration.persistence.ibatis.PersonDataDeleteDAO;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfileComponentsDeletionHandlerImpl
implements ProfileComponentsDeletionHandler {
    @Autowired
    private PersonDataDeleteDAO _personDeleteDAO;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        this.handleProfileDelete(Iterables.filter(parentIds, ProfileId.class));
    }

    private void handleProfileDelete(@Nonnull Iterable<ProfileId> profileIds) {
        for (ProfileId profileId : profileIds) {
            PersonId personId = profileId.asPersonId();
            this._personDeleteDAO.deleteProfileComponents(personId);
        }
    }
}

