/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.ExceptionConstants;
import com.freiheit.toro.common.shared.i18n.ExceptionMessages;
import com.freiheit.toro.common.shared.util.Verification;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.gwt.i18n.dynamic.server.I18nMessagesFactory;
import de.justsoftware.gwt.i18n.dynamic.shared.model.I18nMessage;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.model.ValidationResult;
import de.justsoftware.onx.common.shared.property.marker.DynamicProperty;
import de.justsoftware.onx.common.shared.util.PasswordCheck;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonTestValidator;
import de.justsoftware.onx.person.business.model.RegistrationModel;
import de.justsoftware.onx.person.business.util.RegistrationFieldUtil;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.person.shared.util.PersonUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class PersonValidatorImpl
implements PersonTestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PersonValidatorImpl.class);
    private Map<String, Integer> _fieldLengthMap;
    private ImmutableMap<String, Integer> _immutableFieldLengthMap;
    @Autowired
    private PersonService _personService;
    @Autowired
    private Settings _settings;

    @Required
    public void setFieldLengthMap(Map<String, Integer> fieldLengthMap) {
        this._fieldLengthMap = fieldLengthMap;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this._immutableFieldLengthMap = ImmutableMap.copyOf(this._fieldLengthMap);
    }

    @Override
    public ImmutableMap<String, Integer> getFieldLengths() {
        return this._immutableFieldLengthMap;
    }

    @Nonnull
    private ImmutableListMultimap<String, ValidationError> validateFieldLength(Object object, final Map<String, I18nMessage> i18nMap, final Integer listIndex, final I18nMessagesFactory messageFactory) {
        return new FieldProcessor(){

            @Override
            public void processField(Object fieldValue, String fieldId, Field classField) {
                if (fieldValue instanceof String) {
                    I18nMessage fieldName = (I18nMessage)i18nMap.get(fieldId);
                    Integer maxLength = (Integer)PersonValidatorImpl.this._immutableFieldLengthMap.get((Object)fieldId);
                    if (maxLength == null) {
                        LOG.warn("The maximum length for field {} ({}) is empty. Skipping this field! ", (Object)fieldName, (Object)fieldId);
                    } else {
                        ValidationError error = PersonValidatorImpl.this.validateLength((String)fieldValue, maxLength, fieldName, messageFactory);
                        this.addError(fieldId, error, listIndex);
                    }
                }
            }
        }.processFields(object);
    }

    @Nonnull
    private ImmutableListMultimap<String, ValidationError> validateWritableFields(Object newObject, final Object oldObject, final Map<String, I18nMessage> i18nMap, final I18nMessagesFactory i18nMessagesFactory, final Integer listIndex, final Collection<String> restrictedFields, final String ... additionalWildcards) {
        return new FieldProcessor(){

            @Override
            public void processField(Object fieldValue, String fieldId, Field classField) {
                if (PersonUtil.isRestricted(fieldId, restrictedFields, additionalWildcards)) {
                    ValidationError error = PersonValidatorImpl.this.validateWritableField(oldObject, (I18nMessage)i18nMap.get(fieldId), i18nMessagesFactory, fieldValue, classField);
                    this.addError(fieldId, error, listIndex);
                }
            }
        }.processFields(newObject);
    }

    private ValidationError validateWritableField(Object oldObject, I18nMessage fieldName, I18nMessagesFactory messageFactory, Object fieldValue, Field classField) {
        try {
            Object oldFieldValue;
            Object object = oldFieldValue = oldObject != null ? classField.get(oldObject) : null;
            if (fieldValue == null && oldFieldValue != null || fieldValue != null && oldFieldValue == null || fieldValue != null && !fieldValue.equals(oldFieldValue)) {
                return new MessageAssembler<ExceptionMessages>(){

                    @Override
                    String getMessageValue(ExceptionMessages i18nMessage, String argument) {
                        return i18nMessage.yourAreNotAllowedToSaveThis(argument);
                    }
                }.assemble(messageFactory, fieldName, ExceptionMessages.class);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error("Wrong arguments for accessing " + classField.getName());
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access " + classField.getName());
        }
        return null;
    }

    @Nonnull
    private ImmutableListMultimap<String, ValidationError> validateMandatoryFields(Object object, final Map<String, I18nMessage> i18nMap, final I18nMessagesFactory messageFactory, final Integer listIndex) {
        return new FieldProcessor(){

            @Override
            public void processField(Object fieldValue, String fieldId, Field classField) {
                de.justsoftware.onx.common.shared.model.Field fieldAnnotation;
                I18nMessage fieldName = (I18nMessage)i18nMap.get(fieldId);
                if (classField.isAnnotationPresent(de.justsoftware.onx.common.shared.model.Field.class) && (fieldAnnotation = classField.getAnnotation(de.justsoftware.onx.common.shared.model.Field.class)).required()) {
                    ValidationError error = PersonValidatorImpl.this.validateMandatoryField(messageFactory, fieldValue, fieldName);
                    this.addError(fieldId, error, listIndex);
                }
            }
        }.processFields(object);
    }

    private ValidationError validateMandatoryField(I18nMessagesFactory messageFactory, Object fieldValue, I18nMessage fieldName) {
        if (fieldValue == null || fieldValue instanceof String && StringUtils.isBlank((String)((String)fieldValue))) {
            return new MessageAssembler<ExceptionMessages>(){

                @Override
                String getMessageValue(ExceptionMessages i18nMessage, String argument) {
                    return i18nMessage.isMandatory(argument);
                }
            }.assemble(messageFactory, fieldName, ExceptionMessages.class);
        }
        return null;
    }

    protected void addError(String fieldId, I18nMessage error, ImmutableListMultimap.Builder<String, ValidationError> result) {
        LOG.warn("Validation error: " + error);
        result.put((Object)fieldId, (Object)new ValidationError(error));
    }

    @Nonnull
    protected Map<String, I18nMessage> createI18nMap() {
        HashMap<String, I18nMessage> i18nMap = new HashMap<String, I18nMessage>();
        I18nMessagesFactory i18nMessagesFactory = new I18nMessagesFactory();
        ProfileConstants profileConstants = (ProfileConstants)i18nMessagesFactory.createProxy(ProfileConstants.class);
        BasicConstants basicConstants = (BasicConstants)i18nMessagesFactory.createProxy(BasicConstants.class);
        i18nMap.put("person.*", i18nMessagesFactory.getMessage(basicConstants.profile()));
        i18nMap.put("person.email", i18nMessagesFactory.getMessage(profileConstants.email()));
        i18nMap.put("person.firstname", i18nMessagesFactory.getMessage(profileConstants.firstName()));
        i18nMap.put("person.lastname", i18nMessagesFactory.getMessage(profileConstants.lastName()));
        i18nMap.put("person.new.email", i18nMessagesFactory.getMessage(profileConstants.newEmail()));
        i18nMap.put("person.title", i18nMessagesFactory.getMessage(profileConstants.title()));
        i18nMap.put("person.birthday", i18nMessagesFactory.getMessage(profileConstants.birthday()));
        i18nMap.put("person.password", i18nMessagesFactory.getMessage(basicConstants.password()));
        i18nMap.put("person.additionalTitle", i18nMessagesFactory.getMessage(profileConstants.additionalTitle()));
        return i18nMap;
    }

    @CheckForNull
    private ValidationError validateLength(String fieldValue, final int maxLength, I18nMessage fieldName, I18nMessagesFactory messageFactory) {
        if (fieldValue == null || fieldValue.length() <= maxLength) {
            return null;
        }
        return new MessageAssembler<ExceptionMessages>(){

            @Override
            String getMessageValue(ExceptionMessages i18nMessage, String argument) {
                return i18nMessage.exceedingLength(argument, String.valueOf(maxLength));
            }
        }.assemble(messageFactory, fieldName, ExceptionMessages.class);
    }

    @Nonnull
    private static ImmutableList<Field> getAllClassAndSuperClassFields(@Nullable Class<?> clazz) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Class<?> clz = clazz; clz != null; clz = clz.getSuperclass()) {
            result.add((Object[])clz.getDeclaredFields());
        }
        return result.build();
    }

    @Override
    public Map<String, Collection<ValidationError>> validate(DBPerson newPerson, DBPerson oldPerson) {
        String[] wildCards = new String[]{"person.*"};
        String generalFieldId = "person.*";
        Map<String, I18nMessage> i18nMap = this.createI18nMap();
        return this.validate(newPerson, oldPerson, null, i18nMap, new I18nMessagesFactory(), "person.*", oldPerson == null, wildCards).asMap();
    }

    @Override
    public ImmutableListMultimap<String, ValidationError> validate(DBAccountSettings newSettings, DBAccountSettings oldSettings) {
        String[] wildCards = new String[]{"person.*"};
        String generalFieldId = "person.*";
        Map<String, I18nMessage> i18nMap = this.createI18nMap();
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        result.putAll(this.validate(newSettings, i18nMap));
        result.putAll(this.validate(newSettings, oldSettings, null, i18nMap, new I18nMessagesFactory(), "person.*", false, wildCards));
        return result.build();
    }

    @Override
    public Map<String, Collection<ValidationError>> validate(PersonId userId, NameSettings newSettings, NameSettings oldSettings) {
        Map<String, I18nMessage> i18nMap = this.createI18nMap();
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        result.putAll(this.validate(newSettings, oldSettings, null, i18nMap, new I18nMessagesFactory(), "person.*", false, "person.*"));
        return result.build().asMap();
    }

    @Nonnull
    private ImmutableListMultimap<String, ValidationError> validate(DBAccountSettings newSettings, Map<String, I18nMessage> i18nMap) {
        String newmail;
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        I18nMessagesFactory messageFactory = new I18nMessagesFactory();
        ExceptionMessages exceptionMsgs = (ExceptionMessages)messageFactory.createProxy(ExceptionMessages.class);
        ExceptionConstants exceptionConstants = (ExceptionConstants)messageFactory.createProxy(ExceptionConstants.class);
        String newPassword = newSettings.getNewPassword();
        if (newPassword != null) {
            this.validatePassword(newPassword, messageFactory, (com.freiheit.toro.common.shared.i18n.BasicConstants)messageFactory.createProxy(com.freiheit.toro.common.shared.i18n.BasicConstants.class), (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        if ((newmail = newSettings.getNewmail()) != null) {
            DBPerson dup;
            DBPerson dbPerson;
            if (!Verification.verifyEmail(newmail)) {
                this.addError("person.new.email", messageFactory.getMessage(exceptionMsgs.isInvalid(messageFactory.messageAsArgument(i18nMap.get("person.new.email")))), (ImmutableListMultimap.Builder<String, ValidationError>)result);
            }
            if (!this._settings.getEmailPatternRegEx().matcher(newmail).matches()) {
                this.addError("person.new.email", messageFactory.getMessage(exceptionMsgs.illegalEmailShort(this._settings.getEmailPattern())), (ImmutableListMultimap.Builder<String, ValidationError>)result);
            }
            if (!StringUtils.equals((String)(dbPerson = this._personService.getPersonByIdNotNull(newSettings.getPersonId())).getEmail(), (String)newmail) && !StringUtils.equals((String)dbPerson.getNewmail(), (String)newmail) && (dup = this._personService.getPersonByEmailOrNewmail(newmail)) != null) {
                this.addError("person.new.email", messageFactory.getMessage(exceptionConstants.duplicateEmail()), (ImmutableListMultimap.Builder<String, ValidationError>)result);
            }
        }
        return result.build();
    }

    private <T> ImmutableListMultimap<String, ValidationError> validate(@Nonnull T newObject, @Nullable T oldObject, @Nullable Integer listIndex, Map<String, I18nMessage> i18nMap, I18nMessagesFactory i18nMessageFactory, String generalFieldId, boolean isNewPerson, String ... wildCards) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        if (!isNewPerson) {
            ImmutableList<String> restrictedFields = this._settings.getModificationRestrictedPersonFields();
            if (oldObject == null && newObject != null && PersonUtil.isRestricted(null, restrictedFields, wildCards)) {
                ExceptionMessages exceptionMsgs = (ExceptionMessages)i18nMessageFactory.createProxy(ExceptionMessages.class);
                I18nMessage errorMsg = i18nMessageFactory.getMessage(exceptionMsgs.yourAreNotAllowedToSaveThis(i18nMessageFactory.messageAsArgument(i18nMap.get(generalFieldId))));
                return ImmutableListMultimap.of((Object)generalFieldId, (Object)new ValidationError(errorMsg));
            }
            result.putAll(this.validateWritableFields(newObject, oldObject, i18nMap, i18nMessageFactory, listIndex, (Collection<String>)restrictedFields, wildCards));
        }
        result.putAll(this.validateFieldLength(newObject, i18nMap, null, i18nMessageFactory));
        result.putAll(this.validateMandatoryFields(newObject, i18nMap, i18nMessageFactory, listIndex));
        return result.build();
    }

    @Override
    public boolean accountExists(String email) {
        if (StringUtil.isBlank(email)) {
            return false;
        }
        return this._personService.getPersonByEmailOrNewmail(email) != null;
    }

    @Override
    public ImmutableListMultimap<String, ValidationError> validateStaticRegistrationFields(RegistrationModel registrationModel) {
        String[] wildCards = new String[]{"person.*"};
        String generalFieldId = "person.*";
        Map<String, I18nMessage> i18nMap = this.createI18nMap();
        I18nMessagesFactory messageFactory = new I18nMessagesFactory();
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        result.putAll(this.validateEmailPasswordAndTerms(registrationModel, messageFactory, i18nMap));
        result.putAll(this.validate(registrationModel, null, null, i18nMap, new I18nMessagesFactory(), "person.*", true, wildCards));
        return result.build();
    }

    @Override
    public ImmutableListMultimap<String, ValidationError> validateEmailAndPasswordOnly(RegistrationModel registrationModel) {
        Map<String, I18nMessage> i18nMap = this.createI18nMap();
        I18nMessagesFactory messageFactory = new I18nMessagesFactory();
        ExceptionConstants exceptionConstants = (ExceptionConstants)messageFactory.createProxy(ExceptionConstants.class);
        ExceptionMessages exceptionMsgs = (ExceptionMessages)messageFactory.createProxy(ExceptionMessages.class);
        com.freiheit.toro.common.shared.i18n.BasicConstants basicConstants = (com.freiheit.toro.common.shared.i18n.BasicConstants)messageFactory.createProxy(com.freiheit.toro.common.shared.i18n.BasicConstants.class);
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        String email = registrationModel.getEmail();
        if (email != null) {
            this.validateRegistrationEmail(email.trim().toLowerCase(), messageFactory, i18nMap, exceptionMsgs, exceptionConstants, (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        this.validatePassword(registrationModel.getPassword(), messageFactory, basicConstants, (ImmutableListMultimap.Builder<String, ValidationError>)result);
        return result.build();
    }

    @Nonnull
    private ImmutableListMultimap<String, ValidationError> validateEmailPasswordAndTerms(@Nonnull RegistrationModel registration, @Nonnull I18nMessagesFactory messageFactory, @Nonnull Map<String, I18nMessage> i18nMap) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        ExceptionMessages exceptionMsgs = (ExceptionMessages)messageFactory.createProxy(ExceptionMessages.class);
        ExceptionConstants exceptionConstants = (ExceptionConstants)messageFactory.createProxy(ExceptionConstants.class);
        com.freiheit.toro.common.shared.i18n.BasicConstants basicConstants = (com.freiheit.toro.common.shared.i18n.BasicConstants)messageFactory.createProxy(com.freiheit.toro.common.shared.i18n.BasicConstants.class);
        String email = registration.getEmail();
        if (email != null) {
            this.validateRegistrationEmail(email.trim().toLowerCase(), messageFactory, i18nMap, exceptionMsgs, exceptionConstants, (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        this.validatePassword(registration.getPassword(), messageFactory, basicConstants, (ImmutableListMultimap.Builder<String, ValidationError>)result);
        if (!registration.isTermsAccepted() && this._settings.isTermsAcceptanceRequired()) {
            this.addError("person.terms", messageFactory.getMessage(exceptionConstants.termsAcceptanceRequired()), (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        if (this._settings.isAdditionalTermsAcceptanceRequired() && !registration.isAdditionalTermsAccepted()) {
            this.addError("person.additionalTerms", messageFactory.getMessage(exceptionConstants.additionalTermsAcceptanceRequired()), (ImmutableListMultimap.Builder<String, ValidationError>)result);
        }
        return result.build();
    }

    private void validateRegistrationEmail(@Nonnull String email, @Nonnull I18nMessagesFactory messageFactory, @Nonnull Map<String, I18nMessage> i18nMap, @Nonnull ExceptionMessages exceptionMsgs, @Nonnull ExceptionConstants exceptionConstants, @Nonnull ImmutableListMultimap.Builder<String, ValidationError> result) {
        if (!Verification.verifyEmail(email)) {
            this.addError("person.email", messageFactory.getMessage(exceptionMsgs.isInvalid(messageFactory.messageAsArgument(i18nMap.get("person.email")))), result);
        } else if (this.accountExists(email)) {
            this.addError("person.email", messageFactory.getMessage(exceptionConstants.accountAlreadyExists()), result);
        } else {
            Pattern emailPattern = this._settings.getRegisterEmailPatternRegEx();
            if (emailPattern != null && !emailPattern.matcher(email).matches()) {
                String emailFormat = this._settings.getRegisterEmailPattern();
                this.addError("person.email", messageFactory.getMessage(exceptionMsgs.illegalEmailShort(emailFormat)), result);
            }
        }
    }

    @Override
    public List<ValidationResult> validatePassword(String password) {
        ImmutableListMultimap.Builder errorsBuilder = ImmutableListMultimap.builder();
        I18nMessagesFactory messageFactory = new I18nMessagesFactory();
        com.freiheit.toro.common.shared.i18n.BasicConstants basicConstants = (com.freiheit.toro.common.shared.i18n.BasicConstants)messageFactory.createProxy(com.freiheit.toro.common.shared.i18n.BasicConstants.class);
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        result.add(new ValidationResult(messageFactory.getMessage(basicConstants.passwdTooShort()), ValidationResult.Status.ERROR));
        result.add(new ValidationResult(messageFactory.getMessage(basicConstants.passwdNoLetter()), ValidationResult.Status.ERROR));
        result.add(new ValidationResult(messageFactory.getMessage(basicConstants.passwdOnlyLetters()), ValidationResult.Status.ERROR));
        this.validatePassword(password, messageFactory, basicConstants, (ImmutableListMultimap.Builder<String, ValidationError>)errorsBuilder);
        ImmutableListMultimap errors = errorsBuilder.build();
        ImmutableList passwordErrors = errors.get((Object)"person.password");
        for (ValidationResult r : result) {
            boolean contains = false;
            if (passwordErrors != null) {
                Iterator iterator = passwordErrors.iterator();
                while (iterator.hasNext() && !contains) {
                    ValidationError error = (ValidationError)iterator.next();
                    if (!error.getMessage().getKey().equals(r.getMessage().getKey())) continue;
                    contains = true;
                }
            }
            if (contains) continue;
            r.setStatus(ValidationResult.Status.OK);
        }
        return result;
    }

    private void validatePassword(String password, I18nMessagesFactory messageFactory, com.freiheit.toro.common.shared.i18n.BasicConstants basicConstants, ImmutableListMultimap.Builder<String, ValidationError> result) {
        if (!PasswordCheck.isSecure(password)) {
            this.addError("person.password", messageFactory.getMessage(basicConstants.passwdInsecure()), result);
            if (!PasswordCheck.checkLength(password)) {
                this.addError("person.password", messageFactory.getMessage(basicConstants.passwdTooShort()), result);
            }
            if (!PasswordCheck.checkAlpha(password)) {
                this.addError("person.password", messageFactory.getMessage(basicConstants.passwdNoLetter()), result);
            }
            if (!PasswordCheck.checkAdditionalChar(password)) {
                this.addError("person.password", messageFactory.getMessage(basicConstants.passwdOnlyLetters()), result);
            }
        }
    }

    @Override
    public ImmutableList<String> getRegistrationFields() {
        ImmutableSet<String> hiddenFields = this._settings.getHiddenPersonFields();
        return FluentIterable.from(RegistrationFieldUtil.REQUIRED_STATIC_FIELDS).append(this._settings.getConfiguredRegisterPersonFields()).filter(Predicates.not((Predicate)Predicates.in(hiddenFields))).toList();
    }

    protected PersonService getPersonService() {
        return this._personService;
    }

    private static abstract class MessageAssembler<T extends DynamicProperty> {
        private MessageAssembler() {
        }

        ValidationError assemble(I18nMessagesFactory messageFactory, I18nMessage fieldName, Class<T> messageInterface) {
            DynamicProperty exceptionMsgs = (DynamicProperty)messageFactory.createProxy(messageInterface);
            return new ValidationError(messageFactory.getMessage(this.getMessageValue(exceptionMsgs, this.getMessageArgument(messageFactory, fieldName))));
        }

        private String getMessageArgument(I18nMessagesFactory messageFactory, I18nMessage fieldName) {
            if (fieldName != null) {
                return messageFactory.messageAsArgument(fieldName);
            }
            return "";
        }

        abstract String getMessageValue(T var1, String var2);
    }

    private abstract class FieldProcessor {
        private final ImmutableListMultimap.Builder<String, ValidationError> _result = ImmutableListMultimap.builder();

        private FieldProcessor() {
        }

        protected abstract void processField(Object var1, String var2, Field var3);

        protected void addError(@Nonnull String fieldId, @Nullable ValidationError error, @Nullable Integer listIndex) {
            if (error == null) {
                return;
            }
            if (listIndex != null) {
                this._result.put((Object)(fieldId + "_" + listIndex.toString()), (Object)error);
            } else {
                this._result.put((Object)fieldId, (Object)error);
            }
        }

        @Nonnull
        ImmutableListMultimap<String, ValidationError> processFields(@Nonnull Object object) {
            for (Field classField : PersonValidatorImpl.getAllClassAndSuperClassFields(object.getClass())) {
                if (!classField.isAnnotationPresent(de.justsoftware.onx.common.shared.model.Field.class)) continue;
                classField.setAccessible(true);
                de.justsoftware.onx.common.shared.model.Field fieldAnnotation = classField.getAnnotation(de.justsoftware.onx.common.shared.model.Field.class);
                Object fieldValue = null;
                try {
                    fieldValue = classField.get(object);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Wrong arguments for accessing " + classField.getName());
                }
                catch (IllegalAccessException e) {
                    LOG.error("Could not access " + classField.getName());
                }
                this.processField(fieldValue, fieldAnnotation.id(), classField);
            }
            return this._result.build();
        }
    }
}

