/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.account.business.VerificationCodeService;
import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageType;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.album.business.events.ImageCreatedEvent;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.calendar.business.CalendarFeedWriteDataService;
import de.justsoftware.onx.chat.business.ChatServiceInternalApiConnector;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.ProfileConfigService;
import de.justsoftware.onx.common.business.configfile.parser.ConfComponentType;
import de.justsoftware.onx.common.business.configfile.pathmatcher.Path;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.ProfileModuleService;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.business.events.EntityParticipantCountDecreasedEvent;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.events.PersonActivatedEvent;
import de.justsoftware.onx.events.PersonAuthenticatedEvent;
import de.justsoftware.onx.events.PersonBlockedStatusChangedEvent;
import de.justsoftware.onx.events.PersonDeactivatedEvent;
import de.justsoftware.onx.events.PersonDeletedEvent;
import de.justsoftware.onx.events.PersonModifyDateChangedEvent;
import de.justsoftware.onx.events.PersonUpdatedEvent;
import de.justsoftware.onx.mail.business.MailServiceOld;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.business.PersonBackupService;
import de.justsoftware.onx.person.business.PersonCommand;
import de.justsoftware.onx.person.business.PersonCommandVisitor;
import de.justsoftware.onx.person.business.PersonInsertCommand;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.business.PersonUpdateCommand;
import de.justsoftware.onx.person.business.PersonValidator;
import de.justsoftware.onx.person.business.attributes.errors.ConfigErrorException;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.MultiLangBook;
import de.justsoftware.onx.person.business.attributes.i18n.Translations;
import de.justsoftware.onx.person.business.events.NewContactEvent;
import de.justsoftware.onx.person.business.events.PersonDataChangedEventByUser;
import de.justsoftware.onx.person.business.events.PersonNameChangedEvent;
import de.justsoftware.onx.person.business.events.RemoveContactEvent;
import de.justsoftware.onx.person.business.model.ProfileAllowedComponent;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.DBProfileComponent;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import de.justsoftware.onx.person.shared.server.ProfileComponentInfo;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.process.business.model.AccountActivationResult;
import de.justsoftware.onx.searchnew.integration.persistence.SearchFilterDAO;
import de.justsoftware.onx.secret.business.HMacSecretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.security.service.MobileLogoutService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.util.server.Base64Util;
import de.justsoftware.onx.util.server.HMacUtil;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.videolink.business.events.VideolinkCreatedEvent;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class PersonServiceImpl
implements ServerEventHandler,
PersonService {
    public static final Duration CHANGE_EMAIL_REQUEST_LIFETIME = Duration.ofDays(1L);
    private static final Logger LOG = LoggerFactory.getLogger(PersonServiceImpl.class);
    private static final String DELETED_USER_FIRSTNAME = "Deleted";
    private static final String DELETED_USER_LASTNAME = "User";
    private static final PersonId DELETED_PERSON_ID = new PersonId(-1L);
    private static final int UPDATE_EMAIL_CODE_LENGTH = 48;
    @Autowired
    private Settings _settings;
    @Autowired
    private ProfileModuleService _moduleService;
    @Autowired
    private ConfigFileService _configFileService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private StorageServerHelper _storageServerHelper;
    @Autowired
    private LanguageService _languageService;
    @Autowired
    private MailServiceOld _mailService;
    @Autowired
    private ProfileConfigService _profileConfig;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private PersonBackupService _personBackupService;
    @Autowired
    private SearchFilterDAO _searchFilterDAO;
    @Autowired
    private VerificationCodeService _verificationCodeService;
    @Autowired
    private FriendsService _friendsService;
    @Autowired
    private CalendarFeedWriteDataService _calendarFeedWriteDataService;
    @Autowired
    private PersonSettingService _personSettingService;
    @Autowired
    private MobileLogoutService _mobileLogoutService;
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private ChatServiceInternalApiConnector _chatServiceInternalApiConnector;
    private final PersonDAO _personDAO;
    private final PersonReadWriteDataService _personReadWriteDataService;
    private final SecretService _secretService;
    private final PersonRoleService _personRoleService;
    private final I18nService _i18nService;
    private final JucoPasswordEncoder _passwordEncoder;
    private final PersonValidator _personValidator;
    private final JCEventBus _eventBus;
    private final Clock _clock;

    @Autowired
    @ParametersAreNonnullByDefault
    public PersonServiceImpl(PersonDAO personDAO, PersonReadWriteDataService personReadWriteDataService, SecretService secretService, PersonRoleService personRoleService, I18nService i18nService, JucoPasswordEncoder passwordEncoder, PersonValidator personValidator, JCEventBus eventBus, Clock clock) {
        this._personDAO = personDAO;
        this._personReadWriteDataService = personReadWriteDataService;
        this._secretService = secretService;
        this._personRoleService = personRoleService;
        this._i18nService = i18nService;
        this._passwordEncoder = passwordEncoder;
        this._personValidator = personValidator;
        this._eventBus = eventBus;
        this._clock = clock;
    }

    @Deprecated
    @Nonnull
    private Date getNowAsUtilDate() {
        return Date.from(Instant.now(this._clock));
    }

    @Deprecated
    @Nonnull
    private DateTime getNowAsJodaTime() {
        return new DateTime(Instant.now(this._clock).toEpochMilli());
    }

    private void handlePersonUpdate(@Nonnull PersonId personId) {
        this._personReadWriteDataService.updatePersonModifyDate(personId, this.getNowAsUtilDate());
        this._eventBus.post(new PersonUpdatedEvent(personId));
    }

    @Override
    public void notifyPersonActivated(PersonId personId, ServerEventCollector eventCollector) {
        eventCollector.add(new PersonActivatedEvent(personId));
        this.notifyContactsChanged(personId, false, eventCollector);
    }

    @Override
    public void notifyPersonDeactivated(PersonId personId, ServerEventCollector eventCollector) {
        eventCollector.add(new PersonDeactivatedEvent(personId));
        this.notifyContactsChanged(personId, true, eventCollector);
        this._mobileLogoutService.logoutFromMobileDevices(personId);
    }

    @Override
    public void notifyPersonBlocked(PersonId personId, boolean blocked, ServerEventCollector eventCollector) {
        eventCollector.add(new PersonBlockedStatusChangedEvent(personId, blocked));
        if (blocked) {
            this._mailService.sendReportBlockedUserMail(personId);
            this._mobileLogoutService.logoutFromMobileDevices(personId);
        }
    }

    @Override
    public void notifyPersonDeleted(PersonId personId, ServerEventCollector eventCollector) {
        eventCollector.add(new PersonDeletedEvent(personId));
        ImmutableList<EntityMemberWithEntityType> memberships = this._entityMemberService.getEntityMembershipsByPersonId(personId);
        for (EntityMember member : memberships) {
            ImmutableSetMultimap.Builder oldRoles = ImmutableSetMultimap.builder();
            oldRoles.putAll((Object)member.getPersonId(), member.getRoles());
            eventCollector.add(new EntityMembershipChangedEvent(member.getEntityId(), (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.of(), (ImmutableSetMultimap<PersonId, EntityMemberRole>)oldRoles.build(), true));
            if (!EntityMemberUtil.isAdminOrCoAdmin(member)) continue;
            eventCollector.add(new EntityAdminChangedEvent(member.getEntityId(), member.getPersonId(), EntityMemberRoles.EMPTY, member.getRoles()));
        }
        ImmutableSet entities = (ImmutableSet)memberships.stream().map(EntityMember.GET_ENTITY_ID).collect(ImmutableSet.toImmutableSet());
        eventCollector.add(new EntityParticipantCountDecreasedEvent((ImmutableSet<EntityId>)entities));
        this.notifyContactsChanged(personId, true, eventCollector);
    }

    private void notifyContactsChanged(@Nonnull PersonId personId, boolean contactRemoved, @Nonnull ServerEventCollector serverEventCollector) {
        ImmutableSet<PersonId> friends = this._friendsService.getFriendIdsOfId(personId);
        for (PersonId friend : friends) {
            ServerEvent event = contactRemoved ? new RemoveContactEvent(personId, friend) : new NewContactEvent(personId, friend);
            serverEventCollector.add(event);
        }
    }

    private void feedProfileChanged(@Nullable DBPerson oldPerson, @Nonnull DBPerson newPerson) {
        this._eventBus.post(new PersonDataChangedEventByUser(oldPerson, newPerson));
    }

    @Override
    public DBPerson getPersonById(PersonId personId) {
        return this._personReadWriteDataService.getPersonById(personId);
    }

    @Override
    public DBPerson getPersonByIdNotNull(PersonId personId) {
        return InvalidIdServiceException.check(this.getPersonById(personId));
    }

    @Override
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<PersonId> personIds) {
        return this._personReadWriteDataService.getPersonsByIds(personIds);
    }

    @Override
    public List<PersonId> getPersonIdsByRole(List<String> roleNames) {
        return this._personReadWriteDataService.getPersonIdsByRole(roleNames);
    }

    @Override
    public void deleteOwnPerson(AuthorizationCheckContextWithUserId authCtx) {
        PersonId personId = authCtx.getUserId();
        authCtx.check((ItemId)personId.asProfileId(), (Action)StaticAction.PERSON_DELETE);
        this.deletePersonInternal(personId, authCtx.getUserId()).afterCommit();
    }

    @Override
    public void deleteOtherPerson(PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check((ItemId)personId.asProfileId(), (Action)StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD);
        this.deletePersonInternal(personId, authCtx.getUserId()).afterCommit();
    }

    @Override
    public void deleteOtherPersonFromAllTenants(PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        ImmutableSet tenantIdsAsItemIds = (ImmutableSet)this._personTenantService.getTenantIdsForPerson(personId).stream().map(id -> ItemId.parse(id.asString())).collect(ImmutableSet.toImmutableSet());
        ImmutableSet manage = ImmutableSet.of((Object)StaticPermissionAction.MANAGE);
        authCtx.check((Iterable<? extends ItemId>)tenantIdsAsItemIds, (Set<? extends Action>)manage);
        authCtx.check(StaticAction.ADMIN_PERSON_DELETE_WITHOUT_PASSWORD);
        this.deletePersonInternal(personId, authCtx.getUserId()).afterCommit();
    }

    @Override
    public void deleteDependentPersons(Set<PersonId> personIds, DeletionContext deletionContext) {
        personIds.forEach(id -> {
            DeleteTransactionCallback deleteTransactionCallback = this.deletePersonInternal((PersonId)id, DELETED_PERSON_ID);
            deletionContext.attach(deleteTransactionCallback);
        });
    }

    private DeleteTransactionCallback deletePersonInternal(final @Nonnull PersonId personId, @Nonnull PersonId actorId) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this.notifyPersonDeleted(personId, eventCollector);
        this._deletionService.deleteInTransactionWithDeleteAction(personId.asProfileId(), actorId, new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                PersonServiceImpl.this.markPersonAsDeleted(personId, deleteAction);
                return this;
            }
        });
        return () -> {
            eventCollector.fireEvents(this._eventBus);
            this.handlePersonUpdate(personId);
        };
    }

    private void markPersonAsDeleted(PersonId personId, DeleteAction deleteAction) {
        if (deleteAction.isArchiveData()) {
            this._personBackupService.archivePerson(personId, deleteAction.getId());
        }
        this._personReadWriteDataService.updatePerson(PersonServiceImpl.getDeletedUserForPerson(personId), this.getNowAsJodaTime());
        this._personDAO.markAsDeleted(personId);
        this._searchFilterDAO.deleteStoredSearchFilterByPersonId(personId);
        this._calendarFeedWriteDataService.invalidateICalAccessToken(personId);
        this._personSettingService.deleteHomeScreenApps(personId);
        this._mobileLogoutService.logoutFromMobileDevices(personId);
    }

    @Nonnull
    private static DBPerson getDeletedUserForPerson(@Nonnull PersonId personToDelete) {
        DBPerson deletePerson = new DBPerson();
        deletePerson.setFirstName(DELETED_USER_FIRSTNAME);
        deletePerson.setLastName(DELETED_USER_LASTNAME);
        deletePerson.setActive(true);
        deletePerson.setEmail(null);
        deletePerson.setAdditionalTitle(null);
        deletePerson.setNewmail(null);
        deletePerson.setBirthdayVisibility(BirthdayVisibility.NONE);
        deletePerson.setBirthday(null);
        deletePerson.setBlocked(true);
        deletePerson.setTitle(null);
        deletePerson.setPasswordHash(null);
        deletePerson.setId(personToDelete);
        deletePerson.setLastLoginDate(new DateWithoutTimezone());
        return deletePerson;
    }

    private void validatePerson(DBPerson person, DBPerson oldPerson) throws ValidatableException {
        Map<String, Collection<ValidationError>> validationErrors = this._personValidator.validate(person, oldPerson);
        if (validationErrors != null && !validationErrors.isEmpty()) {
            throw new ValidatableException(validationErrors);
        }
    }

    @Override
    public boolean isProfileComponentVisible(PersonId personId, ComponentType componentType, AuthorizationCheckContext authorizationContext) {
        ImmutableList profileComponentInfos = this.getProfileComponentInfos((Set<PersonId>)ImmutableSet.of((Object)personId), authorizationContext).get((Object)personId);
        ProfileComponentInfo componentInfo = (ProfileComponentInfo)Iterables.find((Iterable)profileComponentInfos, info -> info != null && info.getComponentData().getComponentType() == componentType, null);
        return componentInfo != null && componentInfo.getComponentData().isVisible();
    }

    @Override
    public ImmutableTable<PersonId, ComponentType, ComponentModel> getVisibleComponents(Map<PersonId, ProfileItem> persons, SearchAuthorizationCheckContext authorizationContext) {
        ImmutableTable.Builder res = ImmutableTable.builder();
        ImmutableListMultimap<PersonId, ProfileComponentInfo> profileComponentInfos = this.getProfileComponentInfos(persons.keySet(), authorizationContext);
        for (Map.Entry<PersonId, ProfileItem> curPerson : persons.entrySet()) {
            for (ProfileComponentInfo profileComponentInfo : profileComponentInfos.get((Object)curPerson.getKey())) {
                DBProfileComponent profileComponent = profileComponentInfo.getComponentData();
                try {
                    if (!profileComponent.isVisible()) continue;
                    res.put((Object)curPerson.getKey(), (Object)profileComponent.getComponentType(), (Object)this.convertToComponentModel(curPerson.getValue(), profileComponent, authorizationContext));
                }
                catch (InvalidIDException e) {
                    LOG.error("Invalid Id for person component " + profileComponent.getComponentType().name(), (Throwable)e);
                }
            }
        }
        return res.build();
    }

    @Override
    public ImmutableListMultimap<PersonId, ProfileComponentInfo> getProfileComponentInfos(Set<PersonId> personIds, AuthorizationCheckContext authCtx) {
        ImmutableListMultimap.Builder res = ImmutableListMultimap.builder();
        ImmutableListMultimap<PersonId, DBProfileComponent> profileComponents = this._personReadWriteDataService.getProfileComponentsByIds(personIds);
        ImmutableListMultimap<PersonId, ProfileAllowedComponent> allowedComponents = this.getProfileAllowedComponents(personIds);
        ImmutableMap<PersonId, ProfileItem> profileItems = this.getProfileItemsByPersonIds(personIds);
        ImmutableSet<ProfileId> visibleProfiles = authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)personIds.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        for (final ProfileItem item : profileItems.values()) {
            PersonId curPersonId = item.getId().asPersonId();
            boolean profileVisible = visibleProfiles.contains((Object)item.getId());
            ImmutableMap profileComponentsMap = Maps.uniqueIndex((Iterable)profileComponents.get((Object)curPersonId), DBProfileComponent.TO_COMPONENT_TYPE);
            ImmutableList curAllowedComponents = allowedComponents.get((Object)curPersonId);
            int order = 0;
            for (ProfileAllowedComponent allowed : curAllowedComponents) {
                ComponentType componentType = allowed.getComponentType();
                DBProfileComponent profileComponent = (DBProfileComponent)profileComponentsMap.get((Object)componentType);
                if (profileComponent == null) {
                    final DBProfileComponent newComponent = new DBProfileComponent();
                    newComponent.setComponentType(componentType);
                    newComponent.setOrder(order);
                    newComponent.setPosition(allowed.getPosition());
                    newComponent.setParentId(curPersonId);
                    profileComponent = newComponent;
                    try {
                        final CollectingServerEventCollector collector = new CollectingServerEventCollector();
                        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

                            protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                                PersonServiceImpl.this._personReadWriteDataService.saveProfileComponent(newComponent);
                                PersonServiceImpl.this._moduleService.create(newComponent.getComponentType(), item, collector);
                            }
                        });
                        collector.fireEvents(this._eventBus);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Error while creating profile component data for component type " + newComponent.getComponentType().name(), (Throwable)e);
                        continue;
                    }
                }
                profileComponent.setPosition(allowed.getPosition());
                profileComponent.setOrder(order);
                profileComponent.setVisible(profileVisible);
                ProfileComponentInfo profileComponentInfo = new ProfileComponentInfo();
                profileComponentInfo.setComponentData(profileComponent);
                res.put((Object)curPersonId, (Object)profileComponentInfo);
                ++order;
            }
        }
        return res.build();
    }

    @Nonnull
    private ImmutableListMultimap<PersonId, ProfileAllowedComponent> getProfileAllowedComponents(@Nonnull Set<PersonId> personIds) {
        ImmutableMap<PersonId, ProfileItem> profileItems = this.getProfileItemsByPersonIds(personIds);
        return this.getProfileAllowedComponents(profileItems);
    }

    private ImmutableListMultimap<PersonId, ProfileAllowedComponent> getProfileAllowedComponents(ImmutableMap<PersonId, ProfileItem> profileItems) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        ConfFile configFile = this._configFileService.getConfigFile();
        for (ProfileItem profileItem : profileItems.values()) {
            ListMultimap<ComponentPosition, ConfComponentType> positions = configFile.getComponentPosition(Path.builder().add(profileItem).build());
            for (Map.Entry entry : positions.entries()) {
                ComponentPosition p = (ComponentPosition)entry.getKey();
                ConfComponentType t = (ConfComponentType)entry.getValue();
                result.put((Object)profileItem.getId().asPersonId(), (Object)new ProfileAllowedComponent(t.getComponentType(), p));
            }
        }
        return result.build();
    }

    @Override
    public MultiLangBook getRolesTranslation() {
        return this.getTranslation((Function<ProfileConstants, String>)((Function)constants -> constants != null ? constants.personRoles() : null));
    }

    @Override
    public PersonRolesClientTranslation getRolesTranslation(String locale) {
        ImmutableMap.Builder translatedTerms = ImmutableMap.builder();
        MultiLangBook rolesTranslation = this.getRolesTranslation();
        for (String term : rolesTranslation.getAllTerms()) {
            translatedTerms.put((Object)term, (Object)rolesTranslation.getI18n(term).getFor(Language.of(locale)));
        }
        return new PersonRolesClientTranslation((ImmutableMap<String, String>)translatedTerms.build());
    }

    @Nonnull
    private MultiLangBook getTranslation(@Nonnull Function<ProfileConstants, String> extractConfigurationString) {
        ImmutableSet<String> locales = this._i18nService.getAvailableLanguages();
        Collection translations = Collections2.transform(locales, languageId -> {
            ProfileConstants profileConstants = this._i18nService.createProxy(ProfileConstants.class, (String)languageId);
            String configurationString = (String)extractConfigurationString.apply((Object)profileConstants);
            try {
                return new Translations(Language.of(languageId), configurationString);
            }
            catch (ConfigErrorException | IllegalArgumentException e) {
                LOG.warn("Translations for language " + languageId + " dynamic fields are invalid: ", (Throwable)e);
                return null;
            }
        });
        List nonEmptyTransl = (List)translations.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        return new MultiLangBook(nonEmptyTransl);
    }

    @Nonnull
    private ComponentModel convertToComponentModel(@Nonnull ProfileItem profile, @Nonnull DBProfileComponent component, @Nonnull SearchAuthorizationCheckContext authorizationContext) throws InvalidIDException {
        ModuleData moduleData = this._moduleService.getModule(authorizationContext, profile, component.getComponentType());
        ComponentPositionConfig componentPositionConfig = new ComponentPositionConfig(component.getComponentType(), component.getPosition(), component.getOrder(), true, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<AuthorityModel>)ImmutableSet.of(), null);
        return new ComponentModel(component.getParentId().asProfileId(), componentPositionConfig, moduleData);
    }

    @Override
    public void removeImage(PersonId loggedInUserId) throws ValidatableException {
        DBPerson person = this.getPersonByIdNotNull(loggedInUserId);
        if (person.getImage() == null) {
            return;
        }
        this.savePerson(loggedInUserId, new PersonUpdateCommand(){

            @Override
            public DBPerson execute(DBPerson object) {
                object.setImage(null);
                return object;
            }
        }, PersonService.FeedMessageControl.GENERATE_FEED_MESSAGE);
        this._storageServerHelper.deleteFileOnStorageServer(ImageType.USER_IMAGE.getPath(), person.getImage());
    }

    @Override
    public AccountActivationResult activateAccountById(PersonId personId) {
        DBPerson activatedPerson = this.updateAccountActivated(personId, true);
        return activatedPerson.isBlocked() ? AccountActivationResult.ACCOUNT_BLOCKED : AccountActivationResult.READY_FOR_LOGIN;
    }

    @Override
    public void setAccountActivated(PersonId personId, boolean activated, AuthorizationCheckContext authorizationContext) {
        authorizationContext.check((ItemId)personId.asProfileId(), (Action)StaticAction.PERSON_ACTIVATE);
        this.updateAccountActivated(personId, activated);
    }

    @Nonnull
    private DBPerson updateAccountActivated(@Nonnull PersonId personId, boolean activated) {
        DBPerson oldPerson = this.getPersonByIdNotNull(personId);
        if (oldPerson.isActive() == activated) {
            return oldPerson;
        }
        this._personReadWriteDataService.updatePersonActivated(personId, activated);
        if (activated && this._settings.isBlockUserAfterRegistrationEnabled()) {
            this.setPersonBlocked(personId, true, EverythingAllowedAuthorizationCheckContext.INSTANCE);
        }
        DBPerson updatedPerson = this.getPersonByIdNotNull(personId);
        if (activated) {
            this.notifyPersonActivated(personId, new ImmediatelyFiringServerEventCollector(this._eventBus));
        } else {
            this.notifyPersonDeactivated(personId, new ImmediatelyFiringServerEventCollector(this._eventBus));
        }
        if (activated) {
            this.feedProfileChanged(oldPerson, updatedPerson);
        }
        return updatedPerson;
    }

    @Override
    public void changeLanguageForUser(PersonId personId, String languageCode) {
        final String toChangeLanguageCode = !this._languageService.getAvailableLanguageCode().contains((Object)languageCode) ? this._settings.defaultLanguage() : languageCode;
        try {
            this.savePerson(personId, new PersonUpdateCommand(){

                @Override
                public DBPerson execute(DBPerson person) {
                    person.setLanguageId(toChangeLanguageCode);
                    return person;
                }
            }, PersonService.FeedMessageControl.DONT_GENERATE_FEED_MESSAGE);
        }
        catch (ValidatableException e) {
            LOG.error("Could not change language: ", (Throwable)e);
        }
    }

    @Nonnull
    private byte[] codeForActivateNewMail(long date, long uid, @Nonnull String newMail) {
        HMacSecretKey secret = (HMacSecretKey)this._secretService.getSecretKey(SecretKeyName.ACTIVATE_NEW_EMAIL_SECRET);
        byte[] mailBytes = newMail.getBytes(Charsets.UTF_8);
        byte[] codeData = ByteBuffer.allocate(16 + mailBytes.length).putLong(date).putLong(uid).put(mailBytes).array();
        byte[] hmac = HMacUtil.computeHMac(codeData, secret);
        ByteBuffer checkCode = ByteBuffer.allocate(16 + hmac.length).putLong(date).putLong(uid).put(hmac);
        return checkCode.array();
    }

    @Override
    public boolean activateNewMail(String code) {
        if (code.length() != 48) {
            return false;
        }
        byte[] decoded = Base64Util.decode(code);
        ByteBuffer bufferedCode = ByteBuffer.wrap(decoded);
        LocalDateTime requestDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(bufferedCode.getLong()), ZoneId.systemDefault());
        LocalDateTime now = LocalDateTime.now(this._clock);
        if (now.isAfter(requestDate.plus(CHANGE_EMAIL_REQUEST_LIFETIME))) {
            return false;
        }
        PersonId uid = new PersonId(bufferedCode.getLong());
        DBPerson person = this.getPersonById(uid);
        if (person == null) {
            return false;
        }
        String newMail = person.getNewmail();
        if (StringUtils.isBlank((String)newMail)) {
            return false;
        }
        byte[] calculated = this.codeForActivateNewMail(Instant.from(requestDate.atZone(ZoneId.systemDefault())).toEpochMilli(), uid.getId(), newMail);
        if (Arrays.equals(calculated, decoded)) {
            try {
                this.setNewEmail(person, person.getNewmail());
                return true;
            }
            catch (ValidatableException e) {
                LOG.error("Could not set new mail:", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void setNewEmail(PersonId person, String newmail) throws ValidatableException {
        this.setNewEmail(this.getPersonByIdNotNull(person), newmail);
    }

    private void setNewEmail(final @Nonnull DBPerson person, @Nonnull String newmail) throws ValidatableException {
        person.setEmail(newmail);
        person.setNewmail(null);
        this.savePerson(person.getId(), new PersonUpdateCommand(){

            @Override
            public DBPerson execute(DBPerson object) {
                return person;
            }
        }, PersonService.FeedMessageControl.GENERATE_FEED_MESSAGE);
    }

    @Override
    public DBPerson getPersonByHash(String hash) {
        PersonId pid = this._personDAO.getPersonIdByHash(hash);
        if (pid == null) {
            return null;
        }
        return this.getPersonById(pid);
    }

    @Override
    public DBPerson getPersonByEmail(String email) {
        PersonId personId = this._personReadWriteDataService.getPersonIdByEmail(email);
        return personId != null ? this.getPersonById(personId) : null;
    }

    @Override
    public DBPerson getPersonByEmailOrNewmail(String email) {
        PersonId personId = this._personDAO.getPersonIdByEmailOrNewmail(email);
        return personId != null ? this.getPersonById(personId) : null;
    }

    @Override
    public ImmutableMap<String, PersonId> isEmailRegistered(Set<String> emails) {
        return this._personDAO.getPersonIdsByEmails(emails);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonAuthenticated(@Nonnull PersonAuthenticatedEvent ev) {
        this.updateLastLoginDate(ev.getPersonId(), this.getNowAsUtilDate());
    }

    @Override
    public void updateLastLoginDate(PersonId userId, Date date) {
        this._personDAO.updateLastLoginDate(userId, date);
    }

    @Override
    public void updateNameSettings(PersonId userId, NameSettings settings, boolean generateFeedMessage) throws ValidatableException {
        DBAccountSettings dbSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(userId);
        Map<String, Collection<ValidationError>> validationErrors = this._personValidator.validate(userId, settings, dbSettings);
        if (validationErrors != null && !validationErrors.isEmpty()) {
            throw new ValidatableException(validationErrors);
        }
        boolean visibleFieldsChanged = false;
        if (!StringUtils.equals((String)dbSettings.getFirstName(), (String)settings.getFirstName())) {
            dbSettings.setFirstName(settings.getFirstName());
            visibleFieldsChanged = true;
        }
        if (!StringUtils.equals((String)dbSettings.getLastName(), (String)settings.getLastName())) {
            dbSettings.setLastName(settings.getLastName());
            visibleFieldsChanged = true;
        }
        if (!StringUtils.equals((String)dbSettings.getTitle(), (String)settings.getTitle())) {
            dbSettings.setTitle(settings.getTitle());
            visibleFieldsChanged = true;
        }
        if (!StringUtils.equals((String)dbSettings.getAdditionalTitle(), (String)settings.getAdditionalTitle())) {
            dbSettings.setAdditionalTitle(settings.getAdditionalTitle());
            visibleFieldsChanged = true;
        }
        DBPerson oldPerson = this.getPersonById(userId);
        this._personDAO.updateAccountSettings(dbSettings);
        this.handlePersonUpdate(userId);
        DBPerson updatedPerson = this.getPersonByIdNotNull(userId);
        this.feedProfileChanged(oldPerson, updatedPerson);
        if (visibleFieldsChanged) {
            this._eventBus.post(new PersonNameChangedEvent(userId));
        }
    }

    @Override
    public void updateEmailOrPasswordInAccountSettings(DBAccountSettings settings) throws ValidatableException {
        PersonId personId = settings.getPersonId();
        DBAccountSettings dbSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(personId);
        ImmutableListMultimap<String, ValidationError> validationErrors = this._personValidator.validate(settings, dbSettings);
        if (!validationErrors.isEmpty()) {
            throw new ValidatableException(validationErrors);
        }
        if (settings.getNewPassword() != null) {
            dbSettings.setNewPassword(this._passwordEncoder.encode(settings.getNewPassword()));
        }
        DBPerson oldPerson = this.getPersonById(personId);
        String newmail = settings.getNewmail();
        dbSettings.setNewmail(newmail);
        if (oldPerson != null && StringUtils.equals((String)oldPerson.getEmail(), (String)newmail)) {
            dbSettings.setNewmail(null);
        }
        this._personDAO.updateAccountSettings(dbSettings);
        this.handlePersonUpdate(personId);
        DBPerson updatedPerson = this.getPersonByIdNotNull(personId);
        this.feedProfileChanged(oldPerson, updatedPerson);
    }

    @Override
    public String signedNewMailActivationCode(PersonId uid, String newMail, LocalDateTime date) {
        long uidLong = uid.getId();
        long dateMillis = Instant.from(date.atZone(ZoneId.systemDefault())).toEpochMilli();
        return Base64Util.encode(this.codeForActivateNewMail(dateMillis, uidLong, newMail));
    }

    @Override
    public PersonId savePerson(@Nullable PersonId personId, PersonCommand command, PersonService.FeedMessageControl feedMsgCtrl) throws ValidatableException {
        return this.savePerson(personId, command, feedMsgCtrl, new ImmediatelyFiringServerEventCollector(this._eventBus));
    }

    @Override
    public PersonId savePerson(PersonId personId, PersonCommand command, PersonService.FeedMessageControl feedMsgCtrl, ServerEventCollector eventCollector) throws ValidatableException {
        DBPerson personFromDB = personId != null ? this.getPersonById(personId) : null;
        boolean wasActive = personFromDB != null && personFromDB.isActive();
        final DBPerson personToSave = command.execute(personFromDB);
        this.validatePerson(personToSave, personFromDB);
        DBPerson oldPerson = personId != null ? this.getPersonById(personId) : null;
        final class PersonCommandVisitorImpl
        implements PersonCommandVisitor {
            private PersonId _result;

            PersonCommandVisitorImpl() {
            }

            @Override
            public void visit(PersonUpdateCommand update) {
                this._result = PersonServiceImpl.this._personReadWriteDataService.updatePerson(personToSave, PersonServiceImpl.this.getNowAsJodaTime());
            }

            @Override
            public void visit(PersonInsertCommand insert) {
                PersonServiceImpl.this._transactionHelper.doInTransactionWithoutResult(status -> {
                    this._result = PersonServiceImpl.this._personReadWriteDataService.insertPerson(personToSave, PersonServiceImpl.this.getNowAsJodaTime());
                    PersonServiceImpl.this._personReadWriteDataService.savePersonRoles(this._result, (Set<PersonRole>)PersonServiceImpl.this._profileConfig.getDefaultPersonRoles(), true);
                });
            }
        }
        PersonCommandVisitorImpl visitor = new PersonCommandVisitorImpl();
        command.accept(visitor);
        PersonId personToSaveId = visitor._result;
        boolean isActive = personToSave.isActive();
        if (wasActive != isActive) {
            if (isActive) {
                this.notifyPersonActivated(personToSaveId, eventCollector);
            } else {
                this.notifyPersonDeactivated(personToSaveId, eventCollector);
            }
        }
        this.feedProfileChanged(oldPerson, personToSave);
        return personToSaveId;
    }

    @Override
    public List<PersonId> getAllPersonIds(boolean onlyActive, int offset, int limit) {
        return this._personDAO.getAllPersonIds(onlyActive, offset, limit);
    }

    @Override
    public ImmutableSet<PersonId> filterPublicProfiles(Iterable<PersonId> personIds, AuthorizationCheckContext authCtx) {
        ImmutableSet<ProfileId> filtered = authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)Streams.stream(personIds).map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        return (ImmutableSet)filtered.stream().map(ProfileId.TO_PERSON_ID).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Map<PersonId, EmailNotificationSettingsBean> getEmailNotificationSettingsByPersonIds(Set<PersonId> personIds) {
        HashMap<PersonId, Boolean> chatNotificationSettings = this._settings.isChatOpticonEnabled() ? this._chatServiceInternalApiConnector.getChatEmailNotificationSettings(personIds) : new HashMap();
        return this.getEmailNotificationSettingsByPersonIds(personIds, chatNotificationSettings);
    }

    private Map<PersonId, EmailNotificationSettingsBean> getEmailNotificationSettingsByPersonIds(Set<PersonId> personIds, Map<PersonId, Boolean> chatNotificationSettings) {
        Map<PersonId, DBEmailNotificationSettings> settings = this._personReadWriteDataService.getEmailNotificationSettingsByPersonIds(personIds);
        ImmutableSetMultimap<PersonId, PersonRole> roles = this._personRoleService.getPersonRoles(personIds);
        HashMap<PersonId, EmailNotificationSettingsBean> resultMap = new HashMap<PersonId, EmailNotificationSettingsBean>();
        for (PersonId pid : personIds) {
            DBEmailNotificationSettings settingsFromCache = settings.get(pid);
            Boolean chatNotificationEnabled = this._settings.isChatOpticonEnabled() ? chatNotificationSettings.get(pid) : Boolean.FALSE;
            DBEmailNotificationSettings defaultEmailNotificationSettings = this.createDefaultEmailNotificationSettings(pid, (Set<PersonRole>)roles.get((Object)pid));
            EmailNotificationSettingsBean result = new EmailNotificationSettingsBean(settingsFromCache == null ? defaultEmailNotificationSettings : settingsFromCache, chatNotificationEnabled == null ? defaultEmailNotificationSettings.isEmailNotificationsActivated() : chatNotificationEnabled.booleanValue());
            ImmutableSet personRoles = roles.get((Object)pid);
            result.setEmailNotificationsVisible(this._profileConfig.emailNotificationConcernMeVisible((Set<PersonRole>)personRoles));
            resultMap.put(pid, result);
        }
        return resultMap;
    }

    @Nonnull
    private DBEmailNotificationSettings createDefaultEmailNotificationSettings(@Nonnull PersonId personId, @Nonnull Set<PersonRole> roles) {
        return new DBEmailNotificationSettings(personId, this._profileConfig.emailNotificationConcernMeDefault(roles));
    }

    private boolean isLegalEmailNotificationModification(@Nonnull DBEmailNotificationSettings newSettings, @Nonnull EmailNotificationSettingsBean oldSettings, @Nonnull Set<PersonRole> roles) {
        return newSettings.isEmailNotificationsActivated() == oldSettings.isEmailNotificationConcernMe() || this._profileConfig.emailNotificationConcernMeVisible(roles);
    }

    @Override
    public void saveEmailNotificationSettings(DBEmailNotificationSettings settings, boolean isChatEmailNotificationEnabled, AuthorizationCheckContext authContext) {
        PersonId personId = settings.getPersonId();
        authContext.check((ItemId)personId.asProfileId(), (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        EmailNotificationSettingsBean oldSettings = this.getEmailNotificationSettingsByPersonIds((Set<PersonId>)ImmutableSet.of((Object)personId)).get(personId);
        if (!this.isLegalEmailNotificationModification(settings, oldSettings, (Set<PersonRole>)this._personRoleService.getPersonRoles(personId))) {
            throw new PermissionDeniedException("modification of a hidden setting is not allowed");
        }
        if (this._settings.isChatOpticonEnabled() && oldSettings.isChatEmailNotificationEnabled() != isChatEmailNotificationEnabled) {
            if (isChatEmailNotificationEnabled) {
                this._chatServiceInternalApiConnector.enableChatEmailNotifications(personId);
            } else {
                this._chatServiceInternalApiConnector.disableChatEmailNotifications(personId);
            }
        }
        this._personReadWriteDataService.saveEmailNotificationSettings(settings);
    }

    @Override
    public ProfileItem getProfileItemByPersonId(PersonId personId) {
        if (personId == null) {
            return null;
        }
        return (ProfileItem)this.getProfileItemsByPersonIds((Set<PersonId>)ImmutableSet.of((Object)personId)).get((Object)personId);
    }

    @Override
    public ImmutableMap<PersonId, ProfileItem> getProfileItemsByPersonIds(Set<PersonId> personIds) {
        if (CollectionUtil.isEmpty(personIds)) {
            return ImmutableMap.of();
        }
        return this.getProfileItemsForPersons((Map<PersonId, DBPerson>)this.getPersonsByIds(personIds));
    }

    @Override
    public ImmutableMap<PersonId, ProfileItem> getProfileItemsForPersons(Map<PersonId, DBPerson> persons) {
        if (CollectionUtil.isEmpty(persons)) {
            return ImmutableMap.of();
        }
        ConfFile configFile = this._configFileService.getConfigFile();
        ImmutableSetMultimap<PersonId, PersonRole> roles = this._personRoleService.getPersonRoles(persons.keySet());
        return (ImmutableMap)persons.values().stream().collect(ImmutableMap.toImmutableMap(DBPerson::getId, person -> {
            PersonId key = person.getId();
            return new ProfileItem((DBPerson)person, (ImmutableSet<PersonRole>)roles.get((Object)key));
        }));
    }

    @Override
    public StartpageItem getStartpageItemByPersonId(PersonId personId) {
        if (personId == null) {
            return null;
        }
        DBPerson person = this.getPersonById(personId);
        return person == null ? null : new StartpageItem(person);
    }

    @Override
    public void updateImage(PersonId loginUserId, String filename) {
        DBPerson person = this.getPersonById(loginUserId);
        this._personDAO.updateImage(loginUserId, filename);
        this.handlePersonUpdate(loginUserId);
        if (person != null) {
            DBPerson newPerson = new DBPerson(person);
            newPerson.setImage(filename);
            this.feedProfileChanged(person, newPerson);
        }
    }

    @Override
    public boolean isEmailNotificationEnabled(PersonId userId) {
        Map<PersonId, EmailNotificationSettingsBean> settings = this.getEmailNotificationSettingsByPersonIds(Sets.newHashSet((Object[])new PersonId[]{userId}));
        EmailNotificationSettingsBean emailNotificationSettings = settings.get(userId);
        return emailNotificationSettings != null && emailNotificationSettings.isEmailNotificationConcernMe();
    }

    @Override
    public ImmutableSet<PersonId> getEmailNotificationEnabledPersons(Set<PersonId> userIds) {
        final Map<PersonId, EmailNotificationSettingsBean> settings = this.getEmailNotificationSettingsByPersonIds(userIds);
        return (ImmutableSet)userIds.stream().filter(new NullIsFalsePredicate<PersonId>(){

            @Override
            protected boolean applySafe(PersonId input) {
                EmailNotificationSettingsBean emailNotificationSettings = (EmailNotificationSettingsBean)settings.get(input);
                return emailNotificationSettings != null && emailNotificationSettings.isEmailNotificationConcernMe();
            }
        }).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableList<PersonId> getUpcommingBirthDays(int interval, DateTime currentTime) {
        return this._personReadWriteDataService.getUpcommingBirthDays(interval, currentTime);
    }

    @Override
    public TimeZone getTimeZoneOfUserOrDefault(PersonId personId) {
        TimeZone timeZone;
        DBPerson person;
        if (personId != null && (person = this.getPersonById(personId)) != null && (timeZone = person.getTimeZone()) != null) {
            return timeZone;
        }
        return this._settings.getDefaultTimeZone();
    }

    @Override
    public DBAccountSettings getAccountSettingsByPersonId(PersonId personId) {
        return this._personReadWriteDataService.getAccountSettingsByPersonId(personId);
    }

    @Override
    public void setPersonBlocked(PersonId personId, boolean block, AuthorizationCheckContext authContext) {
        authContext.check((ItemId)personId.asProfileId(), (Action)StaticAction.PERSON_BLOCK);
        this._personReadWriteDataService.updatePersonBlocked(personId, block);
        this.notifyPersonBlocked(personId, block, new ImmediatelyFiringServerEventCollector(this._eventBus));
    }

    @Override
    public String getAnnotatedName(DBPerson person) {
        return this.getAnnotatedNameWithLocale(person, person.getLanguageId());
    }

    @Override
    public String getAnnotatedNameWithLocale(DBPerson person, String locale) {
        if (person != null) {
            ProfileConstants profileConstants = this._i18nService.createProxy(ProfileConstants.class, locale);
            Object prefix = person.isBlocked() && !person.isActive() ? profileConstants.deactivatedBlockedPerson() + " " : (person.isBlocked() ? profileConstants.blockedPerson() + " " : (!person.isActive() ? profileConstants.deactivatedPerson() + " " : ""));
            return (String)prefix + person.getFullName();
        }
        return "";
    }

    private void updatePersonModifyDateByChildId(@Nonnull ItemId childId) {
        try {
            Item<?> rootItem = this._itemService.getRootItem(childId);
            if (rootItem instanceof ProfileItem) {
                ProfileId profileId = ((ProfileItem)rootItem).getId();
                this._personReadWriteDataService.updatePersonModifyDate(profileId.asPersonId(), this.getNowAsUtilDate());
                this._eventBus.post(new PersonModifyDateChangedEvent(profileId.asPersonId()));
            }
        }
        catch (InvalidIDException ex) {
            LOG.error("Got unexpected InvalidIdException during updating person modify date. We will skip updating modify date.", (Throwable)ex);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onCommentCreated(@Nonnull CommentCreatedEvent e) {
        this.updatePersonModifyDateByChildId(e.getComment().getParentId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onImageCreated(@Nonnull ImageCreatedEvent e) {
        DBAlbum album = e.getAlbum();
        if (album.isModule() && ItemType.PROFILE.equals(album.getParentId().getType())) {
            this.updatePersonModifyDateByChildId(new ProfileId(album.getParentId().getId()));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onVideolinkCreated(@Nonnull VideolinkCreatedEvent e) {
        this.updatePersonModifyDateByChildId(e.getVideolink().getParentId());
    }

    @Override
    public AccountActivationResult activateAccount(String activationCode) {
        PersonId personId = this._verificationCodeService.verifyUserActivationCode(activationCode);
        if (personId == null) {
            return AccountActivationResult.ERROR;
        }
        DBPerson person = this.getPersonById(personId);
        if (person == null || person.isDeleted()) {
            return AccountActivationResult.ERROR;
        }
        if (person.isActive()) {
            return AccountActivationResult.ERROR;
        }
        return this.activateAccountById(personId);
    }

    @Override
    public void acceptTerms(PersonId userId, String loginCode) {
        PersonId personId = this._verificationCodeService.verifyTemporaryLoginCode(loginCode);
        if (!com.google.common.base.Objects.equal((Object)userId, (Object)personId)) {
            throw new ServiceException("persons do not match");
        }
        DBPerson person = this.getPersonByIdNotNull(personId);
        if (Boolean.TRUE.equals(person.getTermsAccepted())) {
            LOG.info("person {} has already accepted terms", (Object)personId);
            return;
        }
        person.setTermsAccepted(Boolean.TRUE);
        this._personReadWriteDataService.updatePerson(person, null);
    }

    @Override
    public String generateLoginCode(PersonId userId) {
        return this._verificationCodeService.generateTemporaryLoginCodeForId(userId);
    }

    @Override
    public int getActiveUserCount() {
        return this._personReadWriteDataService.getActiveUserCount();
    }

    @Override
    public int getTotalUserCount() {
        return this._personReadWriteDataService.getTotalUserCount();
    }
}

