/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.StaticRoles;
import de.justsoftware.onx.common.business.configfile.ConfFile;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.events.PersonRolesChangedEvent;
import de.justsoftware.onx.events.ProfileVisibilitiesChangedEvent;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonRoleServiceImpl
implements PersonRoleService {
    private final ConfigFileService _configFileService;
    private final JCEventBus _eventBus;
    private final PersonReadWriteDataService _personReadWriteDataService;

    @Autowired
    @ParametersAreNonnullByDefault
    public PersonRoleServiceImpl(ConfigFileService configFileService, JCEventBus eventBus, PersonReadWriteDataService personReadWriteDataService) {
        this._configFileService = configFileService;
        this._eventBus = eventBus;
        this._personReadWriteDataService = personReadWriteDataService;
    }

    public ImmutableMap<String, Role> getAllPersonAndStaticRoles() {
        return ImmutableMap.builder().putAll(StaticRoles.NAME_MAP).putAll((Map)Maps.uniqueIndex(this._configFileService.getConfigFile().getAllPersonRoles(), Role.TO_NAME)).build();
    }

    @Override
    public ImmutableList<String> getVisibleRoleNames() {
        return AuthorityUtil.names(this.getAllNonHiddenPersonRoles()).asList();
    }

    @Override
    public Set<PersonRole> getAllNonHiddenPersonRoles() {
        ConfFile configFile = this._configFileService.getConfigFile();
        return Sets.difference(configFile.getAllPersonRoles(), configFile.getHiddenPersonRoles());
    }

    @Override
    public ImmutableSetMultimap<Boolean, PersonRole> filterVisibleRoles(Iterable<PersonRole> roles, AuthorizationCheckContext authCtx) {
        Predicate<PersonRole> p;
        if (authCtx.may(StaticAction.SEE_HIDDEN_ROLES)) {
            p = r -> true;
        } else {
            ImmutableSet<PersonRole> hiddenRoles = this._configFileService.getConfigFile().getHiddenPersonRoles();
            Predicate<PersonRole> in = arg_0 -> hiddenRoles.contains(arg_0);
            p = in.negate();
        }
        return (ImmutableSetMultimap)Streams.stream(roles).collect(ImmutableSetMultimap.toImmutableSetMultimap(p::test, Function.identity()));
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<PersonId> personIds) {
        return this._personReadWriteDataService.getPersonRoles(personIds);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonRole> getVisibleRolesFor(Set<PersonId> personIds, AuthorizationCheckContext authorizationContext) {
        ImmutableSetMultimap<PersonId, PersonRole> unfilteredResult = this.getPersonRoles(personIds);
        ImmutableSet seeHiddenRoles = authorizationContext.filterAllowedIds(Iterables.transform((Iterable)unfilteredResult.keySet(), PersonId.AS_PROFILE_ID), StaticAction.SEE_HIDDEN_ROLES);
        ImmutableSet<PersonRole> hiddenRoles = this._configFileService.getConfigFile().getHiddenPersonRoles();
        return (ImmutableSetMultimap)EntryStream.from(unfilteredResult).filter((personId, role) -> seeHiddenRoles.contains((Object)personId.asProfileId()) || !hiddenRoles.contains(role)).collect(EntryCollectors.toImmutableSetMultimap());
    }

    @Override
    public void addPersonRoles(PersonId personToChange, Set<PersonRole> newRoles, AuthorizationCheckContext authCtx) {
        ImmutableSet<PersonRole> oldRoles = this.getPersonRoles(personToChange);
        this.savePersonRoles(personToChange, (Set<PersonRole>)Sets.union(newRoles, oldRoles), authCtx);
    }

    @Override
    public void savePersonRoles(PersonId personIdToChange, Set<PersonRole> newRoles, AuthorizationCheckContext authCtx) {
        ImmutableSetMultimap<Boolean, PersonRole> oldRoles = this.filterVisibleRoles((Iterable<PersonRole>)this.getPersonRoles(personIdToChange), authCtx);
        Sets.SetView changedRoles = Sets.symmetricDifference((Set)oldRoles.get((Object)Boolean.TRUE), newRoles);
        ImmutableSet modifyActions = FluentIterable.from((Iterable)changedRoles).transform(PersonRole::getName).transform(DynamicActionCreator.PROFILE_MODIFY_ROLES.createFunction()).toSet();
        authCtx.check((ItemId)ProfileId.valueOf(personIdToChange), (ImmutableSet<? extends Action>)modifyActions);
        Sets.SetView allNewRoles = Sets.union(newRoles, (Set)oldRoles.get((Object)Boolean.FALSE));
        this.savePersonRoles(personIdToChange, (Set<PersonRole>)allNewRoles, true, new ImmediatelyFiringServerEventCollector(this._eventBus));
    }

    @Override
    public void savePersonRoles(PersonId personToChangeRolesFor, Set<PersonRole> roleNames, boolean override, ServerEventCollector serverEventCollector) {
        ImmutableSet newRoles;
        ImmutableSet currentRoles = ImmutableSet.copyOf(this.getPersonRoles(personToChangeRolesFor));
        FluentIterable newRolesBuilder = FluentIterable.from(roleNames);
        ImmutableSet immutableSet = newRoles = override ? newRolesBuilder.toSet() : newRolesBuilder.append((Iterable)currentRoles).toSet();
        if (!currentRoles.equals((Object)newRoles)) {
            this._personReadWriteDataService.savePersonRoles(personToChangeRolesFor, roleNames, override);
            serverEventCollector.add(new ProfileVisibilitiesChangedEvent(personToChangeRolesFor.asProfileId()));
            serverEventCollector.add(new PersonRolesChangedEvent(personToChangeRolesFor, (Set<PersonRole>)currentRoles, (Set<PersonRole>)newRoles));
        }
    }
}

