/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.UniDirectionalCacheAccessor;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.EntityMemberWriteDataService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.business.impl.PersonServiceEhCacheName;
import de.justsoftware.onx.person.integration.persistence.PersonDAO;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.DBProfileComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonReadWriteDataServiceImpl
implements PersonReadWriteDataService {
    private static final Logger LOG = LoggerFactory.getLogger(PersonReadWriteDataServiceImpl.class);
    private static final ImmutableSet<PersonServiceCacheName> PERSON_ID_CACHES = ImmutableSet.of((Object)PersonServiceCacheName.IS_SUPER_ADMIN, (Object)PersonServiceCacheName.EMPLOYMENT, (Object)PersonServiceCacheName.ACCOUNT_SETTINGS);
    private static final CacheKey ACTIVE_PERSONS_CACHE_KEY = new CacheKey((CacheName)PersonServiceCacheName.GENERIC, "ACTIVE_PERSONS");
    private final EhcacheClient _ehcacheClient;
    private final MemcachedClientCache _cache;
    private final PersonByIdCacheAccessor _personByIdCache;
    private final PersonDAO _personDAO;
    private final UpcommingBirthdaysCacheAccessor _upcommingBirthdaysCacheAccessor;
    private final CacheHelper _cacheHelper;
    private final ProfileComponentsByIdCacheAccessor _profileComponentsByIdCache;
    private final EntityMemberWriteDataService _entityMemberWriteDataService;
    private final UniDirectionalCacheAccessor<PersonServiceEhCacheName, PersonId, PersonRole> _personRoleCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public PersonReadWriteDataServiceImpl(EhcacheClient ehCacheClient, MemcachedClientCache cache, PersonDAO personDAO, CacheHelper cacheHelper, EntityMemberWriteDataService entityMemberWriteDataService) {
        this._personDAO = personDAO;
        this._ehcacheClient = ehCacheClient;
        this._cache = cache;
        this._entityMemberWriteDataService = entityMemberWriteDataService;
        this._personByIdCache = new PersonByIdCacheAccessor(ehCacheClient, personDAO);
        this._upcommingBirthdaysCacheAccessor = new UpcommingBirthdaysCacheAccessor(ehCacheClient, personDAO);
        this._cacheHelper = cacheHelper;
        this._profileComponentsByIdCache = new ProfileComponentsByIdCacheAccessor(ehCacheClient, personDAO);
        this._personRoleCacheAccessor = PersonReadWriteDataServiceImpl.createPersonRoleCacheAccessor(ehCacheClient, personDAO);
    }

    @Nonnull
    private static UniDirectionalCacheAccessor<PersonServiceEhCacheName, PersonId, PersonRole> createPersonRoleCacheAccessor(EhcacheClient ehCacheClient, PersonDAO personDAO) {
        return new UniDirectionalCacheAccessor<PersonServiceEhCacheName, PersonId, PersonRole>(ehCacheClient, PersonServiceEhCacheName.PERSON_ROLES, personDAO::getPersonRoles, LongId::toString);
    }

    @Override
    public PersonId updatePerson(DBPerson dbPerson, DateTime updatedModifyDate) {
        this._personDAO.updatePerson(dbPerson, updatedModifyDate);
        this._upcommingBirthdaysCacheAccessor.invalidateAll();
        PersonId id = dbPerson.getId();
        this.getResult(this.deleteFromCache(id));
        return id;
    }

    @Override
    public PersonId insertPerson(DBPerson dbPerson, DateTime createDate) {
        PersonId personId = this._personDAO.insertPerson(dbPerson, createDate);
        dbPerson.setId(personId);
        this._upcommingBirthdaysCacheAccessor.invalidateAll();
        this.getResult(this.deleteFromCache(personId));
        return personId;
    }

    @Override
    public int getActiveUserCount() {
        return Numbers.intValue(this._cacheHelper.getFromCache(ACTIVE_PERSONS_CACHE_KEY, () -> this._personDAO.getActiveUserCount()));
    }

    @Override
    public int getTotalUserCount() {
        return this._personDAO.getTotalUserCount();
    }

    @Override
    public DBPerson getPersonById(PersonId personId) {
        return (DBPerson)this._personByIdCache.getSingle(personId);
    }

    @Override
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<PersonId> personIds) {
        return this._personByIdCache.getMap(personIds);
    }

    @Override
    public List<PersonId> getPersonIdsByRole(List<String> roleName) {
        return this._personDAO.getPersonIdsByRole(roleName);
    }

    @Override
    public void updatePersonActivated(PersonId personId, boolean activated) {
        this._personDAO.updatePersonActivated(personId, activated);
        this.getResult(this.deleteFromCache(personId));
    }

    @Override
    public void updatePersonBlocked(PersonId personId, boolean blocked) {
        this._personDAO.updatePersonBlocked(personId, blocked);
        this.getResult(this.deleteFromCache(personId));
    }

    @Override
    public void saveEmailNotificationSettings(DBEmailNotificationSettings settings) {
        this._personDAO.saveEmailNotificationSettings(settings);
        this._cacheHelper.delete(new CacheKey((CacheName)PersonServiceCacheName.EMAIL_NOTIFICATION_SETTINGS, settings.getPersonId()));
    }

    @Override
    public ImmutableList<PersonId> getUpcommingBirthDays(int interval, DateTime currentTime) {
        ImmutableList result = this._upcommingBirthdaysCacheAccessor.getFromDatabaseSingle(new IntervalAndTime(interval, currentTime));
        return result != null ? result : ImmutableList.of();
    }

    @Override
    public Collection<Future<Boolean>> deleteFromCache(PersonId id) {
        if (id == null) {
            return Collections.emptyList();
        }
        this._entityMemberWriteDataService.invalidateCache((Set<PersonId>)ImmutableSet.of((Object)id), (Set<EntityId>)ImmutableSet.of());
        ArrayList futures = Lists.newArrayListWithCapacity((int)(PersonServiceCacheName.values().length + 3));
        for (PersonServiceCacheName cacheKey : PERSON_ID_CACHES) {
            futures.add(this._cacheHelper.asyncDelete(new CacheKey((CacheName)cacheKey, id)));
        }
        futures.add(this._personByIdCache.invalidateKey(id));
        futures.add(this._cacheHelper.asyncDelete(ACTIVE_PERSONS_CACHE_KEY));
        return futures;
    }

    @Nonnull
    private ImmutableList<Boolean> getResult(Collection<Future<Boolean>> futures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Future<Boolean> future : futures) {
            try {
                builder.add((Object)future.get());
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while waiting for cache key to be deleted", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.info("Exception while waiting for cache key to be deleted", (Throwable)e);
            }
        }
        return builder.build();
    }

    @Override
    public ImmutableListMultimap<PersonId, DBProfileComponent> getProfileComponentsByIds(Set<PersonId> personIds) {
        return (ImmutableListMultimap)this._profileComponentsByIdCache.getMultiMap(personIds);
    }

    @Override
    public void saveProfileComponent(DBProfileComponent dbProfileComponent) {
        this._personDAO.saveProfileComponent(dbProfileComponent);
        this._profileComponentsByIdCache.invalidateKeyAndWait(dbProfileComponent.getPersonId());
        this.deleteFromCache(dbProfileComponent.getPersonId());
    }

    @Override
    public void deletePerson(PersonId personId) {
        this._personDAO.deletePerson(personId);
        this._cache.flush();
        this._ehcacheClient.flush();
    }

    @Override
    public void savePersonRoles(PersonId personToChangeRolesFor, Set<PersonRole> roles, boolean override) {
        if (override) {
            this._personDAO.setPersonRoles(personToChangeRolesFor, roles);
        } else {
            this._personDAO.addPersonRoles(personToChangeRolesFor, roles);
        }
        this._personRoleCacheAccessor.invalidateKey(personToChangeRolesFor);
    }

    @Override
    public Map<PersonId, DBEmailNotificationSettings> getEmailNotificationSettingsByPersonIds(Set<PersonId> personIds) {
        return this._cacheHelper.getByIdsMap(personIds, new CacheHelper.GetByIdsInterface<PersonId, DBEmailNotificationSettings>(){

            @Override
            public CacheKey cacheKey(PersonId pid) {
                return new CacheKey((CacheName)PersonServiceCacheName.EMAIL_NOTIFICATION_SETTINGS, pid);
            }

            @Override
            public ImmutableMap<PersonId, DBEmailNotificationSettings> ibatisGetByIds(Set<PersonId> pids) {
                return PersonReadWriteDataServiceImpl.this._personDAO.getEmailNotificationSettingsByPersonIds(pids);
            }
        });
    }

    @Override
    public DBAccountSettings getAccountSettingsByPersonId(PersonId personId) {
        return this._cacheHelper.getFromCache(PersonReadWriteDataServiceImpl.createAccountSettingsCacheKey(personId), () -> this._personDAO.getAccountSettingsByPersonId(personId));
    }

    @Nonnull
    private static CacheKey createAccountSettingsCacheKey(PersonId personId) {
        return new CacheKey((CacheName)PersonServiceCacheName.ACCOUNT_SETTINGS, personId);
    }

    @Override
    public void invalidateUpcommingBirthdays() {
        this._upcommingBirthdaysCacheAccessor.invalidateAll();
    }

    @Override
    public PersonId getPersonIdByEmail(String email) {
        return (PersonId)this._personDAO.getPersonIdsByEmails((Set<String>)ImmutableSet.of((Object)email)).get((Object)email);
    }

    @Override
    public void updatePersonModifyDate(PersonId id, Date modifyDate) {
        this._personDAO.updatePersonModifyDate(id, modifyDate);
        this.getResult(this.deleteFromCache(id));
    }

    @Override
    public boolean getPersonWithMd5Password(BiConsumer<PersonId, String> personWithMd5PasswordConsumer) {
        return this._personDAO.getPersonWithMd5Password(personWithMd5PasswordConsumer);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<PersonId> personIds) {
        return (ImmutableSetMultimap)this._personRoleCacheAccessor.getMultiMap(personIds);
    }

    @Override
    public void updatePassword(PersonId id, String oldHashedPassword, String hashedPassword) {
        this._personDAO.updatePassword(id, oldHashedPassword, hashedPassword);
        this.deleteFromCache(id);
    }

    @Override
    public void updatePassword(PersonId id, String hashedPassword) {
        this._personDAO.updatePassword(id, hashedPassword);
        this.deleteFromCache(id);
    }

    private static class PersonByIdCacheAccessor
    extends AbstractMapLoadingCacheAccessor<PersonServiceEhCacheName, PersonId, DBPerson> {
        private final PersonDAO _personDAO;

        PersonByIdCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull PersonDAO personDAO) {
            super(cache, PersonServiceEhCacheName.PERSON);
            this._personDAO = personDAO;
        }

        @Override
        protected Map<PersonId, DBPerson> getFromDatabaseMulti(Set<? extends PersonId> inputs) {
            return this._personDAO.getPersonsByIds(inputs);
        }

        @Override
        protected String keyToString(PersonId input) {
            return input.toString();
        }

        @Override
        protected DBPerson copyObject(DBPerson o) {
            return new DBPerson(o);
        }
    }

    private static class UpcommingBirthdaysCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<PersonServiceEhCacheName, IntervalAndTime, ImmutableList<PersonId>> {
        private final PersonDAO _personDAO;

        UpcommingBirthdaysCacheAccessor(@Nonnull CacheClient<? super PersonServiceEhCacheName> cache, @Nonnull PersonDAO personDAO) {
            super(cache, PersonServiceEhCacheName.UP_COMMING_BIRTHDAYS);
            this._personDAO = personDAO;
        }

        @Override
        protected ImmutableList<PersonId> getFromDatabaseSingle(IntervalAndTime input) {
            return this._personDAO.getUpcomingBirthdays(input._interval, input._time);
        }

        @Override
        protected String keyToString(IntervalAndTime key) {
            return key.toString();
        }
    }

    static class IntervalAndTime {
        final int _interval;
        final DateTime _time;
        private final String _asString;

        IntervalAndTime(int interval, @Nonnull DateTime time) {
            this._interval = interval;
            this._time = time;
            this._asString = DateTimeFormat.forPattern((String)"YYYY-MM-dd").print((ReadableInstant)this._time) + "+" + this._interval;
        }

        public final String toString() {
            return this._asString;
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof IntervalAndTime && Objects.equal((Object)this._asString, (Object)((IntervalAndTime)obj)._asString);
        }

        public final int hashCode() {
            return this._asString.hashCode();
        }
    }

    private static class ProfileComponentsByIdCacheAccessor
    extends AbstractListMultiMapCacheAccessor<PersonServiceEhCacheName, PersonId, DBProfileComponent> {
        private final PersonDAO _personDAO;

        ProfileComponentsByIdCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull PersonDAO personDAO) {
            super(cache, PersonServiceEhCacheName.PROFILE_COMPONENTS);
            this._personDAO = personDAO;
        }

        @Override
        protected PersonId objectToKey(DBProfileComponent dbResult) {
            return dbResult.getPersonId();
        }

        @Override
        protected Iterable<? extends DBProfileComponent> getListFromDatabase(Set<? extends PersonId> inputs) {
            return this._personDAO.getProfileComponents(inputs);
        }

        @Override
        protected String keyToString(PersonId key) {
            return key.toString();
        }

        @Override
        protected Collection<DBProfileComponent> copyCollection(Collection<DBProfileComponent> o) {
            return ProfileComponentsByIdCacheAccessor.fastCopy(o);
        }
    }

    private static enum PersonServiceCacheName implements CacheName
    {
        IS_SUPER_ADMIN("person.isSuperAdmin.id"),
        PERSON_DYNAMIC_ATTRIBUTE("person.dynamicAttributes.id"),
        EMPLOYMENT("person.employments.id"),
        ACCOUNT_SETTINGS("person.accountsettings.id"),
        EMAIL_NOTIFICATION_SETTINGS("EmailNotificationSettings"),
        GENERIC("PersonServiceGeneric"),
        OCCUPATIONS_PREFIX("Occupations"),
        INDUSTRIES_PREFIX("Industries"),
        JOBSTATUS_PREFIX("JobStatus"),
        UNIVERSITY_DEPARTMENT_PREFIX("UniversityDepartment");

        private final String _prefix;

        private PersonServiceCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

