/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonDeletionHandler;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.integration.persistence.PersonTenantDAO;
import de.justsoftware.permission.client.model.Role;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonDeletionHandlerImpl
implements PersonDeletionHandler {
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private PersonTenantDAO _personTenantDAO;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private PersonService _personService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Iterables.filter(parentIds, TenantId.class).forEach(tenantId -> {
            ImmutableSet<PersonId> personIdsForTenant = this._personTenantDAO.getPersonIdsForTenant((TenantId)tenantId);
            this._personTenantService.deletePersonTenantsForTenant((TenantId)tenantId, deletionContext);
            ImmutableSetMultimap<PersonId, PersonRole> personRoles = this._personRoleService.getPersonRoles((Set<PersonId>)personIdsForTenant);
            Set superadmins = Multimaps.filterEntries(personRoles, entry -> ((PersonRole)entry.getValue()).asPermissionRole().equals((Object)Role.SUPERADMIN)).keySet();
            ImmutableSetMultimap<PersonId, TenantId> tenantIdsForPersons = this._personTenantService.getTenantIdsForPersons((Set<PersonId>)personIdsForTenant);
            Set<PersonId> personsToDelete = personIdsForTenant.stream().filter(id -> tenantIdsForPersons.get(id).isEmpty() && !superadmins.contains(id)).collect(Collectors.toSet());
            this._personService.deleteDependentPersons(personsToDelete, deletionContext);
        });
    }
}

