/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.PasswordCheck;
import de.justsoftware.onx.mail.business.PasswordForgottenMailService;
import de.justsoftware.onx.person.business.NewPasswordService;
import de.justsoftware.onx.person.business.PasswordResetCodeGenerator;
import de.justsoftware.onx.person.business.PasswordResetRequestService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonWriteDataService;
import de.justsoftware.onx.person.business.model.CheckResetPasswordKeyResult;
import de.justsoftware.onx.person.business.model.SetNewPasswordResult;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PasswordResetRequest;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.util.server.Base64Util;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NewPasswordServiceImpl
implements NewPasswordService {
    public static final Duration PASSWORD_RESET_CODE_LIFETIME = Duration.ofMinutes(30L);
    private final PersonService _personService;
    private final Settings _settings;
    private final PasswordForgottenMailService _passwordForgottenMailService;
    private final PersonWriteDataService _personWriteDataService;
    private final PasswordResetRequestService _passwordResetRequestService;
    private final Clock _clock;
    private final PasswordResetCodeGenerator _passwordResetCodeGenerator;
    private final JucoPasswordEncoder _passwordEncoder;

    @Autowired
    @ParametersAreNonnullByDefault
    public NewPasswordServiceImpl(PersonService personService, Settings settings, PasswordForgottenMailService passwordForgottenMailService, PersonWriteDataService personWriteDataService, @Qualifier(value="javaTimeClock") Clock clock, PasswordResetCodeGenerator passwordResetCodeGenerator, JucoPasswordEncoder passwordEncoder, PasswordResetRequestService passwordResetRequestService) {
        this._personService = personService;
        this._settings = settings;
        this._passwordForgottenMailService = passwordForgottenMailService;
        this._personWriteDataService = personWriteDataService;
        this._clock = clock;
        this._passwordResetCodeGenerator = passwordResetCodeGenerator;
        this._passwordEncoder = passwordEncoder;
        this._passwordResetRequestService = passwordResetRequestService;
    }

    @Nonnull
    public <R> R check(@Nullable String key, @Nonnull CheckResetPasswordKeyResultTransformer<R> transformer) {
        if (!this._settings.isPasswordResetEnabled()) {
            return transformer.visitPasswordResetDisabled();
        }
        if (StringUtils.isBlank((String)key)) {
            return transformer.visitInvalidKey();
        }
        Optional<VerifiedResetKey> parsedKey = this.parseKeyIfValid(key);
        if (parsedKey.isEmpty()) {
            return transformer.visitInvalidKey();
        }
        VerifiedResetKey verifiedKey = parsedKey.get();
        if (this.passwordResetRequestIsExpired(verifiedKey)) {
            return transformer.visitExpired();
        }
        DBPerson person = this._personService.getPersonById(verifiedKey._personId);
        if (person == null || person.isDeleted()) {
            return transformer.visitPersonDeletedOrInexistent();
        }
        if (person.isBlocked()) {
            return transformer.visitPersonBlocked();
        }
        return transformer.visitSuccess(person);
    }

    private boolean passwordResetRequestIsExpired(VerifiedResetKey verifiedKey) {
        LocalDateTime expirationDate = verifiedKey._requestDate.plus(PASSWORD_RESET_CODE_LIFETIME);
        return LocalDateTime.now(this._clock).isAfter(expirationDate);
    }

    @Nonnull
    private Optional<VerifiedResetKey> parseKeyIfValid(String key) {
        PersonId decodedPersonId;
        if (key.length() != 48) {
            return Optional.empty();
        }
        byte[] decodedResetCode = Base64Util.decode(key);
        ByteBuffer keyBuffer = ByteBuffer.wrap(decodedResetCode);
        LocalDateTime decodedExpiryTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(keyBuffer.getLong()), ZoneId.systemDefault());
        if (!this._passwordResetCodeGenerator.createAuthenticatedResetCode(decodedExpiryTime, decodedPersonId = new PersonId(keyBuffer.getLong())).equals(key)) {
            return Optional.empty();
        }
        if (this._passwordResetRequestService.getValidPendingRequest(decodedPersonId).isPresent()) {
            return Optional.of(new VerifiedResetKey(decodedExpiryTime, decodedPersonId));
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<PersonId> parsePersonIdFromResetPasswordKey(@Nullable String key) {
        return Optional.ofNullable(key).flatMap(this::parseKeyIfValid).map(verifiedKey -> this._personService.getPersonById(verifiedKey._personId)).map(DBPerson::getId);
    }

    @Override
    public void requestNewPassword(String email) {
        if (!this._settings.isPasswordResetEnabled()) {
            return;
        }
        DBPerson person = this._personService.getPersonByEmail(email);
        if (person != null && !person.isDeleted() && !person.isBlocked() && this._passwordResetRequestService.getValidPendingRequest(person.getId()).isEmpty()) {
            LocalDateTime requestExpiry = LocalDateTime.now(this._clock).plus(PASSWORD_RESET_CODE_LIFETIME);
            PasswordResetRequest resetRequest = this._passwordResetCodeGenerator.generatePasswordResetRequest(person.getId(), requestExpiry);
            boolean mailSentSuccessfully = this._passwordForgottenMailService.sendPasswordForgottenEmail(person, resetRequest.getResetPath());
            if (mailSentSuccessfully) {
                this._passwordResetRequestService.registerPasswordResetRequest(resetRequest);
            }
        }
    }

    @Override
    public CheckResetPasswordKeyResult checkResetPasswordKey(String key) {
        return this.check(key, new CheckResetPasswordKeyResultTransformer<CheckResetPasswordKeyResult>(){

            @Override
            public CheckResetPasswordKeyResult visitPasswordResetDisabled() {
                return CheckResetPasswordKeyResult.FORBIDDEN;
            }

            @Override
            public CheckResetPasswordKeyResult visitPersonDeletedOrInexistent() {
                return CheckResetPasswordKeyResult.ACCOUNT_INEXISTENT;
            }

            @Override
            public CheckResetPasswordKeyResult visitPersonBlocked() {
                return CheckResetPasswordKeyResult.ACCOUNT_BLOCKED;
            }

            @Override
            public CheckResetPasswordKeyResult visitSuccess(DBPerson person) {
                return CheckResetPasswordKeyResult.SUCCESS;
            }

            @Override
            public CheckResetPasswordKeyResult visitInvalidKey() {
                return CheckResetPasswordKeyResult.INVALID;
            }

            @Override
            public CheckResetPasswordKeyResult visitExpired() {
                return CheckResetPasswordKeyResult.EXPIRED;
            }
        });
    }

    @Override
    public SetNewPasswordResult setNewPassword(String key, final String newPw) {
        return this.check(key, new CheckResetPasswordKeyResultTransformer<SetNewPasswordResult>(){

            @Override
            public SetNewPasswordResult visitPasswordResetDisabled() {
                return SetNewPasswordResult.FORBIDDEN;
            }

            @Override
            public SetNewPasswordResult visitPersonDeletedOrInexistent() {
                return SetNewPasswordResult.ACCOUNT_INEXISTENT;
            }

            @Override
            public SetNewPasswordResult visitPersonBlocked() {
                return SetNewPasswordResult.ACCOUNT_BLOCKED;
            }

            @Override
            public SetNewPasswordResult visitSuccess(DBPerson person) {
                if (!PasswordCheck.isSecure(newPw)) {
                    return SetNewPasswordResult.INSECURE;
                }
                String hashedPassword = NewPasswordServiceImpl.this._passwordEncoder.encode(newPw);
                NewPasswordServiceImpl.this._personWriteDataService.updatePassword(person.getId(), hashedPassword);
                NewPasswordServiceImpl.this._passwordResetRequestService.deletePendingRequest(person.getId());
                return SetNewPasswordResult.SUCCESS;
            }

            @Override
            public SetNewPasswordResult visitInvalidKey() {
                return SetNewPasswordResult.INVALID;
            }

            @Override
            public SetNewPasswordResult visitExpired() {
                return SetNewPasswordResult.EXPIRED;
            }
        });
    }

    @ParametersAreNonnullByDefault
    private static class VerifiedResetKey {
        private final LocalDateTime _requestDate;
        private final PersonId _personId;

        public VerifiedResetKey(LocalDateTime requestDate, PersonId personId) {
            this._requestDate = requestDate;
            this._personId = personId;
        }
    }

    private static interface CheckResetPasswordKeyResultTransformer<R> {
        @Nonnull
        public R visitPasswordResetDisabled();

        @Nonnull
        public R visitPersonDeletedOrInexistent();

        @Nonnull
        public R visitPersonBlocked();

        @Nonnull
        public R visitSuccess(@Nonnull DBPerson var1);

        @Nonnull
        public R visitInvalidKey();

        @Nonnull
        public R visitExpired();
    }
}

