/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.account.shared.model.settings.Birthday;
import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.chat.business.JabberContactSyncService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.cache.AbstractBiDirectionalCacheAccessor;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.person.business.FriendServiceCacheName;
import de.justsoftware.onx.person.business.FriendsService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.ShowBirthdayOption;
import de.justsoftware.onx.person.business.events.ContactRequestAcceptedEvent;
import de.justsoftware.onx.person.business.events.ContactRequestDeclinedEvent;
import de.justsoftware.onx.person.business.events.NewContactEvent;
import de.justsoftware.onx.person.business.events.NewContactRequestEvent;
import de.justsoftware.onx.person.business.events.RemoveContactEvent;
import de.justsoftware.onx.person.integration.persistence.DBPersonRelation;
import de.justsoftware.onx.person.integration.persistence.FriendsDAO;
import de.justsoftware.onx.person.integration.persistence.PersonRelation;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonBirthdayTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonIdWithMessage;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserWithMessage;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FriendsServiceImpl
implements FriendsService {
    private static final int MAX_BIRTHDAY_BADGES = 30;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    @Qualifier(value="mailManager")
    private MailManager _mailManager;
    @Autowired
    private JabberContactSyncService _jabberContactSyncService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private Clock _clock;
    private final FriendsDAO _friendsDao;
    private final FriendRelationCacheAccessor _friendsRelationCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public FriendsServiceImpl(FriendsDAO friendsDao, EhcacheClient ehcacheClient) {
        this._friendsDao = friendsDao;
        this._friendsRelationCacheAccessor = new FriendRelationCacheAccessor(ehcacheClient, friendsDao);
    }

    @Override
    public ImmutableSet<PersonId> getFriendIdsOfId(PersonId id) {
        return (ImmutableSet)this._friendsRelationCacheAccessor.getSingle(id);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonId> getFriendIdsOfPersons(Set<PersonId> personIds) {
        return (ImmutableSetMultimap)this._friendsRelationCacheAccessor.getMultiMap(personIds);
    }

    @Nonnull
    private ImmutableSet<ProfileId> getFilterdFriendsOfId(PersonId id, AuthorizationCheckContext authCtx) {
        authCtx.check(ProfileReadRole.of(id));
        ImmutableSet friendProfileIds = FluentIterable.from(this.getFriendIdsOfId(id)).transform(PersonId.AS_PROFILE_ID).toSet();
        return authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)friendProfileIds.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
    }

    @Nonnull
    private <T> ListAndCount<T> getPagedFriendsOfId(PersonId id, AuthorizationCheckContext authCtx, Function<ImmutableSet<PersonId>, Map<PersonId, T>> teaserFunction, int offset, int count) {
        ImmutableSet<ProfileId> filtered = this.getFilterdFriendsOfId(id, authCtx);
        ImmutableSet pagedIds = FluentIterable.from(filtered).transform(ProfileId.TO_PERSON_ID).skip(offset).limit(count).toSet();
        Map teasers = (Map)teaserFunction.apply((Object)pagedIds);
        return new ListAndCount(filtered.size(), CollectionUtil.mapToSortedList(teasers, pagedIds));
    }

    @Override
    public ListAndCount<PersonTeaserModel> getFriendTeasersOfId(PersonId id, int offset, int limit, final AuthorizationCheckContextWithLocale authCtx) {
        return this.getPagedFriendsOfId(id, authCtx, new Function<ImmutableSet<PersonId>, Map<PersonId, PersonTeaserModel>>(){

            public Map<PersonId, PersonTeaserModel> apply(ImmutableSet<PersonId> input) {
                if (CollectionUtil.isEmpty(input)) {
                    return ImmutableMap.of();
                }
                return FriendsServiceImpl.this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)input, authCtx);
            }
        }, offset, limit);
    }

    @Override
    public ListAndCount<PersonBadgeModel> getFriendBadgesOfId(PersonId id, int offset, int limit, final AuthorizationCheckContextWithUserId authCtx) {
        return this.getPagedFriendsOfId(id, authCtx, new Function<ImmutableSet<PersonId>, Map<PersonId, PersonBadgeModel>>(){

            public Map<PersonId, PersonBadgeModel> apply(ImmutableSet<PersonId> input) {
                if (CollectionUtil.isEmpty(input)) {
                    return ImmutableMap.of();
                }
                return FriendsServiceImpl.this._profileTeaserService.getPersonBadgesByIds((Set<PersonId>)input, authCtx);
            }
        }, offset, limit);
    }

    @Override
    public int getFriendCount(PersonId personId, AuthorizationCheckContext authCtx) {
        return this.getFilterdFriendsOfId(personId, authCtx).size();
    }

    @Override
    public void endFriendship(PersonId loggedInPersonId, PersonId friendId) {
        this._friendsDao.removeFriend(loggedInPersonId, friendId);
        this._friendsDao.removeFriend(friendId, loggedInPersonId);
        this._friendsRelationCacheAccessor.invalidateKeysAndWait(ImmutableSet.of((Object)loggedInPersonId, (Object)friendId));
        this._eventBus.post(new RemoveContactEvent(loggedInPersonId, friendId));
        this._jabberContactSyncService.contactListChanged(loggedInPersonId);
    }

    @Override
    public ImmutableList<PersonBirthdayTeaserModel> getFriendsBadgesWithUpcomingBirthdays(int interval, ShowBirthdayOption showBirthdayOption, AuthorizationCheckContextWithUserId authorizationContext, DateTime currentTime) {
        ImmutableList<DBPerson> sortedDBPersons = this.getUpcommingBirthdays(interval, showBirthdayOption, authorizationContext, currentTime);
        ImmutableMap<PersonId, ProfileItem> profileItems = this._personService.getProfileItemsForPersons((Map<PersonId, DBPerson>)Maps.uniqueIndex(sortedDBPersons, Identifiables.toId()));
        final ImmutableMap<PersonId, PersonTeaserModel> badges = this._profileTeaserService.getPersonTeaserModelsByDBPersons(profileItems, authorizationContext);
        Iterable sortedBadgesWithNull = Iterables.transform(sortedDBPersons, (Function)new Function<DBPerson, PersonBirthdayTeaserModel>(){

            public PersonBirthdayTeaserModel apply(DBPerson input) {
                if (input == null) {
                    return null;
                }
                PersonTeaserModel teaser = (PersonTeaserModel)badges.get((Object)input.getId());
                if (teaser == null) {
                    return null;
                }
                Birthday birthday = Birthday.create(input.getBirthday(), input.getBirthdayVisibility());
                if (birthday == null) {
                    return null;
                }
                return new PersonBirthdayTeaserModel(teaser, birthday);
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.filter((Iterable)sortedBadgesWithNull, (com.google.common.base.Predicate)Predicates.notNull()), (int)30));
    }

    @Nonnull
    private ImmutableList<DBPerson> getUpcommingBirthdays(int interval, ShowBirthdayOption showBirthdayOption, AuthorizationCheckContextWithUserId authorizationContext, DateTime currentTime) {
        ImmutableList<PersonId> sortedPersons = this._personService.getUpcommingBirthDays(interval, currentTime);
        ImmutableSet<ProfileId> visibleProfileIds = authorizationContext.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)sortedPersons.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        com.google.common.base.Predicate<PersonId> showBirthdayOptionPredicate = this.getShowBirthdayOptionPredicate(showBirthdayOption, authorizationContext.getUserId());
        ImmutableSet sortedResult = (ImmutableSet)sortedPersons.stream().filter(p -> visibleProfileIds.contains((Object)p.asProfileId())).filter((Predicate<PersonId>)showBirthdayOptionPredicate).collect(ImmutableSet.toImmutableSet());
        ImmutableMap<PersonId, DBPerson> profileItemsByPersonIds = this._personService.getPersonsByIds((Set<PersonId>)sortedResult);
        return (ImmutableList)sortedResult.stream().map(arg_0 -> profileItemsByPersonIds.get(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private com.google.common.base.Predicate<PersonId> getShowBirthdayOptionPredicate(ShowBirthdayOption showBirthdayOption, @Nullable PersonId personId) {
        switch (showBirthdayOption) {
            case PLATFORM: {
                return Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)personId));
            }
            case FRIENDS: {
                return Predicates.and((com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.equalTo((Object)personId)), this.isFriendOfPredicate(personId));
            }
            case NONE: {
                return Predicates.alwaysFalse();
            }
        }
        throw new UnsupportedOperationException("no case for " + showBirthdayOption + " defined");
    }

    @Nonnull
    private com.google.common.base.Predicate<PersonId> isFriendOfPredicate(@Nullable PersonId personId) {
        return personId != null ? Predicates.in(this.getFriendIdsOfId(personId)) : Predicates.alwaysFalse();
    }

    @Override
    public ImmutableList<DBPerson> getFriendsWithUpcomingBirthdays(int interval, AuthorizationCheckContextWithUserId authorizationContext) {
        return this.getUpcommingBirthdays(interval, ShowBirthdayOption.FRIENDS, authorizationContext, this._clock.now());
    }

    @Override
    public boolean isFriendOf(PersonId personId, PersonId friendId) {
        if (personId == null || friendId == null) {
            return false;
        }
        return this._friendsRelationCacheAccessor.isInRelation(personId, friendId);
    }

    @Override
    public void acceptInvitation(PersonId inviterId, PersonId inviteeId) {
        this._friendsDao.removeInvitation(inviterId, inviteeId);
        this._friendsDao.removeInvitation(inviteeId, inviterId);
        this._friendsDao.addFriend(inviterId, inviteeId);
        this._friendsDao.addFriend(inviteeId, inviterId);
        this._friendsRelationCacheAccessor.invalidateKeysAndWait(ImmutableSet.of((Object)inviterId, (Object)inviteeId));
        this._eventBus.post(new ContactRequestAcceptedEvent(inviteeId, inviterId));
        this._eventBus.post(new NewContactEvent(inviteeId, inviterId));
        this._jabberContactSyncService.contactListChanged(inviterId);
    }

    @Override
    public void declineInvitation(PersonId personId, PersonId decliningPerson) {
        this._friendsDao.removeInvitation(personId, decliningPerson);
        this._friendsDao.removeInvitation(decliningPerson, personId);
        this._eventBus.post(new ContactRequestDeclinedEvent(decliningPerson, personId));
    }

    @Override
    public void invitePerson(PersonId personId, PersonId friendId, String message) {
        this._friendsDao.addInvitation(personId, friendId, message);
        this._eventBus.post(new NewContactRequestEvent(personId, friendId, message));
    }

    @Override
    public boolean hasInvited(PersonId personId, PersonId friendId) {
        if (personId == null || friendId == null) {
            return false;
        }
        return this._friendsDao.hasInvited(personId, friendId);
    }

    @Override
    public List<PersonTeaserWithMessage> getInvitations(AuthorizationCheckContextWithUserId authCtx) {
        List<PersonIdWithMessage> idMsgs = this._friendsDao.getInvitations(authCtx.getUserId());
        ImmutableSet.Builder ids = ImmutableSet.builder();
        for (PersonIdWithMessage idMsg : idMsgs) {
            ids.add((Object)idMsg.getId());
        }
        ImmutableMap<PersonId, PersonTeaserModel> teasers = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)ids.build(), authCtx);
        ArrayList<PersonTeaserWithMessage> result = new ArrayList<PersonTeaserWithMessage>(idMsgs.size());
        for (PersonIdWithMessage idMsg : idMsgs) {
            PersonTeaserModel teaser = (PersonTeaserModel)teasers.get(idMsg.getId());
            if (teaser == null) continue;
            result.add(new PersonTeaserWithMessage(teaser, idMsg.getMessage()));
        }
        return result;
    }

    @Override
    public void deleteDependentFriendships(ImmutableSet<PersonId> personIds) {
        List<DBPersonRelation> relations = this._friendsDao.getFriendRelationsOf((Set<? extends PersonId>)personIds);
        this._friendsDao.deleteFriendshipsForDeletedPersons((Set<PersonId>)personIds);
        this._friendsDao.deleteInvitationsForDeletedPersons((Set<PersonId>)personIds);
        this._friendsRelationCacheAccessor.invalidateKeysAndWait(FluentIterable.from(relations).transform(PersonRelation.TO_TO).append(personIds).filter(Predicates.notNull()).toSet());
    }

    private static class FriendRelationCacheAccessor
    extends AbstractBiDirectionalCacheAccessor<FriendServiceCacheName, PersonId, PersonRelation> {
        private final FriendsDAO _friendsDao;

        FriendRelationCacheAccessor(@Nonnull CacheClient<? super FriendServiceCacheName> cache, @Nonnull FriendsDAO friendsDao) {
            super(cache, FriendServiceCacheName.FRIEND_RELATION);
            this._friendsDao = friendsDao;
        }

        @Override
        protected PersonId objectToValue(PersonRelation dbResult) {
            return dbResult.getTo();
        }

        @Override
        protected PersonId objectToKey(PersonRelation dbResult) {
            return dbResult.getFrom();
        }

        @Override
        protected Iterable<? extends DBPersonRelation> getListFromDatabase(Set<? extends PersonId> inputs) {
            return this._friendsDao.getFriendRelationsOf(inputs);
        }

        @Override
        protected String keyToString(PersonId key) {
            return key.toString();
        }
    }
}

