/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.impl;

import com.freiheit.toro.account.shared.model.WrongPasswordException;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableListMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.ValidationError;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.mail.business.PersonActivateNewEmailMailService;
import de.justsoftware.onx.person.business.AccountSettingsService;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.PersonValidator;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class AccountSettingsServiceImpl
implements AccountSettingsService {
    private final PersonService _personService;
    private final PersonActivateNewEmailMailService _personActivateNewEmailMailService;
    private final PersonReadWriteDataService _personReadWriteDataService;
    private final PersonValidator _personValidator;
    private final JucoPasswordEncoder _passwordEncoder;

    @Autowired
    public AccountSettingsServiceImpl(PersonService personService, PersonActivateNewEmailMailService personActivateNewEmailMailService, PersonReadWriteDataService personReadWriteDataService, PersonValidator personValidator, JucoPasswordEncoder passwordEncoder) {
        this._personService = personService;
        this._personActivateNewEmailMailService = personActivateNewEmailMailService;
        this._personReadWriteDataService = personReadWriteDataService;
        this._personValidator = personValidator;
        this._passwordEncoder = passwordEncoder;
    }

    @Nonnull
    private DBPerson authCheck(PersonId affectedPerson, AuthorizationCheckContext authCtx) {
        ProfileItem profile = InvalidIdServiceException.check(this._personService.getProfileItemByPersonId(affectedPerson));
        authCtx.check(profile, (Action)StaticAction.PROFILE_MODIFY_ACCOUNT_SETTINGS);
        return profile.getPerson();
    }

    @Nonnull
    private DBPerson ownAuthCheck(String password, AuthorizationCheckContextWithUserId authCtx) {
        PersonId affectedPerson = authCtx.getUserId();
        DBPerson personById = this.authCheck(affectedPerson, authCtx);
        if (!this._passwordEncoder.matches(password, personById.getPasswordHash())) {
            throw new WrongPasswordException();
        }
        return personById;
    }

    @Override
    public void updateOwnEmailAddress(String newEmail, String password, AuthorizationCheckContextWithUserId authCtx) throws ValidatableException {
        DBPerson person = this.ownAuthCheck(password, authCtx);
        DBAccountSettings accountSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(person.getId());
        accountSettings.setNewmail(newEmail);
        this._personService.updateEmailOrPasswordInAccountSettings(accountSettings);
        if (StringUtils.isNotBlank((String)newEmail) && !newEmail.equals(person.getEmail())) {
            this._personActivateNewEmailMailService.sendNewmailActivationEmail(newEmail, person, authCtx);
        }
    }

    @Override
    public void updateEmailAddressForDifferentUser(PersonId affectedPerson, String newEmail, AuthorizationCheckContext authCtx) throws ValidatableException {
        this.authCheck(affectedPerson, authCtx);
        DBAccountSettings oldSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(affectedPerson);
        DBAccountSettings accountSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(affectedPerson);
        accountSettings.setNewmail(newEmail);
        ImmutableListMultimap<String, ValidationError> validationErrors = this._personValidator.validate(accountSettings, oldSettings);
        if (!validationErrors.isEmpty()) {
            throw new ValidatableException(validationErrors);
        }
        this._personService.setNewEmail(affectedPerson, newEmail);
    }

    @Override
    public void updateOwnPassword(String newPassword, String oldPassword, AuthorizationCheckContextWithUserId authCtx) throws ValidatableException {
        DBPerson person = this.ownAuthCheck(oldPassword, authCtx);
        DBAccountSettings accountSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(person.getId());
        accountSettings.setOldPassword(oldPassword);
        accountSettings.setNewPassword(newPassword);
        this._personService.updateEmailOrPasswordInAccountSettings(accountSettings);
    }

    @Override
    public void updatePasswordForDifferentUser(PersonId affectedPerson, String newPassword, AuthorizationCheckContext authCtx) throws ValidatableException {
        this.authCheck(affectedPerson, authCtx);
        DBAccountSettings accountSettings = this._personReadWriteDataService.getAccountSettingsByPersonId(affectedPerson);
        accountSettings.setNewPassword(newPassword);
        this._personService.updateEmailOrPasswordInAccountSettings(accountSettings);
    }
}

