/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.attributes.i18n;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.person.business.attributes.errors.ConfigErrorException;
import de.justsoftware.onx.person.business.attributes.errors.DynamicConfigurationExceptions;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.Translation;
import de.justsoftware.onx.util.server.CSVParser;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class Translations {
    private final Language _language;
    private final ImmutableMap<String, Translation> _translations;

    public Translations(Language language, String translationsCfg) throws ConfigErrorException {
        this(language, Translations.parseCSV(language, translationsCfg));
    }

    public Translations(Language language, Iterable<Translation> translations) throws ConfigErrorException {
        try {
            this._language = language;
            this._translations = FluentIterable.from(translations).filter(Predicates.notNull()).filter(Translation.isOfLanguage(language)).uniqueIndex(Translation.TO_KEY);
        }
        catch (IllegalArgumentException e) {
            throw new DynamicConfigurationExceptions.I18nFormatError(e.getMessage());
        }
    }

    @Nonnull
    public static Iterable<Translation> parseCSV(Language language, String translationsCfg) throws ConfigErrorException {
        try {
            HashSet keys = Sets.newHashSet();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (CSVParser.CSVLine line : CSVParser.read(translationsCfg)) {
                if (line.isEmpty()) continue;
                if (line.fields().size() != 2) {
                    throw new DynamicConfigurationExceptions.I18nLineFormatError(line);
                }
                String key = line.fields().get(0);
                if (key.isEmpty()) {
                    throw new DynamicConfigurationExceptions.I18nMissingNameError(line);
                }
                if (keys.contains(key)) {
                    throw new DynamicConfigurationExceptions.I18nDuplicateKeyError(line);
                }
                String value = line.fields().get(1);
                if (StringUtils.isEmpty((String)value)) continue;
                builder.add((Object)new Translation(language, key, value));
            }
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new DynamicConfigurationExceptions.I18nFormatError(e.getMessage());
        }
    }

    @Nonnull
    public Collection<Translation> getTranslations() {
        return this._translations.values();
    }

    @Nonnull
    public Language getLanguage() {
        return this._language;
    }

    @CheckForNull
    public String translate(String term) {
        Translation translation = (Translation)this._translations.get((Object)term);
        return translation != null ? translation.getValue() : null;
    }

    @Nonnull
    public final Function<String, String> getTranslator() {
        return new NullPermeableFunction<String, String>(){

            @Override
            protected String applySafe(String input) {
                return Translations.this.translate(input);
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(Translations.class).add("language", (Object)this._language).add("_translations", this._translations).toString();
    }
}

