/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.attributes.i18n;

import com.google.common.base.Objects;
import de.justsoftware.onx.person.business.attributes.i18n.I18NString;
import de.justsoftware.onx.person.business.attributes.i18n.Language;
import de.justsoftware.onx.person.business.attributes.i18n.Translation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

public final class TranslatedI18NString
implements I18NString {
    private final Map<Language, String> _i18nNames = new HashMap<Language, String>();
    private final String _term;

    @ParametersAreNonnullByDefault
    public TranslatedI18NString(String term, Collection<Translation> translations) {
        this._term = term;
        for (Translation t : translations) {
            if (!this._term.equals(t.getKey())) continue;
            this._i18nNames.put(t.getLanguage(), t.getValue());
        }
    }

    @Override
    public String getFor(Language locale) {
        String translation = this._i18nNames.get(locale);
        if (StringUtils.isEmpty((String)translation)) {
            return this._term;
        }
        return translation;
    }

    @Override
    public boolean hasTranslation(Language locale) {
        return this._i18nNames.containsKey(locale);
    }

    public String toString() {
        return "I18NString:" + this._i18nNames;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._i18nNames, this._term});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof TranslatedI18NString && Objects.equal(this._i18nNames, ((TranslatedI18NString)obj)._i18nNames) && Objects.equal((Object)this._term, (Object)((TranslatedI18NString)obj)._term);
    }
}

