/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business.attributes.i18n;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;

public final class Language {
    public static final Function<String, Language> FROM_STRING = new NullPermeableFunction<String, Language>(){

        @Override
        protected Language applySafe(String input) {
            return Language.of(input);
        }
    };
    public static final Function<Language, String> TO_STRING = new NullPermeableFunction<Language, String>(){

        @Override
        protected String applySafe(Language input) {
            return input.toString();
        }
    };
    private static final ValueOfMap<String, Language> LANGS = new ValueOfMap<String, Language>(){

        @Override
        protected Language create(String key) {
            return new Language(key);
        }
    };
    private final String _language;
    private final int _hashCode;

    private Language(@Nonnull String language) {
        this._language = language;
        this._hashCode = Objects.hashCode((Object[])new Object[]{this._language});
    }

    public String toString() {
        return this._language;
    }

    @Nonnull
    public static Language of(@Nonnull String language) {
        return LANGS.get(language);
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof Language && Objects.equal((Object)this._language, (Object)((Language)obj)._language);
    }

    public int hashCode() {
        return this._hashCode;
    }
}

