/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.person.business.PersonCommand;
import de.justsoftware.onx.person.business.attributes.i18n.MultiLangBook;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import de.justsoftware.onx.person.shared.server.ProfileComponentInfo;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.person.shared.server.model.StartpageItem;
import de.justsoftware.onx.process.business.model.AccountActivationResult;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface PersonService {
    @CheckForNull
    public DBPerson getPersonById(PersonId var1);

    @Nonnull
    public DBPerson getPersonByIdNotNull(PersonId var1) throws InvalidIdServiceException;

    @Nonnull
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<PersonId> var1);

    public void deleteOwnPerson(AuthorizationCheckContextWithUserId var1);

    public void deleteOtherPerson(PersonId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteOtherPersonFromAllTenants(PersonId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteDependentPersons(Set<PersonId> var1, DeletionContext var2);

    @Nonnull
    public ImmutableListMultimap<PersonId, ProfileComponentInfo> getProfileComponentInfos(Set<PersonId> var1, AuthorizationCheckContext var2);

    public MultiLangBook getRolesTranslation();

    @Nonnull
    public PersonRolesClientTranslation getRolesTranslation(String var1);

    public PersonId savePerson(@Nullable PersonId var1, PersonCommand var2, FeedMessageControl var3) throws ValidatableException;

    public PersonId savePerson(@Nullable PersonId var1, PersonCommand var2, FeedMessageControl var3, ServerEventCollector var4) throws ValidatableException;

    public void removeImage(PersonId var1) throws ServiceException, ValidatableException;

    @Nonnull
    public AccountActivationResult activateAccountById(PersonId var1);

    public void setAccountActivated(PersonId var1, boolean var2, AuthorizationCheckContext var3);

    @Nonnull
    public AccountActivationResult activateAccount(String var1);

    public void changeLanguageForUser(PersonId var1, String var2);

    public boolean activateNewMail(String var1);

    @CheckForNull
    public DBPerson getPersonByHash(String var1);

    @CheckForNull
    public DBPerson getPersonByEmail(@Nullable String var1);

    public DBPerson getPersonByEmailOrNewmail(String var1);

    public ImmutableMap<String, PersonId> isEmailRegistered(Set<String> var1);

    @Nonnull
    public DBAccountSettings getAccountSettingsByPersonId(PersonId var1);

    public void updateLastLoginDate(PersonId var1, Date var2) throws ServiceException;

    public void updateEmailOrPasswordInAccountSettings(DBAccountSettings var1) throws ValidatableException;

    @Nonnull
    public Map<PersonId, EmailNotificationSettingsBean> getEmailNotificationSettingsByPersonIds(Set<PersonId> var1);

    public void saveEmailNotificationSettings(DBEmailNotificationSettings var1, boolean var2, AuthorizationCheckContext var3);

    @Nonnull
    public String signedNewMailActivationCode(PersonId var1, String var2, LocalDateTime var3);

    public List<PersonId> getAllPersonIds(boolean var1, int var2, int var3);

    public boolean isProfileComponentVisible(PersonId var1, ComponentType var2, AuthorizationCheckContext var3);

    public ImmutableSet<PersonId> filterPublicProfiles(Iterable<PersonId> var1, AuthorizationCheckContext var2);

    @CheckForNull
    public ProfileItem getProfileItemByPersonId(@Nullable PersonId var1);

    @Nonnull
    public ImmutableMap<PersonId, ProfileItem> getProfileItemsByPersonIds(Set<PersonId> var1);

    @Nonnull
    public ImmutableMap<PersonId, ProfileItem> getProfileItemsForPersons(Map<PersonId, DBPerson> var1);

    @CheckForNull
    public StartpageItem getStartpageItemByPersonId(@Nullable PersonId var1);

    public void updateImage(PersonId var1, String var2) throws ServiceException;

    public boolean isEmailNotificationEnabled(PersonId var1);

    @Nonnull
    public ImmutableSet<PersonId> getEmailNotificationEnabledPersons(Set<PersonId> var1);

    public void updateNameSettings(PersonId var1, NameSettings var2, boolean var3) throws ValidatableException;

    @Nonnull
    public ImmutableList<PersonId> getUpcommingBirthDays(int var1, DateTime var2);

    @Nonnull
    public TimeZone getTimeZoneOfUserOrDefault(@Nullable PersonId var1);

    public void setPersonBlocked(PersonId var1, boolean var2, AuthorizationCheckContext var3) throws ValidatableException;

    @Nonnull
    public String getAnnotatedName(@Nullable DBPerson var1);

    @Nonnull
    public String getAnnotatedNameWithLocale(@Nullable DBPerson var1, @Nullable String var2);

    @Nonnull
    public List<PersonId> getPersonIdsByRole(List<String> var1);

    public void acceptTerms(PersonId var1, String var2);

    @Nonnull
    public String generateLoginCode(PersonId var1);

    public void notifyPersonActivated(PersonId var1, ServerEventCollector var2);

    public void notifyPersonDeactivated(PersonId var1, ServerEventCollector var2);

    public void notifyPersonBlocked(PersonId var1, boolean var2, ServerEventCollector var3);

    public void notifyPersonDeleted(PersonId var1, ServerEventCollector var2);

    public int getActiveUserCount();

    public int getTotalUserCount();

    @Nonnull
    public ImmutableTable<PersonId, ComponentType, ComponentModel> getVisibleComponents(Map<PersonId, ProfileItem> var1, SearchAuthorizationCheckContext var2);

    public void setNewEmail(PersonId var1, String var2) throws ValidatableException;

    public static enum FeedMessageControl {
        DONT_GENERATE_FEED_MESSAGE,
        GENERATE_FEED_MESSAGE;

    }
}

