/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface PersonRoleService {
    @Nonnull
    public ImmutableMap<String, ? extends Role> getAllPersonAndStaticRoles();

    public ImmutableList<String> getVisibleRoleNames();

    @Nonnull
    public Set<PersonRole> getAllNonHiddenPersonRoles();

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonRole> getVisibleRolesFor(Set<PersonId> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableSetMultimap<Boolean, PersonRole> filterVisibleRoles(Iterable<PersonRole> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<PersonId> var1);

    @Nonnull
    default public ImmutableSet<PersonRole> getPersonRoles(PersonId personId) {
        return this.getPersonRoles((Set<PersonId>)ImmutableSet.of((Object)personId)).get((Object)personId);
    }

    public void addPersonRoles(PersonId var1, Set<PersonRole> var2, AuthorizationCheckContext var3);

    public void savePersonRoles(PersonId var1, Set<PersonRole> var2, AuthorizationCheckContext var3);

    public void savePersonRoles(PersonId var1, Set<PersonRole> var2, boolean var3, ServerEventCollector var4);
}

