/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.DBEmailNotificationSettings;
import de.justsoftware.onx.person.shared.model.DBProfileComponent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface PersonReadDataService {
    @CheckForNull
    public DBPerson getPersonById(PersonId var1);

    @Nonnull
    public ImmutableMap<PersonId, DBPerson> getPersonsByIds(Set<PersonId> var1);

    @Nonnull
    public ImmutableList<PersonId> getUpcommingBirthDays(int var1, DateTime var2);

    @Nonnull
    public ImmutableListMultimap<PersonId, DBProfileComponent> getProfileComponentsByIds(Set<PersonId> var1);

    @Nonnull
    public Map<PersonId, DBEmailNotificationSettings> getEmailNotificationSettingsByPersonIds(Set<PersonId> var1);

    @Nonnull
    public DBAccountSettings getAccountSettingsByPersonId(PersonId var1);

    @Nonnull
    public List<PersonId> getPersonIdsByRole(List<String> var1);

    @CheckForNull
    public PersonId getPersonIdByEmail(String var1);

    public int getActiveUserCount();

    public int getTotalUserCount();

    public boolean getPersonWithMd5Password(BiConsumer<PersonId, String> var1);

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonRole> getPersonRoles(Set<PersonId> var1);
}

