/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.ShowBirthdayOption;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonBirthdayTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserWithMessage;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public interface FriendsService {
    @Nonnull
    public ImmutableSet<PersonId> getFriendIdsOfId(@Nonnull PersonId var1);

    @Nonnull
    public ImmutableSetMultimap<PersonId, PersonId> getFriendIdsOfPersons(@Nonnull Set<PersonId> var1);

    @Nonnull
    public ListAndCount<PersonTeaserModel> getFriendTeasersOfId(@Nonnull PersonId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    @Nonnull
    public ListAndCount<PersonBadgeModel> getFriendBadgesOfId(@Nonnull PersonId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithUserId var4);

    public int getFriendCount(PersonId var1, AuthorizationCheckContext var2);

    public void endFriendship(PersonId var1, PersonId var2);

    @Nonnull
    public ImmutableList<PersonBirthdayTeaserModel> getFriendsBadgesWithUpcomingBirthdays(int var1, @Nonnull ShowBirthdayOption var2, @Nonnull AuthorizationCheckContextWithUserId var3, @Nonnull DateTime var4);

    @Nonnull
    public ImmutableList<DBPerson> getFriendsWithUpcomingBirthdays(int var1, @Nonnull AuthorizationCheckContextWithUserId var2);

    public boolean isFriendOf(PersonId var1, PersonId var2);

    public void acceptInvitation(@Nonnull PersonId var1, @Nonnull PersonId var2);

    public void declineInvitation(PersonId var1, PersonId var2);

    public void invitePerson(PersonId var1, PersonId var2, String var3);

    public boolean hasInvited(PersonId var1, PersonId var2);

    @Nonnull
    public List<PersonTeaserWithMessage> getInvitations(@Nonnull AuthorizationCheckContextWithUserId var1);

    public void deleteDependentFriendships(@Nonnull ImmutableSet<PersonId> var1);
}

