/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.performance;

import de.justsoftware.toolbox.performance.PerformanceLogger;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Aspect
@ParametersAreNonnullByDefault
@EnableAspectJAutoProxy
public class PerformanceLoggerConfiguration {
    private static final int DEFAULT_INFO_THRESHOLD_MS = 100;
    private static final int DEFAULT_WARN_THRESHOLD_MS = 1000;

    public PerformanceLoggerConfiguration() {
        PerformanceLogger.setPerformanceLoggerEnabled((boolean)true);
        PerformanceLogger.setThresholdTotalNanos((long)TimeUnit.MILLISECONDS.toNanos(100L));
        PerformanceLogger.setThresholdWarnNanos((long)TimeUnit.MILLISECONDS.toNanos(1000L));
    }

    @Around(value="within(de.justsoftware.onx..*) && !within(de.justsoftware.onx.security..*)")
    public Object invokePerformanceLogger(ProceedingJoinPoint joinPoint) throws Throwable {
        return PerformanceLogger.logJoinPoint((ProceedingJoinPoint)joinPoint);
    }

    public static void setPerformanceLoggerEnabled(boolean enabled) {
        PerformanceLogger.setPerformanceLoggerEnabled((boolean)enabled);
    }

    public void setInfoThresholdMillis(int infoThresholdMillis) {
        PerformanceLogger.setThresholdTotalNanos((long)TimeUnit.MILLISECONDS.toNanos(infoThresholdMillis));
    }

    public void setWarnThresholdMillis(int warnThresholdMillis) {
        PerformanceLogger.setThresholdWarnNanos((long)TimeUnit.MILLISECONDS.toNanos(warnThresholdMillis));
    }

    public void setThresholdMethodMicroseconds(long thresholdMethodMicroseconds) {
        PerformanceLogger.setThresholdMethodNanos((long)TimeUnit.MICROSECONDS.toNanos(thresholdMethodMicroseconds));
    }
}

