/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.people.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.server.model.JucoVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class PeopleInternalApiConnectorImpl
implements PeopleInternalApiConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeopleInternalApiConnectorImpl.class);
    private final String _peopleInternalApiUrl;
    private final RestOperations _restTemplate;
    private final String _jucoVersion;

    @Autowired
    public PeopleInternalApiConnectorImpl(@Value(value="${just-people.internalApi.url}") String peopleInternalApiUrl, JucoServerVersionService versionService, @Qualifier(value="defaultRestTemplate") RestOperations restTemplate) {
        this._peopleInternalApiUrl = peopleInternalApiUrl;
        this._jucoVersion = versionService.getCurrentVersion();
        this._restTemplate = restTemplate;
    }

    @Override
    public void publishAllUserGroups() {
        try {
            this._restTemplate.postForLocation(this._peopleInternalApiUrl + "/publish/groups", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw PeopleInternalApiConnectorImpl.logAndThrow("Failed to publish all user groups.", e);
        }
    }

    @Override
    public void reindexAllUserGroups() {
        try {
            this._restTemplate.postForLocation(this._peopleInternalApiUrl + "/reindex/groups", null, new Object[0]);
        }
        catch (RestClientException e) {
            throw PeopleInternalApiConnectorImpl.logAndThrow("Failed to reindex all user groups.", e);
        }
    }

    @Override
    public boolean available() {
        try {
            this._restTemplate.postForLocation(this._peopleInternalApiUrl + "/status", null, new Object[0]);
            return true;
        }
        catch (RestClientException e) {
            LOGGER.error("Failed get the status of the internal people api", (Throwable)e);
            return false;
        }
    }

    @Nonnull
    public String getPeopleVersion() {
        try {
            return (String)this._restTemplate.getForEntity(this._peopleInternalApiUrl + "/version", String.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw PeopleInternalApiConnectorImpl.logAndThrow("Failed to load people version.", e);
        }
    }

    @Override
    public boolean hasSameJucoVersion() {
        try {
            return JucoVersion.compareWithoutBuildNumber(this._jucoVersion, this.getPeopleVersion()) == 0;
        }
        catch (ServiceException e) {
            return false;
        }
    }

    @Nonnull
    private static ServiceException logAndThrow(String msg, @Nullable Throwable e) {
        LOGGER.error(msg, e);
        return new ServiceException(msg + "See log for more details.", e);
    }

    @Override
    public void migrateAllUsersRole() {
        this._restTemplate.put(this._peopleInternalApiUrl + "/migrate/allUsersRole", null, new Object[0]);
    }
}

