/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.BatchStatementProcessor;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.notifications.business.NotificationAttribute;
import de.justsoftware.onx.notifications.business.model.BaseNotification;
import de.justsoftware.onx.notifications.integration.persistence.DBNotificationMigrationStatus;
import de.justsoftware.onx.notifications.integration.persistence.NotificationDAO;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.notifications.shared.model.NotificationStateType;
import de.justsoftware.onx.notifications.shared.model.NotificationType;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
@ParametersAreNonnullByDefault
public class IbatisNotificationDAO
implements NotificationDAO {
    private static final String NAMESPACE = "Notification.";
    private final SqlMapClient _sqlMapClient;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisNotificationDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._transactionHelper = transactionHelper;
        this._sqlMapClient = sqlMapClient;
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("Notification");
    }

    private void insertNotificationAttributes(NotificationId notificationId, Map<NotificationAttribute, String> attributes) {
        IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "Notification.insertNotificationAttributes", ImmutableMap.of((Object)"notificationId", (Object)notificationId, (Object)"attributes", IbatisDAOUtil.toIbatisList(attributes.entrySet())));
    }

    @Override
    public ImmutableMap<PersonId, NotificationId> insertNotifications(final NotificationType type, final NotificationStateType state, final PersonId originatorId, final Set<PersonId> receiverIds, final EntityId entityId, final EntityType entityType, final ItemId subjectId, final DateTime createdAt, final Map<NotificationAttribute, String> attributes) {
        if (CollectionUtil.isEmpty(receiverIds)) {
            return ImmutableMap.of();
        }
        return this._transactionHelper.doInTransaction(new TransactionCallback<ImmutableMap<PersonId, NotificationId>>(){

            public ImmutableMap<PersonId, NotificationId> doInTransaction(TransactionStatus status) {
                Date date = createdAt.toDate();
                final HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("type", (Object)type);
                params.put("state", (Object)state);
                params.put("originatorId", originatorId);
                params.put("entityId", entityId);
                params.put("entityType", entityType);
                params.put("subjectId", subjectId);
                params.put("createDate", date);
                params.put("modifyDate", date);
                final ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
                IbatisDAOUtil.executeInBatch(IbatisNotificationDAO.this._sqlMapClient, IbatisDAOUtil.toIbatisList(receiverIds), 1000, new BatchStatementProcessor<PersonId>(){

                    @Override
                    public void process(SqlMapClient client, PersonId receiverId) throws SQLException {
                        params.put("receiverId", receiverId);
                        NotificationId id = (NotificationId)IbatisDAOUtil.wrappedInsert(client, "Notification.insertNotification", params);
                        if (!attributes.isEmpty()) {
                            IbatisNotificationDAO.this.insertNotificationAttributes(id, attributes);
                        }
                        resultBuilder.put((Object)receiverId, (Object)id);
                    }
                });
                return resultBuilder.build();
            }
        });
    }

    @Override
    public ImmutableList<BaseNotification> getOpenNotificationsSince(LocalDate since, NotificationId notificationId, int limit) {
        HashMap params = Maps.newHashMap();
        params.put("id", notificationId);
        params.put("since", Date.from(since.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        params.put("limit", limit);
        ImmutableList notifications = this._ibatisBuilder.selectDbSpecific("getOpenNotificationsSince").param(params).asList();
        return ImmutableList.copyOf((Collection)notifications.stream().map(BaseNotification::new).collect(Collectors.toList()));
    }

    @Override
    public DBNotificationMigrationStatus getNotificationMigrationStatus() {
        return (DBNotificationMigrationStatus)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getNotificationMigrationStatus").noParam()).asObject();
    }

    @Override
    public void setNotificationMigrationStatus(DBNotificationMigrationStatus migrationStatus) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            int updatedRows = this._ibatisBuilder.update("updateNotificationMigrationStatus").param(migrationStatus);
            if (updatedRows != 1) {
                this._ibatisBuilder.delete("deleteNotificationMigrationStatus").noParam();
                this._ibatisBuilder.insert("insertNotificationMigrationStatus").param(migrationStatus);
            }
        });
    }
}

