/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NotificationMigrationStatus {
    private final boolean _running;
    private final NotificationId _lastMigratedNotificationId;
    private final Date _migrationStartAt;

    public NotificationMigrationStatus(boolean running, @Nullable NotificationId lastMigratedNotificationId, @Nullable Date migrationStartAt) {
        this._running = running;
        this._lastMigratedNotificationId = lastMigratedNotificationId;
        this._migrationStartAt = Dates.clone(migrationStartAt);
    }

    public boolean isRunning() {
        return this._running;
    }

    @CheckForNull
    public NotificationId getLastMigratedNotificationId() {
        return this._lastMigratedNotificationId;
    }

    @CheckForNull
    public Date getMigrationStartAt() {
        return Dates.clone(this._migrationStartAt);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("running", this._running).add("lastMigratedNotificationId", (Object)this._lastMigratedNotificationId).add("migrationStartAt", (Object)this._migrationStartAt).toString();
    }
}

