/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.notifications.business.NotificationAttribute;
import de.justsoftware.onx.notifications.business.model.IBaseNotification;
import de.justsoftware.onx.notifications.shared.model.NotificationId;
import de.justsoftware.onx.notifications.shared.model.NotificationStateType;
import de.justsoftware.onx.notifications.shared.model.NotificationType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public class BaseNotification
implements IBaseNotification {
    public static final Function<IBaseNotification, BaseNotification> COPY = new NullPermeableFunction<IBaseNotification, BaseNotification>(){

        @Override
        protected BaseNotification applySafe(IBaseNotification input) {
            return new BaseNotification(input);
        }
    };
    private final NotificationId _id;
    private final NotificationType _type;
    private final NotificationStateType _state;
    private final PersonId _orginatorId;
    private final PersonId _receiverId;
    private final EntityId _entityId;
    private final EntityType _entityType;
    private final ItemId _subjectId;
    private final Date _createDate;
    private final Date _modifyDate;
    private final ImmutableMap<NotificationAttribute, String> _attributes;

    @ParametersAreNonnullByDefault
    public BaseNotification(IBaseNotification baseNotification) {
        this._id = baseNotification.getId();
        this._orginatorId = baseNotification.getOriginatorId();
        this._receiverId = baseNotification.getReceiverId();
        this._state = baseNotification.getState();
        this._type = baseNotification.getType();
        this._entityId = baseNotification.getEntityId();
        this._entityType = baseNotification.getEntityType();
        this._subjectId = baseNotification.getSubjectId();
        this._createDate = Dates.clone(baseNotification.getCreateDate());
        this._modifyDate = Dates.clone(baseNotification.getModifyDate());
        this._attributes = ImmutableMap.copyOf(baseNotification.getAttributes());
    }

    @CheckForNull
    public static BaseNotification valueOf(@Nullable IBaseNotification notification) {
        return notification == null ? null : new BaseNotification(notification);
    }

    @Override
    public NotificationId getId() {
        return this._id;
    }

    @Override
    public PersonId getOriginatorId() {
        return this._orginatorId;
    }

    @Override
    public PersonId getReceiverId() {
        return this._receiverId;
    }

    @Override
    public NotificationStateType getState() {
        return this._state;
    }

    @Override
    public NotificationType getType() {
        return this._type;
    }

    @Override
    public ItemId getSubjectId() {
        return this._subjectId;
    }

    @Override
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Override
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    @Override
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    @Override
    public ImmutableMap<NotificationAttribute, String> getAttributes() {
        return this._attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("type", (Object)this._type).add("state", (Object)this._state).add("orginator", (Object)this._orginatorId).add("receiver", (Object)this._receiverId).add("subjectId", (Object)this._subjectId).add("entityId", (Object)this._entityId).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).add("attributes", this._attributes).toString();
    }
}

