/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notifications.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.comments.business.events.CommentCreatedEvent;
import de.justsoftware.onx.comments.business.events.CommentUpdatedEvent;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.DriveShareAccessGrantEvent;
import de.justsoftware.onx.container.business.events.DriveShareAccessRequestEvent;
import de.justsoftware.onx.container.business.events.EntityVersionDeclinedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionReleaseEvent;
import de.justsoftware.onx.container.business.events.EntityVersionReviewRequestEvent;
import de.justsoftware.onx.container.business.events.EntityVersionWillGetArchivedEvent;
import de.justsoftware.onx.container.business.events.NewEntityJoinRequestEvent;
import de.justsoftware.onx.container.business.events.NewEntityMembershipInternalInvitationsEvent;
import de.justsoftware.onx.container.business.events.NewEntityRecommendationEvent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.shared.model.DriveShareId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversation;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.notifications.business.NotificationDispatcher;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.business.events.ContactRequestAcceptedEvent;
import de.justsoftware.onx.person.business.events.ConversationDeletedEvent;
import de.justsoftware.onx.person.business.events.InvitedUserRegisteredEvent;
import de.justsoftware.onx.person.business.events.NewContactRequestEvent;
import de.justsoftware.onx.person.business.events.RemovedFromConversationEvent;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.tasks.business.events.AddedToTaskListEvent;
import de.justsoftware.onx.tasks.business.events.RecommendationTaskAssignedEvent;
import de.justsoftware.onx.tasks.business.events.TaskAssignedEvent;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingPublishedEvent;
import de.justsoftware.onx.workstream.business.event.MicroblogPostingUpdatedEvent;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.server.model.WorkstreamItem;
import de.justsoftware.toolbox.clock.Clock;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationDispatcherImpl
implements ServerEventHandler,
NotificationDispatcher {
    @VisibleForTesting
    static final int TITLE_SUBSTITUTION_LENGTH = 100;
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDispatcherImpl.class);
    private static final int THREADPOOL_SHUTDOWN_TIMEOUT_SECONDS = 10;
    private final NotificationProducer _notificationProducer;
    private final I18nService _i18nService;
    private final EntityService _entityService;
    private final EntityVersionService _entityVersionService;
    private final PersonService _personService;
    private final EntityAdministrationWorkflowService _entityAdministrationService;
    private final MessageService _messageService;
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final Settings _settings;
    private final Clock _clock;
    private final LikeService _likeService;
    private final ItemService _itemService;
    private final ExecutorService _notificationThreadPool;

    @Autowired
    public NotificationDispatcherImpl(NotificationProducer notificationProducer, I18nService i18nService, EntityService entityService, EntityVersionService entityVersionService, PersonService personService, EntityAdministrationWorkflowService entityAdministrationService, MessageService messageService, AuthorizationContextProvider authorizationContextProvider, Settings settings, Clock clock, LikeService likeService, ItemService itemService, @Qualifier(value="notificationDispatcherThreadPool") ExecutorService notificationThreadPool) {
        this._notificationProducer = notificationProducer;
        this._i18nService = i18nService;
        this._entityService = entityService;
        this._entityVersionService = entityVersionService;
        this._personService = personService;
        this._entityAdministrationService = entityAdministrationService;
        this._messageService = messageService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._settings = settings;
        this._clock = clock;
        this._likeService = likeService;
        this._itemService = itemService;
        this._notificationThreadPool = notificationThreadPool;
    }

    @Nonnull
    private Set<String> toReceivers(Set<PersonId> personIds) {
        return personIds.stream().filter(Predicates.notNull()).map(personId -> personId.asProfileId().asString()).collect(Collectors.toSet());
    }

    @Nonnull
    private Map<Locale, ServerLocalizedMessages> getAllServerLocalizedMessages() {
        ImmutableSet<String> languages = this._i18nService.getAvailableLanguages();
        return languages.stream().collect(Collectors.toMap(language -> Locale.forLanguageTag(language), language -> this._i18nService.getLocalizedMessages((String)language)));
    }

    @Nonnull
    private static Map<Locale, String> getTranslations(Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages, Function<ServerLocalizedMessages, String> translationProvider) {
        return allServerLocalizedMessages.entrySet().stream().collect(Collectors.toMap(entry -> (Locale)entry.getKey(), entry -> (String)translationProvider.apply((ServerLocalizedMessages)entry.getValue())));
    }

    @Nonnull
    private String getDefaultTranslation(Map<Locale, String> translations) {
        String defaultLanguage = this._settings.defaultLanguage();
        Locale defaultLocale = Locale.forLanguageTag(defaultLanguage);
        return (String)MoreObjects.firstNonNull((Object)translations.get(defaultLocale), (Object)"");
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewEntityInternalInvitation(NewEntityMembershipInternalInvitationsEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityInternalInvitationNotification(event.getInviterId(), event.getEntityId(), event.getInvitedPersons(), event.getInvitationMessage());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityInternalInvitationNotification(PersonId inviterId, EntityId entityId, Set<PersonId> invitedPersons, String invitationMessage) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson inviter = this._personService.getPersonByIdNotNull(inviterId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).invitationText(inviter.getFullName(), entity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).invitationTitle(entityType));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.INVITATION).withReceivers(this.toReceivers(invitedPersons)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(invitationMessage).withTargetId(entityId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onContactRequest(NewContactRequestEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateContactRequestNotification(event.getPersonId(), event.getFriendId(), event.getInvitationMessage());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateContactRequestNotification(PersonId requesterId, PersonId friendId, String invitationMessage) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(requesterId).getTenantId();
        CoreApp app = CoreApp.PEOPLE;
        DBPerson requester = this._personService.getPersonByIdNotNull(requesterId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().contactRequestText(requester.getFullName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().contactRequestTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.CONTACT_REQUEST).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)friendId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(invitationMessage).withTargetId(requesterId.asProfileId().asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onInvitedUserRegistered(InvitedUserRegisteredEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateInvitedUserRegisteredNotification(event.getInvitedUserId(), event.getInviterIds());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateInvitedUserRegisteredNotification(PersonId invitedUserId, Set<PersonId> inviterIds) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(invitedUserId).getTenantId();
        CoreApp app = CoreApp.PEOPLE;
        DBPerson invitedUser = this._personService.getPersonByIdNotNull(invitedUserId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().invitedUserRegisteredText(invitedUser.getFullName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().invitedUserRegisteredTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.INVITED_USER_REGISTERED).withReceivers(this.toReceivers(inviterIds)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(invitedUserId.asProfileId().asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionReviewRequest(EntityVersionReviewRequestEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityVersionReviewRequestNotification(event.getVersion(), event.getReviewerId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityVersionReviewRequestNotification(EntityVersion entityVersion, PersonId reviewerId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        EntityId entityId = entityVersion.getEntityId();
        DBEntity dbEntity = this._entityService.getByIdNotNull(entityId);
        EntityVersion currentReview = (EntityVersion)this._entityVersionService.getVersionsCurrentlyInReview((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
        EntityVersionId versionId = entityVersion.getId();
        if (currentReview != null && versionId.equals(currentReview.getId())) {
            TenantId tenantId = dbEntity.getTenantId();
            EntityType entityType = dbEntity.getType();
            CoreApp app = this._entityService.getAppForEntityType(entityType);
            DBPerson author = this._personService.getPersonByIdNotNull(entityVersion.getAuthorId());
            Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
            Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).versionReleaseRequestText(author.getFullName(), entityType, dbEntity.getName()));
            Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).versionReleaseRequestTitle());
            return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.VERSION_RELEASE_REQUEST).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)reviewerId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withDefaultSecondaryText(entityVersion.getCommentForReviewers()).withLocalizedTitle(localizedTitle).withTargetId(entityId.toString()).withPayload(versionId.asString()).build();
        }
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewEntityJoinRequest(NewEntityJoinRequestEvent event) {
        this._notificationThreadPool.execute(() -> {
            EntityId entityId = event.getEntityId();
            ImmutableSet adminsAndCoAdmins = this._entityAdministrationService.getDirectAdminsAndCoAdmins((Set<EntityId>)ImmutableSet.of((Object)entityId)).get((Object)entityId);
            Notification notification = this.generateEntityJoinRequestNotification(event.getRequesterId(), entityId, (ImmutableSet<PersonId>)adminsAndCoAdmins);
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityJoinRequestNotification(PersonId requestingUserId, EntityId entityId, ImmutableSet<PersonId> receiverIds) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson requestingUser = this._personService.getPersonByIdNotNull(requestingUserId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).joinRequestText(requestingUser.getFullName(), entityType, entity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).joinRequestTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.ENTITY_JOIN_REQUEST).withReceivers(this.toReceivers((Set<PersonId>)receiverIds)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(entityId.asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionWillGetArchived(EntityVersionWillGetArchivedEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityVersionWillGetArchivedNotification(event.getReceiverId(), event.getVersion(), event.getNumberOfDaysTillArchive());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityVersionWillGetArchivedNotification(PersonId receiverId, EntityVersion entityVersion, int numberOfDaysTillArchive) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        EntityId entityId = entityVersion.getEntityId();
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).willGetArchivedText(entityType, entity.getName(), numberOfDaysTillArchive));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).willGetArchivedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.ENTITY_WILL_GET_ARCHIVED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)receiverId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(entityId.asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionReleaseRequestAccepted(EntityVersionReleaseEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityVersionReleaseRequestAcceptedNotification(event.getVersion(), event.getReviewerId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityVersionReleaseRequestAcceptedNotification(EntityVersion entityVersion, PersonId reviewerId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        EntityId entityId = entityVersion.getEntityId();
        DBEntity dbEntity = this._entityService.getByIdNotNull(entityId);
        PersonId authorId = entityVersion.getAuthorId();
        if (reviewerId.equals(authorId)) {
            return null;
        }
        TenantId tenantId = dbEntity.getTenantId();
        EntityType entityType = dbEntity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson reviewer = this._personService.getPersonByIdNotNull(reviewerId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).versionReleaseRequestAcceptedText(reviewer.getFullName(), entityType, dbEntity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).versionReleaseRequestAcceptedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.VERSION_RELEASE_REQUEST_ACCEPTED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)authorId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(entityId.toString()).withPayload(entityVersion.getId().asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onContactRequestAccepted(ContactRequestAcceptedEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateContactRequestAcceptedNotification(event.getAcceptorId(), event.getRequesterId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateContactRequestAcceptedNotification(PersonId acceptorId, PersonId requesterId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(acceptorId).getTenantId();
        CoreApp app = CoreApp.PEOPLE;
        DBPerson acceptor = this._personService.getPersonByIdNotNull(acceptorId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().contactRequestAcceptedText(acceptor.getFullName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().contactRequestAcceptedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.CONTACT_REQUEST_ACCEPTED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)requesterId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(acceptorId.asProfileId().toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionDeclined(EntityVersionDeclinedEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityVersionDeclinedNotification(event.getRejectorId(), event.getVersion());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityVersionDeclinedNotification(PersonId declinerId, EntityVersion entityVersion) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        PersonId authorId = entityVersion.getAuthorId();
        EntityVersionId versionId = entityVersion.getId();
        EntityId entityId = entityVersion.getEntityId();
        DBEntity dbEntity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = dbEntity.getTenantId();
        EntityType entityType = dbEntity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson decliner = this._personService.getPersonByIdNotNull(declinerId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).releaseRequestDeclinedText(decliner.getFullName(), entityType, dbEntity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).releaseRequestDeclinedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.VERSION_RELEASE_REQUEST_DECLINED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)authorId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(entityVersion.getDeclineMessage()).withTargetId(entityId.toString()).withPayload(versionId.asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onDriveShareAccessRequest(DriveShareAccessRequestEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateDriveShareAccessRequestNotification(event.getRequestorId(), event.getDriveShareId(), event.getShareName(), (Set<PersonId>)event.getAdmins());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateDriveShareAccessRequestNotification(PersonId requestorId, DriveShareId driveShareId, String driveShareName, Set<PersonId> admins) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(requestorId).getTenantId();
        CoreApp app = CoreApp.DRIVE;
        DBPerson requestor = this._personService.getPersonByIdNotNull(requestorId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().driveShareAccessRequestText(requestor.getFullName(), driveShareName));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().driveShareAccessRequestTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.DRIVE_SHARE_ACCESS_REQUEST).withReceivers(this.toReceivers(admins)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(driveShareId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onDriveShareAccessGrant(DriveShareAccessGrantEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateDriveShareAccessGrantNotification(event.getNewMember(), event.getExecutor(), event.getShareName(), event.getDriveShareId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateDriveShareAccessGrantNotification(PersonId newMemberId, PersonId executorId, String shareName, DriveShareId shareId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(newMemberId).getTenantId();
        CoreApp app = CoreApp.DRIVE;
        DBPerson executor = this._personService.getPersonByIdNotNull(executorId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().driveShareAccessGrantText(executor.getFullName(), shareName));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().driveShareAccessGrantTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.DRIVE_SHARE_ACCESS_GRANT).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)newMemberId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(shareId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onRemovedFromConversation(RemovedFromConversationEvent event) {
        this._notificationThreadPool.execute(() -> {
            DBConversation conversation = event.getConversation();
            if (conversation.getType() == ConversationType.ONE_ON_ONE) {
                LOG.warn("Removing a person from a one-on-one conversation should not be possible");
                return;
            }
            String customTitle = conversation.getTitle();
            String conversationTitle = customTitle != null ? customTitle : "";
            Notification notification = this.generateRemovedFromConversationNotification(event.getRemoverId(), (Set<PersonId>)event.getRemovedPersonsIds(), conversationTitle);
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateRemovedFromConversationNotification(PersonId removerId, Set<PersonId> removedPersonIds, String conversationTitle) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(removerId).getTenantId();
        CoreApp app = CoreApp.CONVERSATIONS;
        DBPerson remover = this._personService.getPersonByIdNotNull(removerId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().removedFromConversationText(remover.getFullName(), conversationTitle));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().removedFromConversationTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.REMOVED_FROM_CONVERSATION).withReceivers(this.toReceivers(removedPersonIds)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onConversationDeleted(ConversationDeletedEvent event) {
        this._notificationThreadPool.execute(() -> {
            String conversationTitle;
            Conversation conversation = event.getConversation();
            ImmutableSet<PersonId> affectedPersonIds = event.getAffectedPersonIds();
            if (affectedPersonIds.isEmpty()) {
                return;
            }
            PersonId deletingPersonId = event.getDeletingPersonId();
            DBPerson deletingPerson = this._personService.getPersonByIdNotNull(deletingPersonId);
            if (conversation.getType() == ConversationType.MULTI_USER_CHAT) {
                String customTitle = conversation.getCustomTitle();
                conversationTitle = customTitle != null ? customTitle : "";
            } else if (affectedPersonIds.size() == 1) {
                conversationTitle = this._messageService.getConversationTitleForUser(conversation, (PersonId)affectedPersonIds.asList().get(0), this._settings.defaultLanguage(), (Map<PersonId, DBPerson>)ImmutableMap.of((Object)deletingPersonId, (Object)deletingPerson));
            } else {
                LOG.warn("More than one affected person while deleting a one-on-one conversation");
                return;
            }
            Notification notification = this.generateConversationDeletedNotification(deletingPersonId, affectedPersonIds, conversationTitle);
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateConversationDeletedNotification(PersonId deletingPersonId, ImmutableSet<PersonId> affectedPersonIds, String conversationTitle) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(deletingPersonId).getTenantId();
        CoreApp app = CoreApp.CONVERSATIONS;
        DBPerson deletingPerson = this._personService.getPersonByIdNotNull(deletingPersonId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().conversationDeletedText(deletingPerson.getFullName(), conversationTitle));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().conversationDeletedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.CONVERSATION_DELETED).withReceivers(this.toReceivers((Set<PersonId>)affectedPersonIds)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewEntityRecommendation(NewEntityRecommendationEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateEntityRecommendationNotification(event.getRecommenderId(), event.getReceiverId(), event.getEntityId(), event.getRecommendationMessage());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateEntityRecommendationNotification(PersonId recommenderId, PersonId receiverId, EntityId entityId, String recommendationMessage) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        DBPerson recommender = this._personService.getPersonById(recommenderId);
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).recommendationText(recommender.getFullName(), entityType, entity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).recommendationTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.RECOMMENDATION_NOTIFICATION).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)receiverId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(recommendationMessage).withTargetId(entityId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onTaskAssignedEvent(TaskAssignedEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateTaskAssignedNotification(event.getAssignerId(), event.getTaskId(), event.getTaskName(), event.getAssigneeId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateTaskAssignedNotification(PersonId assignerId, TaskId taskId, String taskName, PersonId assigneeId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(assignerId).getTenantId();
        DBPerson assigner = this._personService.getPersonByIdNotNull(assignerId);
        CoreApp app = CoreApp.TASKS;
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().taskAssignedText(assigner.getFullName(), taskName));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().taskAssignedTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.TASK_ASSIGNED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)assigneeId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(taskId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewRecommendationTaskAssignedEvent(RecommendationTaskAssignedEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateRecommendationTaskAssignedNotification(event.getAssignorId(), event.getTaskId(), event.getDescription(), event.getAssigneeId(), event.getEntityId());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateRecommendationTaskAssignedNotification(PersonId assignerId, TaskId taskId, String taskName, PersonId assigneeId, EntityId entityId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        DBPerson assigner = this._personService.getPersonByIdNotNull(assignerId);
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).recommendationText(assigner.getFullName(), entityType, entity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).recommendationTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.RECOMMENDATION_TASK_ASSIGNED).withReceivers(this.toReceivers((Set<PersonId>)ImmutableSet.of((Object)assigneeId))).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(taskName).withTargetId(entityId.toString()).withPayload(taskId.asString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onAddedToTaskListEvent(AddedToTaskListEvent event) {
        this._notificationThreadPool.execute(() -> {
            Notification notification = this.generateAddedToTaskListNotification(event.getExecutor(), event.getListId(), event.getListName(), (Set<PersonId>)event.getAddedPersons());
            this.dispatchNotification(notification);
        });
    }

    @Override
    @CheckForNull
    public Notification generateAddedToTaskListNotification(PersonId executorId, TaskListId listId, String listName, Set<PersonId> addedPersons) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        DBPerson executor = this._personService.getPersonByIdNotNull(executorId);
        TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(executorId).getTenantId();
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().addedToTaskListText(executor.getFullName(), listName));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().addedToTaskListTitle());
        return Notification.builder((UUID)tenantId.getId(), (String)CoreApp.TASKS.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.ADDED_TO_TASK_LIST).withReceivers(this.toReceivers(addedPersons)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(listId.toString()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewCommentEvent(CommentCreatedEvent event) {
        this._notificationThreadPool.execute(() -> {
            DBComment comment = event.getComment();
            ItemId parentId = comment.getParentId();
            CommentId commentId = comment.getId();
            PersonId authorId = comment.getAuthorId();
            DBPerson author = this._personService.getPersonByIdNotNull(authorId);
            TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(authorId).getTenantId();
            if (parentId.getType() == ItemType.DRIVE_DOCUMENT) {
                this.dispatchNotification(this.createNewCommentOnDriveDocumentNotification(tenantId, author, parentId, commentId));
            } else if (parentId.getType() == ItemType.WORKSTREAM_MESSAGE) {
                WorkstreamItem item = (WorkstreamItem)this._itemService.getById(parentId);
                if (item == null) {
                    LOG.warn("Invalid parent id {} for comment {}. Can't send notifications for new comment with incorrect parent id.", (Object)parentId, (Object)commentId);
                    return;
                }
                this.dispatchNotification(this.createNewCommentOnEntityNotification(tenantId, author, item, commentId));
                this.dispatchNotification(this.createMentionedInWorkstreamCommentNotification(tenantId, author, item, commentId, event.getMentionedPersons()));
            } else {
                LOG.warn("Unknown item type {}. Can't send new comment notification for unknown item type", (Object)parentId.getType());
            }
        });
    }

    @CheckForNull
    private Notification createNewCommentOnDriveDocumentNotification(TenantId tenantId, DBPerson author, ItemId parentId, CommentId commentId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        CoreApp app = CoreApp.DRIVE;
        DriveDocumentItem item = (DriveDocumentItem)this._itemService.getById(parentId);
        if (item == null) {
            LOG.warn("Invalid parent id {} for comment {}. Can't send new comment on drive document notification with incorrect parent id.", (Object)parentId, (Object)commentId);
            return null;
        }
        ImmutableSet<PersonId> allRecipients = this.getSubscribers(parentId, false, author.getId());
        if (allRecipients.isEmpty()) {
            return null;
        }
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().newCommentOnSubscribedDocumentText(author.getFullName(), item.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterMessages().newCommentOnSubscribedDocumentTitle(item.getName()));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.COMMENT_ON_DRIVE_SUBSCRIPTION).withReceivers(this.toReceivers((Set<PersonId>)allRecipients)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(parentId.asString()).build();
    }

    @Nonnull
    private String getMicroblogTitle(DBWorkstreamMessage message) {
        String title = message.getAttribute("title");
        if (!Strings.isNullOrEmpty((String)title)) {
            return title;
        }
        String text = message.getAttribute("text");
        assert (text != null);
        if (text.length() > 100) {
            return text.substring(0, 100);
        }
        return text;
    }

    @CheckForNull
    private Notification createNewCommentOnEntityNotification(TenantId tenantId, DBPerson author, WorkstreamItem item, CommentId commentId) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        ImmutableSet<PersonId> allRecipients = this.getSubscribers((ItemId)item.getId(), false, author.getId());
        if (allRecipients.isEmpty()) {
            return null;
        }
        DBWorkstreamMessage message = item.getMessage();
        ItemId originId = message.getOriginItemId();
        if (originId.getType() != ItemType.ENTITY) {
            LOG.warn("Invalid parent type {} for workstream item {}. Can't send new comment on entity notification with incorrect parent type.", (Object)originId.getType(), (Object)commentId);
            return null;
        }
        DBEntity entity = this._entityService.getByIdNotNull((EntityId)originId);
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).newCommentOnSubscribedWorkstreamText(author.getFullName(), entityType, entity.getName(), this.getMicroblogTitle(message)));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).newCommentOnSubscribedWorkstreamTitle(entity.getName(), this.getMicroblogTitle(message)));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION).withReceivers(this.toReceivers((Set<PersonId>)allRecipients)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(((WorkstreamMessageId)item.getId()).asString()).withPayload(app.getSimpleName()).build();
    }

    @Override
    public Notification createMentionedInWorkstreamCommentNotification(TenantId tenantId, DBPerson actor, WorkstreamItem item, CommentId commentId, ImmutableSet<PersonId> addedMentionedPersons) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        if (addedMentionedPersons.isEmpty()) {
            return null;
        }
        DBWorkstreamMessage message = item.getMessage();
        ItemId originId = message.getOriginItemId();
        if (originId.getType() != ItemType.ENTITY) {
            LOG.warn("Invalid parent type {} for workstream item {}. Can't send new comment on entity notification with incorrect parent type.", (Object)originId.getType(), (Object)commentId);
            return null;
        }
        DBEntity entity = this._entityService.getByIdNotNull((EntityId)originId);
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).mentionedInCommentOfWorkstreamText(actor.getFullName(), entityType, entity.getName(), this.getMicroblogTitle(message)));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).mentionedInCommentOfWorkstreamTitle(entity.getName(), this.getMicroblogTitle(message)));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.COMMENT_ON_WORKSTREAM_WITH_MENTION).withReceivers(this.toReceivers((Set<PersonId>)addedMentionedPersons)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(((WorkstreamMessageId)item.getId()).asString()).withPayload(app.getSimpleName()).build();
    }

    @Override
    public Notification createMentionedInMicroblogPostNotification(TenantId tenantId, DBPerson actor, WorkstreamItem item, ImmutableSet<PersonId> addedMentionedPersons) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        if (addedMentionedPersons.isEmpty()) {
            return null;
        }
        DBWorkstreamMessage message = item.getMessage();
        ItemId originId = message.getOriginItemId();
        if (originId.getType() != ItemType.ENTITY) {
            LOG.warn("Invalid parent type {} for workstream item {}. Can't send mentioned in posting notification with incorrect parent type.", (Object)originId.getType(), item.getId());
            return null;
        }
        DBEntity entity = this._entityService.getByIdNotNull((EntityId)originId);
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).mentionedInCommentOfWorkstreamText(actor.getFullName(), entityType, entity.getName(), this.getMicroblogTitle(message)));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entityType).mentionedInCommentOfWorkstreamTitle(entity.getName(), this.getMicroblogTitle(message)));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.POSTING_WITH_MENTION).withReceivers(this.toReceivers((Set<PersonId>)addedMentionedPersons)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(((WorkstreamMessageId)item.getId()).asString()).withPayload(app.getSimpleName()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onCommentUpdatedEvent(CommentUpdatedEvent event) {
        this._notificationThreadPool.execute(() -> {
            DBComment comment = event.getComment();
            ItemId parentId = comment.getParentId();
            CommentId commentId = comment.getId();
            PersonId editorId = comment.getEditorId();
            DBPerson editor = this._personService.getPersonByIdNotNull(editorId);
            TenantId tenantId = this._authorizationContextProvider.getAuthorizationContextForUser(editorId).getTenantId();
            if (parentId.getType() == ItemType.WORKSTREAM_MESSAGE) {
                WorkstreamItem item = (WorkstreamItem)this._itemService.getById(parentId);
                if (item == null) {
                    LOG.warn("Invalid parent id {} for comment {}. Can't send notifications for edited comment with incorrect parent id.", (Object)parentId, (Object)commentId);
                    return;
                }
                this.dispatchNotification(this.createMentionedInWorkstreamCommentNotification(tenantId, editor, item, commentId, event.getAddedMentionedPersons()));
            }
        });
    }

    @Nonnull
    private ImmutableSet<PersonId> getSubscribers(ItemId itemId, boolean includeInheritedSubscribers, PersonId ... excludedPersonIds) {
        PersonIndependentAuthorizationContext authCtx = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        return this.getSubscribers(authCtx, itemId, includeInheritedSubscribers, (ImmutableSet<PersonId>)ImmutableSet.copyOf((Object[])excludedPersonIds));
    }

    @Nonnull
    private ImmutableSet<PersonId> getSubscribers(PersonIndependentAuthorizationContext authCtx, ItemId itemId, boolean includeInheritedSubscribers, ImmutableSet<PersonId> excludedPersonIds) {
        return (ImmutableSet)this._likeService.getAllowedInheritedMailSubscribers(authCtx, itemId, (Set<PersonId>)excludedPersonIds).entries().stream().filter(entry -> includeInheritedSubscribers || ((Item)entry.getValue()).getId().equals(itemId)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<PersonId> getParentEntitiesSubscriberWithAllowedAction(DBEntity childEntity, Action allowedAction, PersonId ... excludedPersonIds) {
        PersonIndependentAuthorizationContext authCtx = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        ImmutableSet excludedPersonIdsSet = ImmutableSet.copyOf((Object[])excludedPersonIds);
        ImmutableSet.Builder parentEntitiesSubscribersBuilder = ImmutableSet.builder();
        for (DBEntityLink entityLink : childEntity.getLinkedEntities()) {
            EntityId parentId = entityLink.getLinkedEntityId();
            parentEntitiesSubscribersBuilder.addAll(this.getSubscribers(authCtx, parentId, false, (ImmutableSet<PersonId>)excludedPersonIdsSet));
        }
        return authCtx.groupByAllowed(childEntity.getId(), allowedAction, (Iterable<PersonId>)parentEntitiesSubscribersBuilder.build()).get((Object)Boolean.TRUE);
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onNewMicroblogPostingPublished(MicroblogPostingPublishedEvent event) {
        this._notificationThreadPool.execute(() -> {
            WorkstreamMessageId messageId = event.getWorkstreamMessageId();
            WorkstreamItem item = (WorkstreamItem)this._itemService.getById(messageId);
            if (item == null) {
                LOG.warn("Invalid workstream message id {}. Can't send new microblog posting notification with incorrect workstream message id.", (Object)messageId);
                return;
            }
            PersonId authorId = item.getMessage().getAuthorId().asPersonId();
            DBPerson author = this._personService.getPersonByIdNotNull(authorId);
            DBWorkstreamMessage message = item.getMessage();
            ItemId originId = message.getOriginItemId();
            if (originId.getType() != ItemType.ENTITY) {
                LOG.warn("Invalid parent type {} for workstream item {}. Can't send new microblog posting notification with incorrect parent type.", (Object)originId.getType(), (Object)messageId);
                return;
            }
            DBEntity entity = this._entityService.getByIdNotNull((EntityId)originId);
            TenantId tenantId = entity.getTenantId();
            CoreApp app = this._entityService.getAppForEntityType(entity.getType());
            Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
            Notification newPostingNotification = this.createNewPostingOnSubscribedEntityNotification(messageId, author, tenantId, message, entity, app, allServerLocalizedMessages);
            Notification mentionedInPostingNotification = this.createMentionedInPostingNotification(item, author, tenantId, message, entity, app, event.getMentionedPersons(), allServerLocalizedMessages);
            this.dispatchNotification(newPostingNotification);
            this.dispatchNotification(mentionedInPostingNotification);
        });
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onMicroblogPostingUpdated(MicroblogPostingUpdatedEvent event) {
        if (event.getAddedMentionedPersons().isEmpty()) {
            return;
        }
        this._notificationThreadPool.execute(() -> {
            WorkstreamMessageId messageId = event.getWorkstreamMessageId();
            WorkstreamItem item = (WorkstreamItem)this._itemService.getById(messageId);
            if (item == null) {
                LOG.warn("Invalid workstream message id {}. Can't send updated microblog posting notification with incorrect workstream message id.", (Object)messageId);
                return;
            }
            PersonId editorId = event.getEditorPersonId();
            DBWorkstreamMessage message = item.getMessage();
            ItemId originId = message.getOriginItemId();
            if (originId.getType() != ItemType.ENTITY) {
                LOG.warn("Invalid parent type {} for workstream item {}. Can't send updated microblog posting notification with incorrect parent type.", (Object)originId.getType(), (Object)messageId);
                return;
            }
            DBEntity entity = this._entityService.getByIdNotNull((EntityId)originId);
            TenantId tenantId = entity.getTenantId();
            CoreApp app = this._entityService.getAppForEntityType(entity.getType());
            Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
            Notification mentionedInPostingNotification = this.createMentionedInPostingNotification(item, this._personService.getPersonByIdNotNull(editorId), tenantId, message, entity, app, event.getAddedMentionedPersons(), allServerLocalizedMessages);
            this.dispatchNotification(mentionedInPostingNotification);
        });
    }

    @CheckForNull
    private Notification createMentionedInPostingNotification(WorkstreamItem item, DBPerson actor, TenantId tenantId, DBWorkstreamMessage message, DBEntity entity, CoreApp app, ImmutableSet<PersonId> addedMentionedPersons, Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        if (addedMentionedPersons.isEmpty()) {
            return null;
        }
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entity.getType()).mentionedInPostingText(actor.getFullName(), entity.getType(), entity.getName(), this.getMicroblogTitle(message)));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entity.getType()).mentionedInPostingTitle(entity.getName(), this.getMicroblogTitle(message)));
        Notification mentionedInPostingNotification = Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.POSTING_WITH_MENTION).withReceivers(this.toReceivers((Set<PersonId>)addedMentionedPersons)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(((WorkstreamMessageId)item.getId()).asString()).withPayload(app.getSimpleName()).build();
        return mentionedInPostingNotification;
    }

    @CheckForNull
    private Notification createNewPostingOnSubscribedEntityNotification(WorkstreamMessageId messageId, DBPerson author, TenantId tenantId, DBWorkstreamMessage message, DBEntity entity, CoreApp app, Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        ImmutableSet<PersonId> allRecipients = this.getSubscribers(messageId, true, author.getId());
        if (allRecipients.isEmpty()) {
            return null;
        }
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entity.getType()).newPostingOnSubscribedEntityText(author.getFullName(), entity.getType(), entity.getName(), this.getMicroblogTitle(message)));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, i18nMsg -> i18nMsg.notificationCenterEntityMessages(entity.getType()).newPostingOnSubscribedEntityTitle(entity.getName(), this.getMicroblogTitle(message)));
        return Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.POSTING_ON_SUBSCRIPTION).withReceivers(this.toReceivers((Set<PersonId>)allRecipients)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withTargetId(messageId.asString()).withPayload(app.getSimpleName()).build();
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionPublished(EntityVersionPublishedEvent e) {
        this._notificationThreadPool.execute(() -> {
            this.dispatchNewVersionPublishedOnSubscriptionNotification(e);
            this.dispatchNewEntityPublishedOnParentSubscriptionNotification(e);
        });
    }

    @VisibleForTesting
    void dispatchNewVersionPublishedOnSubscriptionNotification(EntityVersionPublishedEvent e) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        EntityVersion entityVersion = e.getVersion();
        if (!EntityVersionType.MAJOR.equals((Object)entityVersion.getVersionType())) {
            return;
        }
        EntityId entityId = entityVersion.getEntityId();
        DBEntity dbEntity = this._entityService.getByIdNotNull(entityId);
        PersonId authorId = entityVersion.getAuthorId();
        ImmutableSet<PersonId> allRecipients = this.getSubscribers(entityId, false, authorId);
        if (allRecipients.isEmpty()) {
            return;
        }
        TenantId tenantId = dbEntity.getTenantId();
        EntityType entityType = dbEntity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson author = this._personService.getPersonByIdNotNull(authorId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).newSubscribedEntityVersionPublishedText(author.getFullName(), entityVersion.getVersionString(), entityType, dbEntity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).newSubscribedEntityVersionPublishedTitle());
        Notification notification = Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.NEW_VERSION_PUBLISHED_ON_SUBSCRIPTION).withReceivers(this.toReceivers((Set<PersonId>)allRecipients)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(entityVersion.getChangeMessage()).withTargetId(entityId.toString()).build();
        this.dispatchNotification(notification);
    }

    @VisibleForTesting
    void dispatchNewEntityPublishedOnParentSubscriptionNotification(EntityVersionPublishedEvent e) {
        Instant eventReceivedAt = Instant.ofEpochMilli(this._clock.nowMillis());
        EntityVersion entityVersion = e.getVersion();
        if (!EntityVersionType.MAJOR.equals((Object)entityVersion.getVersionType()) || !"1.0.0".equals(entityVersion.getVersionString())) {
            return;
        }
        PersonId authorId = entityVersion.getAuthorId();
        EntityId entityId = entityVersion.getEntityId();
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        TenantId tenantId = entity.getTenantId();
        ImmutableSet<PersonId> allRecipients = this.getParentEntitiesSubscriberWithAllowedAction(entity, StaticEntityAction.ENTITY_READ_DETAILS, authorId);
        if (allRecipients.isEmpty()) {
            return;
        }
        EntityType entityType = entity.getType();
        CoreApp app = this._entityService.getAppForEntityType(entityType);
        DBPerson author = this._personService.getPersonByIdNotNull(authorId);
        Map<Locale, ServerLocalizedMessages> allServerLocalizedMessages = this.getAllServerLocalizedMessages();
        Map<Locale, String> localizedText = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).newEntityPublishedOnParentSubscriptionText(author.getFullName(), entityVersion.getVersionString(), entityType, entity.getName()));
        Map<Locale, String> localizedTitle = NotificationDispatcherImpl.getTranslations(allServerLocalizedMessages, msg -> msg.notificationCenterEntityMessages(entityType).newEntityPublishedOnParentSubscriptionTitle(entity.getName()));
        Notification notification = Notification.builder((UUID)tenantId.getId(), (String)app.getAppId().getId(), (String)this.getDefaultTranslation(localizedTitle), (String)this.getDefaultTranslation(localizedText), (NotificationType)NotificationType.NEW_ENTITY_PUBLISHED_ON_PARENT_SUBSCRIPTION).withReceivers(this.toReceivers((Set<PersonId>)allRecipients)).withTimestamp(eventReceivedAt).withLocalizedText(localizedText).withLocalizedTitle(localizedTitle).withDefaultSecondaryText(entityVersion.getChangeMessage()).withTargetId(entityId.toString()).build();
        this.dispatchNotification(notification);
    }

    private void dispatchNotification(@Nullable Notification notification) {
        if (notification == null) {
            return;
        }
        try {
            this._notificationProducer.dispatchNotification(notification);
        }
        catch (AssertionError e) {
            LOG.warn("Malformed notification '{}'. Notification couldn't be dispatched.", (Object)notification);
        }
    }

    @PreDestroy
    public void onShutdown() {
        this._notificationThreadPool.shutdown();
        try {
            if (!this._notificationThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                this._notificationThreadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this._notificationThreadPool.shutdownNow();
        }
    }
}

