/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notificationpush.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import de.justsoftware.mobilepush.PushNotificationSerde;
import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.push.business.PushNotificationSendService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationPushKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationPushKafkaConsumer.class);
    private final PushNotificationSendService _pushNotificationSendService;

    @Autowired
    public NotificationPushKafkaConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, PushNotificationSendService pushNotificationSendService) {
        super(kafkaConfigurationProvider.stringConsumer("just.toro.NotificationPushKafkaConsumer"), transactionHelper, "just.notification.push");
        this._pushNotificationSendService = pushNotificationSendService;
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        this.process(records);
    }

    private boolean isProcessableRecord(ConsumerRecord<String, String> record) {
        String key = (String)record.key();
        String value = (String)record.value();
        Instant oneHourAgo = Instant.now().minus(1L, ChronoUnit.HOURS);
        if (record.timestamp() < oneHourAgo.toEpochMilli()) {
            LOGGER.info("Skipped push notification record older than one hour.\nKey: {} and value: {}", (Object)key, (Object)value);
            return false;
        }
        if (key == null || value == null) {
            LOGGER.warn("Skipped push notification record in kafka with null key or value.\nKey: {} and value: {}", (Object)key, (Object)value);
            return false;
        }
        if (!key.startsWith("NOTIFICATION-PUSH,")) {
            LOGGER.warn("Skipped unsupported push notification key.\nKey: {} and value: {}", (Object)key, (Object)value);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void process(ConsumerRecords<String, String> records) {
        Deserializer deserializer = PushNotificationSerde.INSTANCE.deserializer();
        for (ConsumerRecord record : records) {
            if (!this.isProcessableRecord((ConsumerRecord<String, String>)record)) continue;
            try {
                PushNotification pushNotification = (PushNotification)deserializer.deserialize("just.notification.push", ((String)record.value()).getBytes(Charsets.UTF_8));
                this._pushNotificationSendService.sendNotificationsPushNotification(pushNotification);
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to send notification push.\nKey: " + (String)record.key() + " and value: " + (String)record.value(), (Throwable)e);
            }
        }
    }
}

