/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.notificationpush.business.impl;

import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.notificationpush.business.impl.AbstractFactoryDelegate;
import de.justsoftware.onx.notificationpush.i18n.NotificationPushMessages;
import de.justsoftware.onx.push.model.PushNotificationField;
import de.justsoftware.onx.push.util.FcmPushNotifications;
import de.justsoftware.pushnotification.client.model.FcmPushNotification;
import de.justsoftware.pushnotification.client.model.PushNotificationApp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class FcmFactoryDelegate
extends AbstractFactoryDelegate {
    private final I18nService _i18nService;

    FcmFactoryDelegate(I18nService i18nService, JucoObjectMapper objectMapper) {
        super(objectMapper);
        this._i18nService = i18nService;
    }

    @Nonnull
    FcmPushNotification pushNotification(PushNotification mobilePush, PushNotificationApp app, String token, int unreadCount, Locale locale) {
        return FcmPushNotifications.pushNotification(token, app, NOTIFICATION_TYPE, this.title(mobilePush, locale), this.text(mobilePush, locale), unreadCount, this.payloadData(mobilePush, unreadCount, locale));
    }

    @CheckForNull
    private Map<String, String> payloadData(PushNotification mobilePush, int unreadCount, Locale locale) {
        String destination;
        HashMap<String, String> result = new HashMap<String, String>();
        if (unreadCount > 1) {
            result.put(PushNotificationField.SUMMARY_TEXT.getFieldName(), this.moreNotificationsHint(unreadCount, locale));
        }
        if ((destination = this.destination(mobilePush)) != null) {
            result.put(PushNotificationField.SOCIAL_DESTINATION.getFieldName(), destination);
            result.put(PushNotificationField.SOCIAL_APP_ID.getFieldName(), mobilePush.getAppId());
        }
        return !result.isEmpty() ? Collections.unmodifiableMap(result) : null;
    }

    @Nonnull
    private String moreNotificationsHint(int unreadCount, Locale locale) {
        NotificationPushMessages i18n = this._i18nService.getLocalizedMessages(locale.getLanguage()).notificationPushMessages();
        int moreCount = unreadCount - 1;
        return moreCount == 1 ? i18n.oneMoreNotification() : i18n.moreNotifications(moreCount);
    }
}

