/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.integration.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSectionCreateModel;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NewsZoomSectionCreateDAOModel {
    private final SectionId _sectionId;
    private final boolean _showOnlyPinned;
    private final String _name;
    private final int _order;

    public NewsZoomSectionCreateDAOModel(String name, boolean showOnlyPinned, int order) {
        this._showOnlyPinned = showOnlyPinned;
        this._sectionId = SectionId.random();
        this._name = name;
        this._order = order;
    }

    @Nonnull
    public static NewsZoomSectionCreateDAOModel from(NewsZoomSectionCreateModel section) {
        return new NewsZoomSectionCreateDAOModel(section.getName(), section.isShowOnlyPinned(), section.getOrder());
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public int getOrder() {
        return this._order;
    }

    @Nonnull
    public SectionId getSectionId() {
        return this._sectionId;
    }

    public boolean isShowOnlyPinned() {
        return this._showOnlyPinned;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sectionId", (Object)this._sectionId).add("name", (Object)this._name).add("order", this._order).add("showOnlyPinned", this._showOnlyPinned).toString();
    }
}

