/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.integration.persistence.mapper;

import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.news.migration.newscover.NewsZoomSettingsMigration;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSection;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSettings;
import de.justsoftware.onx.newszoom.shared.model.OpenOn;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@Mapper
@ParametersAreNonnullByDefault
public interface NewsZoomSettingsMapper {
    @ConstructorArgs(value={@Arg(javaType=boolean.class, column="cycle_automatically"), @Arg(javaType=OpenOn.class, column="open_on"), @Arg(javaType=int.class, column="cycle_delay_in_seconds")})
    @Select(value={"SELECT cycle_automatically, open_on, cycle_delay_in_seconds", "FROM newszoom_config", "WHERE tenant_id = #{tenantId}"})
    @ResultType(value=NewsZoomSettings.class)
    @CheckForNull
    public NewsZoomSettings getNewsZoomSettings(@Param(value="tenantId") TenantId var1);

    @ConstructorArgs(value={@Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=boolean.class, column="cycle_automatically"), @Arg(javaType=OpenOn.class, column="open_on"), @Arg(javaType=int.class, column="cycle_delay_in_seconds")})
    @Select(value={"SELECT tenant_id, cycle_automatically, open_on, cycle_delay_in_seconds", "FROM newszoom_config"})
    @ResultType(value=NewsZoomSettingsMigration.class)
    public Set<NewsZoomSettingsMigration> getAllNewsZoomSettings();

    @Update(value={"<script>", "<if test=\"_databaseId == 'ORACLE'\">", "MERGE INTO newszoom_config c", "USING (SELECT 1 FROM DUAL) d", "ON ( c.tenant_id = #{tenantId})", "WHEN MATCHED THEN", " UPDATE SET cycle_automatically = #{cycleAutomatically}, open_on = #{openOn}, cycle_delay_in_seconds = #{cycleDelayInSeconds}", "WHEN NOT MATCHED THEN", "  INSERT (tenant_id, cycle_automatically, open_on, cycle_delay_in_seconds)", "  VALUES (#{tenantId}, #{cycleAutomatically}, #{openOn}, #{cycleDelayInSeconds})", "</if>", "<if test=\"_databaseId == 'POSTGRES'\">", "INSERT INTO newszoom_config (tenant_id, cycle_automatically, open_on, cycle_delay_in_seconds)", "VALUES (#{tenantId}, #{cycleAutomatically}, #{openOn}, #{cycleDelayInSeconds})", "ON CONFLICT ON CONSTRAINT newszoom_config_pkey", "DO UPDATE SET cycle_automatically = #{cycleAutomatically}, open_on = #{openOn}, cycle_delay_in_seconds = #{cycleDelayInSeconds}", "</if>", "</script>"})
    public void updateNewsZoomSettings(@Param(value="tenantId") TenantId var1, @Param(value="cycleAutomatically") boolean var2, @Param(value="openOn") OpenOn var3, @Param(value="cycleDelayInSeconds") int var4);

    @ConstructorArgs(value={@Arg(javaType=SectionId.class, column="id", id=true), @Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=String.class, column="name"), @Arg(javaType=boolean.class, column="show_only_pinned"), @Arg(javaType=int.class, column="order_index")})
    @Select(value={"SELECT id, tenant_id, name, order_index, show_only_pinned", "FROM newszoom_section", "WHERE tenant_id=#{tenantId}"})
    @Nonnull
    public Set<NewsZoomSection> getNewsZoomSections(@Param(value="tenantId") TenantId var1);

    @Select(value={"<script>", "SELECT section_id, channel_id", "FROM newszoom_section_channel", "WHERE section_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="section_id", property="key", javaType=SectionId.class), @Result(column="channel_id", property="value", javaType=ItemId.class)})
    @ResultType(value=Map.class)
    public void getChannelsForSections(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<SectionId> var2);

    @Update(value={"UPDATE newszoom_section", "SET name =#{name},", "show_only_pinned =#{showOnlyPinned},", "order_index=#{order}", "WHERE id=#{sectionId}", "AND tenant_id=#{tenantId}"})
    public void updateSection(@Param(value="sectionId") SectionId var1, @Param(value="tenantId") TenantId var2, @Param(value="name") String var3, @Param(value="showOnlyPinned") boolean var4, @Param(value="order") int var5);

    @Insert(value={"INSERT INTO newszoom_section (id, tenant_id, name, show_only_pinned, order_index) ", "VALUES (#{sectionId}, #{tenantId}, #{name}, #{showOnlyPinned}, #{order})"})
    public void addSection(@Param(value="sectionId") SectionId var1, @Param(value="tenantId") TenantId var2, @Param(value="name") String var3, @Param(value="showOnlyPinned") boolean var4, @Param(value="order") int var5);

    @Insert(value={"<script>", "INSERT INTO newszoom_section_channel(section_id, channel_id)", " SELECT #{sectionId}, #{channelId}", "   <if test=\"_databaseId == 'ORACLE'\">FROM dual</if>", "   WHERE NOT EXISTS (", "       SELECT 1 FROM newszoom_section_channel WHERE section_id = #{sectionId} and channel_id = #{channelId})", "</script>"})
    public void addChannelToSection(@Param(value="sectionId") SectionId var1, @Param(value="channelId") ItemId var2);

    @Delete(value={"DELETE FROM newszoom_section_channel WHERE section_id = #{sectionId}"})
    public void removeChannelsFromSection(@Param(value="sectionId") SectionId var1);

    @Delete(value={"<script>", "DELETE FROM newszoom_section WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", " AND tenant_id=#{tenantId}", "</script>"})
    public void deleteSections(@Param(value="ids") List<SectionId> var1, @Param(value="tenantId") TenantId var2);
}

