/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.business.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.newszoom.business.model.NewsZoomSectionBO;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSettings;
import de.justsoftware.onx.newszoom.shared.model.OpenOn;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NewsZoomSettingsBO {
    private final boolean _cycleAutomatically;
    private final OpenOn _openOn;
    private final ImmutableList<NewsZoomSectionBO> _newsZoomSections;
    private final int _cycleDelayInSeconds;

    public NewsZoomSettingsBO(boolean cycleAutomatically, OpenOn openOn, int cycleDelayInSeconds, ImmutableList<NewsZoomSectionBO> newsZoomSections) {
        this._cycleAutomatically = cycleAutomatically;
        this._openOn = openOn;
        this._newsZoomSections = newsZoomSections;
        this._cycleDelayInSeconds = cycleDelayInSeconds;
    }

    @Nonnull
    public static NewsZoomSettingsBO from(NewsZoomSettings settings, ImmutableList<NewsZoomSectionBO> sectionList) {
        return new NewsZoomSettingsBO(settings.isCycleAutomatically(), settings.getOpenOn(), settings.getCycleTimeInSeconds(), sectionList);
    }

    @Nonnull
    public OpenOn getOpenOn() {
        return this._openOn;
    }

    public long getCycleDelayInSeconds() {
        return this._cycleDelayInSeconds;
    }

    public boolean isCycleAutomatically() {
        return this._cycleAutomatically;
    }

    @Nonnull
    public ImmutableList<NewsZoomSectionBO> getNewsZoomSections() {
        return this._newsZoomSections;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cycleAutomatically", this._cycleAutomatically).add("openOn", (Object)this._openOn).add("cycleDelayInSeconds", this._cycleDelayInSeconds).add("newsZoomSections", this._newsZoomSections).toString();
    }
}

