/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.newszoom.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.newszoom.business.NewsZoomSettingsService;
import de.justsoftware.onx.newszoom.business.model.NewsZoomSectionBO;
import de.justsoftware.onx.newszoom.business.model.NewsZoomSettingsBO;
import de.justsoftware.onx.newszoom.integration.persistence.NewsZoomSettingsDAO;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSection;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSectionCreateDAOModel;
import de.justsoftware.onx.newszoom.integration.persistence.model.NewsZoomSettings;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSectionCreateModel;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSectionEditModel;
import de.justsoftware.onx.newszoom.shared.model.NewsZoomSettingsEditModel;
import de.justsoftware.onx.newszoom.shared.model.OpenOn;
import de.justsoftware.onx.newszoom.shared.model.SectionId;
import de.justsoftware.onx.workstream.shared.model.FeedId;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NewsZoomSettingsServiceImpl
implements NewsZoomSettingsService {
    private static final int MINIMUM_CYCLE_DELAY_IN_S = 8;
    private static final int DEFAULT_CYCLE_DELAY_IN_S = 8;
    private static final int MAXIMUM_CYCLE_DELAY_IN_S = 45;
    private static final String TEMP_SECTION_DEFAULT_NAME = "TEMP-SECTION_DEFAULT-NAME";
    private static final ImmutableList<NewsZoomSectionBO> DEFAULT_SECTION = ImmutableList.of((Object)new NewsZoomSectionBO(null, "TEMP-SECTION_DEFAULT-NAME", false, 0, (ImmutableSet<ItemId>)ImmutableSet.of((Object)new FeedId(CoreApp.NEWS.getAppId()))));
    private static final NewsZoomSettingsBO DEFAULT_NEWS_ZOOM_SETTINGS = new NewsZoomSettingsBO(true, OpenOn.LOGIN, 8, DEFAULT_SECTION);
    private final NewsZoomSettingsDAO _newsZoomSettingsDAO;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public NewsZoomSettingsServiceImpl(TransactionHelper transactionHelper, NewsZoomSettingsDAO newsZoomSettingsDAO) {
        this._transactionHelper = transactionHelper;
        this._newsZoomSettingsDAO = newsZoomSettingsDAO;
    }

    @Override
    public NewsZoomSettingsBO getNewsZoomSettings(AuthorizationCheckContextWithUserId authContext) {
        TenantId tenantId = authContext.getOptionalTenantId().orElse(null);
        if (tenantId == null) {
            return null;
        }
        NewsZoomSettings newsZoomSettings = this._newsZoomSettingsDAO.getNewsZoomSettings(tenantId);
        if (newsZoomSettings == null) {
            return DEFAULT_NEWS_ZOOM_SETTINGS;
        }
        ImmutableList<NewsZoomSection> newsZoomSections = this._newsZoomSettingsDAO.getNewsZoomSections(tenantId);
        if (newsZoomSections.isEmpty()) {
            return NewsZoomSettingsBO.from(newsZoomSettings, DEFAULT_SECTION);
        }
        ImmutableSetMultimap<SectionId, ItemId> channelsForSections = this._newsZoomSettingsDAO.getChannelsForSections((Set)newsZoomSections.stream().map(NewsZoomSection::getSectionId).collect(ImmutableSet.toImmutableSet()));
        ImmutableList sections = (ImmutableList)newsZoomSections.stream().map(newsZoomSection -> this.getNewsZoomSectionBO(channelsForSections, (NewsZoomSection)newsZoomSection)).collect(ImmutableList.toImmutableList());
        return NewsZoomSettingsBO.from(newsZoomSettings, (ImmutableList<NewsZoomSectionBO>)sections);
    }

    @Override
    public void updateNewsZoomSections(AuthorizationCheckContextWithUserId authContext, List<NewsZoomSectionEditModel> sectionsToUpdate, List<NewsZoomSectionCreateModel> sectionsToAdd, Set<SectionId> sectionsToDelete) {
        TenantId tenantId = authContext.getTenantId();
        authContext.check((ItemId)tenantId, (Action)StaticPermissionAction.MANAGE);
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._newsZoomSettingsDAO.deleteNewsZoomSections(sectionsToDelete, tenantId);
            sectionsToUpdate.forEach(section -> {
                this._newsZoomSettingsDAO.updateNewsZoomSection(new NewsZoomSection(tenantId, (NewsZoomSectionEditModel)section));
                this._newsZoomSettingsDAO.setNewsZoomSectionChannels(section.getId(), (Set<ItemId>)section.getChannelIdsToAdd());
            });
            sectionsToAdd.forEach(section -> {
                SectionId createdSectionId = this._newsZoomSettingsDAO.addNewsZoomSection(tenantId, NewsZoomSectionCreateDAOModel.from(section));
                this._newsZoomSettingsDAO.setNewsZoomSectionChannels(createdSectionId, (Set<ItemId>)section.getChannelIdsToAdd());
            });
        });
    }

    @Override
    public void updateNewsZoomSettings(AuthorizationCheckContextWithUserId authContext, NewsZoomSettingsEditModel settings) {
        authContext.check((ItemId)authContext.getTenantId(), (Action)StaticPermissionAction.MANAGE);
        if (settings.getCycleDelayInSeconds() < 8) {
            throw new IllegalArgumentException("Minimum cycle delay is 8. Received: " + settings.getCycleDelayInSeconds());
        }
        if (settings.getCycleDelayInSeconds() > 45) {
            throw new IllegalArgumentException("Maximum cycle delay is 45. Received: " + settings.getCycleDelayInSeconds());
        }
        this._newsZoomSettingsDAO.updateNewsZoomSettings(authContext.getTenantId(), settings);
    }

    @Nonnull
    private NewsZoomSectionBO getNewsZoomSectionBO(ImmutableSetMultimap<SectionId, ItemId> channelsForSections, NewsZoomSection newsZoomSection) {
        return new NewsZoomSectionBO(newsZoomSection.getSectionId(), newsZoomSection.getName(), newsZoomSection.isShowOnlyPinned(), newsZoomSection.getOrder(), (ImmutableSet<ItemId>)channelsForSections.get((Object)newsZoomSection.getSectionId()));
    }
}

