/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.post;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.drive.business.model.DriveDocumentItem;
import de.justsoftware.onx.drive.business.model.DriveDocumentPublicity;
import de.justsoftware.onx.drive.integration.persistence.DriveDocumentItemDAO;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.news.migration.NewsMigrationDAO;
import de.justsoftware.onx.news.migration.post.PostAttachmentKafkaDto;
import de.justsoftware.onx.news.migration.post.PostCommentKafkaDto;
import de.justsoftware.onx.news.migration.post.PostKafkaDto;
import de.justsoftware.onx.news.migration.post.PostPollAnswerKafkaDto;
import de.justsoftware.onx.news.migration.post.PostPollAnswerVoteKafkaDto;
import de.justsoftware.onx.news.migration.post.PostPollKafkaDto;
import de.justsoftware.onx.news.migration.post.PostReactionKafkaDto;
import de.justsoftware.onx.workstream.integration.persistence.ScheduledWorkstreamMessageDAO;
import de.justsoftware.onx.workstream.integration.persistence.WorkstreamDAO;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.polls.model.Poll;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PostMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(PostMigrationService.class);
    private static final String POST = "POST,";
    private static final String CHANNEL = "CHANNEL,";
    private static final String PROFILE = "PROFILE,";
    private static final String DRIVE_DOCUMENT = "DRIVE_DOCUMENT,";
    private static final String DOCUMENT = "DOCUMENT,";
    @VisibleForTesting
    Producer<String, String> _producer;
    private final DriveDocumentItemDAO _documentDAO;
    private final MigratedItemDAO _migratedItemDAO;
    private final WorkstreamDAO _workstreamDAO;
    private final NewsMigrationDAO _newsMigrationDAO;
    private final ScheduledWorkstreamMessageDAO _scheduledWorkstreamMessageDAO;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public PostMigrationService(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, DriveDocumentItemDAO documentDAO, MigratedItemDAO migratedItemDAO, WorkstreamDAO workstreamDAO, NewsMigrationDAO newsMigrationDAO, ScheduledWorkstreamMessageDAO scheduledWorkstreamMessageDAO, TransactionHelper transactionHelper) {
        this._producer = producer;
        this._documentDAO = documentDAO;
        this._migratedItemDAO = migratedItemDAO;
        this._workstreamDAO = workstreamDAO;
        this._newsMigrationDAO = newsMigrationDAO;
        this._scheduledWorkstreamMessageDAO = scheduledWorkstreamMessageDAO;
        this._transactionHelper = transactionHelper;
    }

    public void migratePosts() {
        if (this._producer == null) {
            LOG.warn("Abort migratePosts because _producer is null!");
            return;
        }
        ImmutableMap<ItemId, ItemId> migratedChannels = this._newsMigrationDAO.getAllMigratedItems("CHANNEL,%");
        ImmutableSet migratedWorkstreamMessageIds = this._newsMigrationDAO.getAllMigratedItems("POST,%").keySet();
        migratedChannels.forEach((channelIdOld, channelIdNew) -> this.migratePostsFromChannel((ImmutableSet<ItemId>)migratedWorkstreamMessageIds, (ItemId)channelIdOld, (ItemId)channelIdNew));
    }

    private void migratePostsFromChannel(ImmutableSet<ItemId> migratedWorkstreamMessageIds, ItemId channelIdOld, ItemId channelIdNew) {
        ImmutableSet<WorkstreamMessageId> channelPostIds = this._newsMigrationDAO.getAllWorkstreamMessageIdsByOrigins(Collections.singleton(channelIdOld));
        this._newsMigrationDAO.getEntriesOfTypeMicroblogPosting(channelPostIds.stream().filter(id -> !migratedWorkstreamMessageIds.contains(id)).collect(Collectors.toSet())).forEach((workstreamMessageId, workstreamMessage) -> this.migratePost(channelIdNew, (WorkstreamMessageId)workstreamMessageId, (DBWorkstreamMessage)workstreamMessage));
    }

    private void migratePost(ItemId channelIdNew, WorkstreamMessageId workstreamMessageId, DBWorkstreamMessage workstreamMessage) {
        this._transactionHelper.doInTransactionWithoutResult(t -> {
            PostKafkaDto post = this.buildPost(channelIdNew, workstreamMessage);
            this._migratedItemDAO.insertMigrations(Map.of(workstreamMessageId, new NewsPostId(post.getId().split(POST)[1])));
            this.publishToKafka(post);
        });
    }

    @Nonnull
    private PostKafkaDto buildPost(ItemId channelId, DBWorkstreamMessage workstreamMessage) {
        String postIdGenerated = POST + NanoIdUtils.randomNanoId((Random)NanoIdUtils.DEFAULT_NUMBER_GENERATOR, (char[])NanoIdUtils.DEFAULT_ALPHABET, (int)8);
        String nullableTitle = workstreamMessage.getAttribute("title");
        String title = nullableTitle != null ? nullableTitle : "Kein Titel - No title";
        String nullableText = workstreamMessage.getAttribute("text");
        String text = nullableText != null ? nullableText : "Kein Text - No text";
        String nullableJsonContent = workstreamMessage.getAttribute("quill_delta");
        String jsonContent = nullableJsonContent != null ? nullableJsonContent : "{}";
        Instant pinDate = workstreamMessage.getPinDate() != null ? workstreamMessage.getPinDate().toInstant() : null;
        Instant publishDate = this.getPublishDate(workstreamMessage);
        Set<PostAttachmentKafkaDto> attachments = this.collectDriveDocumentAttachments(workstreamMessage.getId());
        String coverElementId = attachments.stream().filter(a -> a.getPosition() == 0).findFirst().map(PostAttachmentKafkaDto::getId).orElse(null);
        PostPollKafkaDto poll = this.collectPoll(workstreamMessage.getId());
        ImmutableMap<CommentId, DBComment> comments = this._newsMigrationDAO.getCommentsByItemId(workstreamMessage.getId());
        Set<PostCommentKafkaDto> postComments = comments.values().stream().map(c -> new PostCommentKafkaDto(c.getAuthorId().asProfileId().asString(), c.getEditorModel(), c.getText(), c.getId(), c.getPostedAt().toInstant(), c.getEditedAt() != null ? c.getEditedAt().toInstant() : null, c.getEditorId() != null ? c.getEditorId().asProfileId().asString() : null)).collect(Collectors.toSet());
        Set<PostReactionKafkaDto> reactions = this.collectReactions(postIdGenerated, postComments, workstreamMessage.getId());
        return new PostKafkaDto(postIdGenerated, workstreamMessage.getId().asString(), workstreamMessage.getAuthorId().asString(), channelId.asString(), workstreamMessage.getCreateDate().toInstant(), workstreamMessage.getModifyDate().toInstant(), title, text, jsonContent, coverElementId, workstreamMessage.isPinned(), pinDate, workstreamMessage.isPublished(), publishDate, attachments, reactions, poll, postComments);
    }

    private Instant getPublishDate(DBWorkstreamMessage workstreamMessage) {
        if (workstreamMessage.getPublishDate() != null) {
            return workstreamMessage.getPublishDate().toInstant();
        }
        ImmutableMap<WorkstreamMessageId, Date> scheduledPublishDate = this._scheduledWorkstreamMessageDAO.getScheduledWorkstreamMessagesByIds(Set.of(workstreamMessage.getId()));
        Date date = (Date)scheduledPublishDate.get((Object)workstreamMessage.getId());
        if (date == null) {
            LOG.warn("workstreamMessage {} is scheduled to be published, but the publish date is missing.", (Object)workstreamMessage.getId());
            return workstreamMessage.getCreateDate().toInstant();
        }
        return date.toInstant();
    }

    private Set<PostReactionKafkaDto> collectReactions(String postIdGenerated, Set<PostCommentKafkaDto> postComments, WorkstreamMessageId workstreamMessageId) {
        ImmutableSet<PersonId> postLikers = this._newsMigrationDAO.getLikesByItemId(workstreamMessageId);
        Set<PostReactionKafkaDto> reactions = postLikers.stream().map(l -> new PostReactionKafkaDto(postIdGenerated, PROFILE + l.getId())).collect(Collectors.toSet());
        Map<String, Set> commentLikers = postComments.stream().collect(Collectors.toMap(PostCommentKafkaDto::getId, comment -> this._newsMigrationDAO.getLikesByItemId(Objects.requireNonNull(ItemId.parse(comment.getCommentId().asString())))));
        commentLikers.values().removeIf(cl -> cl == null || cl.isEmpty());
        commentLikers.forEach((key, values) -> values.forEach(value -> reactions.add(new PostReactionKafkaDto((String)key, PROFILE + value.getId()))));
        return reactions;
    }

    private Set<PostAttachmentKafkaDto> collectDriveDocumentAttachments(WorkstreamMessageId workstreamMessageId) {
        Set dbAttachments = this._workstreamDAO.getAttachments(workstreamMessageId).stream().filter(dBAttachment -> dBAttachment.getItemId().asString().startsWith(DRIVE_DOCUMENT)).collect(Collectors.toSet());
        Set<DriveDocumentId> documentIds = dbAttachments.stream().map(dBAttachment -> (DriveDocumentId)dBAttachment.getItemId()).collect(Collectors.toSet());
        ImmutableMap<DriveDocumentId, DriveDocumentItem> docs = this._documentDAO.getByIds(DriveDocumentPublicity.PUBLIC, documentIds);
        return dbAttachments.stream().map(dBAttachment -> {
            DriveDocumentId itemId = (DriveDocumentId)dBAttachment.getItemId();
            return new PostAttachmentKafkaDto(DOCUMENT + Objects.requireNonNull(itemId.getId()), dBAttachment.getPosition(), ((DriveDocumentItem)docs.get((Object)itemId)).getMimeType(), ((DriveDocumentItem)docs.get((Object)itemId)).getName(), ((DriveDocumentItem)docs.get((Object)itemId)).getFileSize());
        }).collect(Collectors.toSet());
    }

    @Nullable
    private PostPollKafkaDto collectPoll(WorkstreamMessageId workstreamMessageId) {
        Optional<Poll> pollOptional = this._newsMigrationDAO.findPollByWorkstreamMessageId(workstreamMessageId);
        if (pollOptional.isEmpty()) {
            return null;
        }
        Poll poll = pollOptional.get();
        Set<PostPollAnswerKafkaDto> answers = poll.getAnswers().stream().map(answer -> new PostPollAnswerKafkaDto(answer.getText(), answer.getPosition(), answer.getVotes().stream().map(vote -> new PostPollAnswerVoteKafkaDto(vote.asString())).collect(Collectors.toSet()))).collect(Collectors.toSet());
        return new PostPollKafkaDto(poll.getId().asString(), poll.getQuestion(), poll.isAllowMultipleAnswers(), answers);
    }

    private void publishToKafka(PostKafkaDto post) {
        if (this._producer == null) {
            return;
        }
        this._producer.send(new ProducerRecord("just.toro.migration.news", (Object)post.getId(), (Object)post.toTopicJson()));
    }
}

