/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration.channel;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.LikeDAO;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.migration.integration.persistence.MigratedItemDAO;
import de.justsoftware.onx.news.migration.NewsMigrationDAO;
import de.justsoftware.onx.news.migration.channel.ChannelKafkaDto;
import de.justsoftware.onx.news.migration.channel.ChannelMigrationDAO;
import de.justsoftware.onx.news.migration.channel.ChannelPermissionKafkaDto;
import de.justsoftware.onx.news.migration.channel.ChannelSubscriptionKafkaDto;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.usergroup.model.UserGroup;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
@ParametersAreNonnullByDefault
public class ChannelMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelMigrationService.class);
    private static final String MANAGER = "MANAGER";
    private static final String WRITER = "WRITER";
    private static final String READER = "READER";
    private final Producer<String, String> _producer;
    private final ChannelMigrationDAO _migrationDao;
    private final LikeDAO _likeDao;
    private final MigratedItemDAO _migratedItemDao;
    private final NewsMigrationDAO _newsMigrationDao;
    private final UserGroupService _userGroupService;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public ChannelMigrationService(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, ChannelMigrationDAO migrationDao, LikeDAO likeDao, MigratedItemDAO migratedItemDao, NewsMigrationDAO newsMigrationDao, UserGroupService userGroupService, TransactionHelper transactionHelper) {
        this._producer = producer;
        this._migrationDao = migrationDao;
        this._likeDao = likeDao;
        this._migratedItemDao = migratedItemDao;
        this._newsMigrationDao = newsMigrationDao;
        this._userGroupService = userGroupService;
        this._transactionHelper = transactionHelper;
    }

    public void migrateChannels() {
        if (this._producer == null) {
            LOG.warn("Abort migrateChannels because _producer is null!");
            return;
        }
        ImmutableMap<EntityId, DBEntity> channelEntities = this._migrationDao.getAllChannels();
        Set<EntityId> entitiesWhereAllMembersWriter = this._migrationDao.getAllWhereTenantMembersAreWriter();
        Set<EntityId> entitiesWhereAllMembersReader = this._migrationDao.getAllWhereTenantMembersAreReaders();
        ImmutableSet migratedChannels = this._migratedItemDao.getMigrationsByIds(channelEntities.keySet()).keySet();
        for (DBEntity channelEntity : channelEntities.values()) {
            this._transactionHelper.doInTransactionWithoutResult(arg_0 -> this.lambda$migrateChannels$0(entitiesWhereAllMembersWriter, entitiesWhereAllMembersReader, (Set)migratedChannels, channelEntity, arg_0));
        }
    }

    private void migrateChannel(Set<EntityId> entitiesWhereAllMembersWriter, Set<EntityId> entitiesWhereAllMembersReader, Set<EntityId> migratedChannels, DBEntity channelEntity) {
        if (migratedChannels.contains(channelEntity.getId())) {
            LOG.info("Skipping migration. Entity {} already migrated.", (Object)channelEntity.getId());
            return;
        }
        String channelIdGenerated = "CHANNEL," + NanoIdUtils.randomNanoId((Random)NanoIdUtils.DEFAULT_NUMBER_GENERATOR, (char[])NanoIdUtils.DEFAULT_ALPHABET, (int)4);
        List<ChannelPermissionKafkaDto> permissions = this.getPermissions(channelEntity, entitiesWhereAllMembersWriter, entitiesWhereAllMembersReader);
        List<ChannelSubscriptionKafkaDto> subscriptions = this.getSubscribers(channelEntity);
        this._migratedItemDao.insertMigrations(Map.of(channelEntity.getId(), new NewsChannelId(channelIdGenerated.split("CHANNEL,")[1])));
        this.publishToKafka(new ChannelKafkaDto(channelIdGenerated, channelEntity.getId().asString(), channelEntity.getTenantId(), channelEntity.getName(), channelEntity.getCreateDate().toInstant(), channelEntity.getModifyDate().toInstant(), permissions, subscriptions));
    }

    @Nonnull
    private List<ChannelPermissionKafkaDto> getPermissions(DBEntity channelEntity, Set<EntityId> entitiesWhereAllMembersWriter, Set<EntityId> entitiesWhereAllMembersReader) {
        List<ChannelPermissionKafkaDto> permissions = this.convertToPermissionKafkaDto(this._migrationDao.getAllChannelAdmins(channelEntity.getId()), MANAGER);
        if (entitiesWhereAllMembersWriter.contains(channelEntity.getId())) {
            UserGroup allUsersGroup = this._userGroupService.getAllUsersGroup(channelEntity.getTenantId());
            if (allUsersGroup == null) {
                throw new NoSuchElementException("Missing allUsersGroup for tenantId: " + channelEntity.getTenantId());
            }
            ChannelPermissionKafkaDto allUserGroupWriter = new ChannelPermissionKafkaDto(allUsersGroup.getGroupId().toString(), WRITER);
            permissions.add(allUserGroupWriter);
        } else if (entitiesWhereAllMembersReader.contains(channelEntity.getId())) {
            UserGroup allUsersGroup = this._userGroupService.getAllUsersGroup(channelEntity.getTenantId());
            if (allUsersGroup == null) {
                throw new NoSuchElementException("Missing allUsersGroup for tenantId: " + channelEntity.getTenantId());
            }
            ChannelPermissionKafkaDto allUserGroupReader = new ChannelPermissionKafkaDto(allUsersGroup.getGroupId().toString(), READER);
            permissions.add(allUserGroupReader);
            permissions.addAll(this.convertToPermissionKafkaDto(this._migrationDao.getAllChannelWriters(channelEntity.getId()), WRITER));
        } else {
            permissions.addAll(this.convertToPermissionKafkaDto(this._migrationDao.getAllChannelWriters(channelEntity.getId()), WRITER));
            permissions.addAll(this.convertToPermissionKafkaDto(this._migrationDao.getAllChannelReaders(channelEntity.getId()), READER));
        }
        return permissions;
    }

    @Nonnull
    private List<ChannelSubscriptionKafkaDto> getSubscribers(DBEntity channelEntity) {
        ImmutableList<SubscriptionModel> subscribers = this._newsMigrationDao.getSubscribers(Set.of(channelEntity.getId()));
        return subscribers.stream().map(subscriber -> {
            String id = "PERSONAL_SUBSCRIPTION," + UUID.randomUUID();
            return new ChannelSubscriptionKafkaDto(id, "PROFILE," + subscriber.getSubscriberId(), subscriber.getState() == SubscriptionState.SUBSCRIBED, subscriber.getState() == SubscriptionState.UNSUBSCRIBED);
        }).collect(Collectors.toList());
    }

    @Nonnull
    private List<ChannelPermissionKafkaDto> convertToPermissionKafkaDto(Set<PersonId> personIds, String role) {
        return personIds.stream().map(personId -> new ChannelPermissionKafkaDto("PROFILE," + personId.getId(), role)).collect(Collectors.toList());
    }

    private void publishToKafka(ChannelKafkaDto channelKafkaDto) {
        if (this._producer == null) {
            return;
        }
        String channelId = channelKafkaDto.getId();
        this._producer.send(new ProducerRecord("just.toro.migration.news", (Object)channelId, (Object)channelKafkaDto.toTopicJson()));
    }

    private /* synthetic */ void lambda$migrateChannels$0(Set entitiesWhereAllMembersWriter, Set entitiesWhereAllMembersReader, Set migratedChannels, DBEntity channelEntity, TransactionStatus t) {
        this.migrateChannel(entitiesWhereAllMembersWriter, entitiesWhereAllMembersReader, migratedChannels, channelEntity);
    }
}

