/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.model.DBSubscription;
import de.justsoftware.onx.news.migration.newscover.NewsZoomSettingsMigration;
import de.justsoftware.onx.newszoom.integration.persistence.mapper.NewsZoomSettingsMapper;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.polls.model.Poll;
import de.justsoftware.polls.model.pollid.PollId;
import de.justsoftware.polls.persistence.PollDAO;
import de.justsoftware.polls.persistence.mapper.PollMapper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class NewsMigrationDAO {
    private static final Logger LOG = LoggerFactory.getLogger(NewsMigrationDAO.class);
    private static final NullPermeableFunction<DBSubscription, SubscriptionModel> SUBSCRITPION_MODEL_FUNCTION = new NullPermeableFunction<DBSubscription, SubscriptionModel>(){

        @Override
        protected SubscriptionModel applySafe(DBSubscription input) {
            return new SubscriptionModel(input.getItemId(), input.getSubscriber(), input.getState(), input.getType());
        }
    };
    private final StatementBuilderFactory _statementBuilderFactory;
    private final PollMapper _pollMapper;
    private final PollDAO _pollDAO;
    private final NewsZoomSettingsMapper _newsZoomSettingsMapper;

    @Autowired
    public NewsMigrationDAO(StatementBuilderFactory statementBuilderFactory, PollMapper pollMapper, PollDAO pollDAO, NewsZoomSettingsMapper newsZoomSettingsMapper) {
        this._statementBuilderFactory = statementBuilderFactory;
        this._pollMapper = pollMapper;
        this._pollDAO = pollDAO;
        this._newsZoomSettingsMapper = newsZoomSettingsMapper;
    }

    public ImmutableList<SubscriptionModel> getSubscribers(Set<? extends ItemId> items) {
        return ((IbatisPartitionResultBuilder)this._statementBuilderFactory.ibatistStatementBuilder("Like").select("getSubscribersNotDeleted").partition(items)).asList(SUBSCRITPION_MODEL_FUNCTION);
    }

    public ImmutableMap<CommentId, DBComment> getCommentsByItemId(ItemId parentId) {
        return this._statementBuilderFactory.ibatistStatementBuilder("MdlComments").select("getCommentsByItemId").param(parentId).asMap("id", null);
    }

    public Optional<Poll> findPollByWorkstreamMessageId(WorkstreamMessageId id) {
        List<PollId> polls = this._pollMapper.findPollIdByParenId(id.asString());
        if (polls == null || polls.isEmpty()) {
            return Optional.empty();
        }
        if (polls.size() > 1) {
            LOG.warn("Migrating Post with more than 1 Poll, migrating only newest Poll.");
        }
        return this._pollDAO.findPoll(polls.get(0));
    }

    public ImmutableSet<PersonId> getLikesByItemId(ItemId itemId) {
        return this._statementBuilderFactory.ibatistStatementBuilder("Like").select("getLikesByItemId").param(itemId).asSet();
    }

    public ImmutableMap<ItemId, ItemId> getAllMigratedItems(String destinationType) {
        return this._statementBuilderFactory.ibatistStatementBuilder("MigratedItem").select("getAllMigratedEntities").param(destinationType).asMap("origin_id", "destination_id");
    }

    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getEntriesOfTypeMicroblogPosting(Set<WorkstreamMessageId> ids) {
        ImmutableMap res = ((IbatisPartitionResultBuilder)this._statementBuilderFactory.ibatistStatementBuilder("Workstream").select("getEntriesMicroblogPosting").partition(ids)).asMap("id", null);
        if (!res.isEmpty()) {
            this.joinAttributes((Map)res);
        }
        return res;
    }

    public ImmutableSet<WorkstreamMessageId> getAllWorkstreamMessageIdsByOrigins(Set<? extends ItemId> originIds) {
        return ((IbatisPartitionResultBuilder)this._statementBuilderFactory.ibatistStatementBuilder("Workstream").select("getAllWorkstreamMessageIdsByOrigins").partition(originIds)).asSet();
    }

    private <M extends Map<WorkstreamMessageId, DBWorkstreamMessage>> void joinAttributes(@Nonnull M res) {
        ((IbatisPartitionResultBuilder)this._statementBuilderFactory.ibatistStatementBuilder("Workstream").select("getAttributes").partition(res.keySet())).executeWithConsumer(att -> ((DBWorkstreamMessage)res.get(new WorkstreamMessageId(att.getEntryId()))).setAttribute(att.getKey(), att.getValue()));
    }

    public Set<NewsZoomSettingsMigration> getAllNewsZoomSettings() {
        return this._newsZoomSettingsMapper.getAllNewsZoomSettings();
    }
}

