/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.news.migration;

import de.justsoftware.onx.news.migration.channel.ChannelMigrationService;
import de.justsoftware.onx.news.migration.newscover.NewsCoverMigrationService;
import de.justsoftware.onx.news.migration.post.PostMigrationService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class MigrateSnowballUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    public static final String NEWS_MIGRATION_TOPIC = "just.toro.migration.news";
    private static final Logger LOG = LoggerFactory.getLogger(MigrateSnowballUpdateProcessor.class);
    private final ChannelMigrationService _channelMigrationService;
    private final PostMigrationService _postMigrationService;
    private final NewsCoverMigrationService _newsCoverMigrationService;

    @Autowired
    public MigrateSnowballUpdateProcessor(ChannelMigrationService channelMigrationService, PostMigrationService postMigrationService, NewsCoverMigrationService newsCoverMigrationService) {
        this._channelMigrationService = channelMigrationService;
        this._postMigrationService = postMigrationService;
        this._newsCoverMigrationService = newsCoverMigrationService;
    }

    @Override
    @Nonnull
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.MIGRATE_NEWS;
    }

    @Override
    @Nonnull
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.30");
    }

    @Override
    public int getProcessorVersion() {
        return 0;
    }

    @Override
    public void process() {
        LOG.info("Starting migrateSnowball.");
        this._channelMigrationService.migrateChannels();
        this._postMigrationService.migratePosts();
        this._newsCoverMigrationService.migrateNewsCovers();
    }
}

